/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.util.ArrayList;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.BaseLogTable;
import org.pentaho.di.core.logging.JobEntryLogTable;
import org.pentaho.di.core.logging.JobLogTable;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableCoreInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.trans.HasDatabasesInterface;

public class JobTest {
    private static final String STRING_DEFAULT = "<def>";
    private Job mockedJob;
    private Database mockedDataBase;
    private VariableSpace mockedVariableSpace;
    private HasDatabasesInterface hasDatabasesInterface;

    @Before
    public void init() {
        this.mockedDataBase = (Database)Mockito.mock(Database.class);
        this.mockedJob = (Job)Mockito.mock(Job.class);
        this.mockedVariableSpace = (VariableSpace)Mockito.mock(VariableSpace.class);
        this.hasDatabasesInterface = (HasDatabasesInterface)Mockito.mock(HasDatabasesInterface.class);
        Mockito.when((Object)this.mockedJob.createDataBase((DatabaseMeta)Matchers.any(DatabaseMeta.class))).thenReturn((Object)this.mockedDataBase);
    }

    @Test
    public void recordsCleanUpMethodIsCalled_JobEntryLogTable() throws Exception {
        JobEntryLogTable jobEntryLogTable = JobEntryLogTable.getDefault((VariableSpace)this.mockedVariableSpace, (HasDatabasesInterface)this.hasDatabasesInterface);
        this.setAllTableParamsDefault((BaseLogTable)jobEntryLogTable);
        JobMeta jobMeta = new JobMeta();
        jobMeta.setJobEntryLogTable(jobEntryLogTable);
        Mockito.when((Object)this.mockedJob.getJobMeta()).thenReturn((Object)jobMeta);
        ((Job)Mockito.doCallRealMethod().when((Object)this.mockedJob)).writeJobEntryLogInformation();
        this.mockedJob.writeJobEntryLogInformation();
        ((Database)Mockito.verify((Object)this.mockedDataBase)).cleanupLogRecords((LogTableCoreInterface)jobEntryLogTable);
    }

    @Test
    public void recordsCleanUpMethodIsCalled_JobLogTable() throws Exception {
        JobLogTable jobLogTable = JobLogTable.getDefault((VariableSpace)this.mockedVariableSpace, (HasDatabasesInterface)this.hasDatabasesInterface);
        this.setAllTableParamsDefault((BaseLogTable)jobLogTable);
        ((Job)Mockito.doCallRealMethod().when((Object)this.mockedJob)).writeLogTableInformation(jobLogTable, LogStatus.END);
        this.mockedJob.writeLogTableInformation(jobLogTable, LogStatus.END);
        ((Database)Mockito.verify((Object)this.mockedDataBase)).cleanupLogRecords((LogTableCoreInterface)jobLogTable);
    }

    public void setAllTableParamsDefault(BaseLogTable table) {
        table.setSchemaName(STRING_DEFAULT);
        table.setConnectionName(STRING_DEFAULT);
        table.setTimeoutInDays(STRING_DEFAULT);
        table.setTableName(STRING_DEFAULT);
        table.setFields(new ArrayList());
    }
}

