/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.dostounix;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.job.entries.dostounix.JobEntryDosToUnix;

public class JobEntryDosToUnix_ConversionIdempotency_Test {
    private File tmpFile;
    private String tmpFilePath;
    private JobEntryDosToUnix entry;

    @BeforeClass
    public static void init() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.tmpFile = File.createTempFile("pdi-14161-", null);
        this.tmpFilePath = this.tmpFile.toURI().toString();
        this.entry = new JobEntryDosToUnix();
    }

    @After
    public void tearDown() throws Exception {
        if (this.tmpFile != null) {
            this.tmpFile.delete();
            this.tmpFile = null;
        }
        this.tmpFilePath = null;
        this.entry = null;
    }

    @Test
    public void oneSeparator_nix2dos() throws Exception {
        this.doTest("\n", false, "\r\n");
    }

    @Test
    public void oneSeparator_nix2nix() throws Exception {
        this.doTest("\n", true, "\n");
    }

    @Test
    public void oneSeparator_dos2nix() throws Exception {
        this.doTest("\r\n", true, "\n");
    }

    @Test
    public void oneSeparator_dos2dos() throws Exception {
        this.doTest("\r\n", false, "\r\n");
    }

    @Test
    public void charNewLineChar_nix2dos() throws Exception {
        this.doTest("a\nb", false, "a\r\nb");
    }

    @Test
    public void charNewLineChar_nix2nix() throws Exception {
        this.doTest("a\nb", true, "a\nb");
    }

    @Test
    public void charNewLineChar_dos2nix() throws Exception {
        this.doTest("a\r\nb", true, "a\nb");
    }

    @Test
    public void charNewLineChar_dos2dos() throws Exception {
        this.doTest("a\r\nb", false, "a\r\nb");
    }

    @Test
    public void twoCrOneLf_2nix() throws Exception {
        this.doTest("\r\r\n", true, "\r\n");
    }

    @Test
    public void twoCrOneLf_2dos() throws Exception {
        this.doTest("\r\r\n", false, "\r\r\n");
    }

    @Test
    public void crCharCrLf_2nix() throws Exception {
        this.doTest("\ra\r\n", true, "\ra\n");
    }

    @Test
    public void crCharCrLf_2dos() throws Exception {
        this.doTest("\ra\r\n", false, "\ra\r\n");
    }

    @Test
    public void oneSeparator_nix2dos_hugeInput() throws Exception {
        this.doTestForSignificantInput("\n", false, "\r\n");
    }

    @Test
    public void oneSeparator_nix2nix_hugeInput() throws Exception {
        this.doTestForSignificantInput("\n", true, "\n");
    }

    @Test
    public void oneSeparator_dos2nix_hugeInput() throws Exception {
        this.doTestForSignificantInput("\r\n", true, "\n");
    }

    @Test
    public void oneSeparator_dos2dos_hugeInput() throws Exception {
        this.doTestForSignificantInput("\r\n", false, "\r\n");
    }

    private void doTestForSignificantInput(String contentPattern, boolean toUnix, String expectedPattern) throws Exception {
        int copyTimes = 8192 / contentPattern.length() + 1;
        String content = this.copyUntilReachesEightKbs(contentPattern, copyTimes);
        String expected = this.copyUntilReachesEightKbs(expectedPattern, copyTimes);
        this.doTest(content, toUnix, expected);
    }

    private String copyUntilReachesEightKbs(String pattern, int times) {
        StringBuilder sb = new StringBuilder(pattern.length() * times);
        for (int i = 0; i < times; ++i) {
            sb.append(pattern);
        }
        return sb.toString();
    }

    private void doTest(String content, boolean toUnix, String expected) throws Exception {
        try (FileOutputStream os = new FileOutputStream(this.tmpFile);){
            IOUtils.write((byte[])content.getBytes(), (OutputStream)os);
        }
        this.entry.convert(KettleVFS.getFileObject((String)this.tmpFilePath), toUnix);
        String converted = KettleVFS.getTextFileContent((String)this.tmpFilePath, (String)"UTF-8");
        Assert.assertEquals((Object)expected, (Object)converted);
    }
}

