/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.evaluatetablecontent;

import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.InfobrightDatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.evaluatetablecontent.JobEntryEvalTableContent;
import org.pentaho.di.job.entries.evaluatetablecontent.MockDriver;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;

public class JobEntryEvalTableContentTest {
    private static final Map<Class<?>, String> dbMap = new HashMap();
    JobEntryEvalTableContent entry;
    private static PluginInterface mockDbPlugin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        KettleClientEnvironment.init();
        dbMap.put(DatabaseInterface.class, DBMockIface.class.getName());
        dbMap.put(InfobrightDatabaseMeta.class, InfobrightDatabaseMeta.class.getName());
        PluginRegistry preg = PluginRegistry.getInstance();
        mockDbPlugin = (PluginInterface)Mockito.mock(PluginInterface.class);
        Mockito.when((Object)mockDbPlugin.matches(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)mockDbPlugin.isNativePlugin()).thenReturn((Object)true);
        Mockito.when((Object)mockDbPlugin.getMainType()).thenAnswer(new Answer<Class<?>>(){

            public Class<?> answer(InvocationOnMock invocation) throws Throwable {
                return DatabaseInterface.class;
            }
        });
        Mockito.when((Object)mockDbPlugin.getPluginType()).thenAnswer((Answer)new Answer<Class<? extends PluginTypeInterface>>(){

            public Class<? extends PluginTypeInterface> answer(InvocationOnMock invocation) throws Throwable {
                return DatabasePluginType.class;
            }
        });
        Mockito.when((Object)mockDbPlugin.getIds()).thenReturn((Object)new String[]{"Oracle", "mock-db-id"});
        Mockito.when((Object)mockDbPlugin.getName()).thenReturn((Object)"mock-db-name");
        Mockito.when((Object)mockDbPlugin.getClassMap()).thenReturn(dbMap);
        preg.registerPlugin(DatabasePluginType.class, mockDbPlugin);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        PluginRegistry.getInstance().removePlugin(DatabasePluginType.class, mockDbPlugin);
    }

    @Before
    public void setUp() throws Exception {
        MockDriver.registerInstance();
        Job job = new Job(null, new JobMeta());
        this.entry = new JobEntryEvalTableContent();
        job.getJobMeta().addJobEntry(new JobEntryCopy((JobEntryInterface)this.entry));
        this.entry.setParentJob(job);
        job.setStopped(false);
        DatabaseMeta dbMeta = new DatabaseMeta();
        dbMeta.setDatabaseType("mock-db");
        this.entry.setDatabase(dbMeta);
    }

    @After
    public void tearDown() throws Exception {
        MockDriver.deregeisterInstances();
    }

    @Test
    public void testNrErrorsFailureNewBehavior() throws Exception {
        this.entry.limit = "1";
        this.entry.successCondition = 0;
        this.entry.tablename = "table";
        Result res = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"Eval number of rows should fail", (boolean)res.getResult());
        Assert.assertEquals((String)"No errors should be reported in result object accoding to the new behavior", (long)res.getNrErrors(), (long)0L);
    }

    @Test
    public void testNrErrorsFailureOldBehavior() throws Exception {
        this.entry.limit = "1";
        this.entry.successCondition = 0;
        this.entry.tablename = "table";
        this.entry.setVariable("KETTLE_COMPATIBILITY_SET_ERROR_ON_SPECIFIC_JOB_ENTRIES", "Y");
        Result res = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"Eval number of rows should fail", (boolean)res.getResult());
        Assert.assertEquals((String)"An error should be reported in result object accoding to the old behavior", (long)res.getNrErrors(), (long)1L);
    }

    @Test
    public void testNrErrorsSuccess() throws Exception {
        this.entry.limit = "5";
        this.entry.successCondition = 0;
        this.entry.tablename = "table";
        Result res = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Eval number of rows should be suceeded", (boolean)res.getResult());
        Assert.assertEquals((String)"Apparently there should no error", (long)res.getNrErrors(), (long)0L);
        this.entry.setVariable("KETTLE_COMPATIBILITY_SET_ERROR_ON_SPECIFIC_JOB_ENTRIES", "Y");
        res = this.entry.execute(new Result(), 0);
        Assert.assertTrue((String)"Eval number of rows should be suceeded", (boolean)res.getResult());
        Assert.assertEquals((String)"Apparently there should no error", (long)res.getNrErrors(), (long)0L);
    }

    @Test
    public void testNrErrorsNoCustomSql() throws Exception {
        this.entry.limit = "5";
        this.entry.successCondition = 0;
        this.entry.iscustomSQL = true;
        this.entry.customSQL = null;
        Result res = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"Eval number of rows should fail", (boolean)res.getResult());
        Assert.assertEquals((String)"Apparently there should be an error", (long)res.getNrErrors(), (long)1L);
        this.entry.setVariable("KETTLE_COMPATIBILITY_SET_ERROR_ON_SPECIFIC_JOB_ENTRIES", "Y");
        res = this.entry.execute(new Result(), 0);
        Assert.assertFalse((String)"Eval number of rows should fail", (boolean)res.getResult());
        Assert.assertEquals((String)"Apparently there should be an error", (long)res.getNrErrors(), (long)1L);
    }

    public static class DBMockIface
    extends BaseDatabaseMeta {
        public Object clone() {
            return this;
        }

        public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
            return null;
        }

        public String getDriverClass() {
            return "org.pentaho.di.job.entries.evaluatetablecontent.MockDriver";
        }

        public String getURL(String hostname, String port, String databaseName) throws KettleDatabaseException {
            return "";
        }

        public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
            return null;
        }

        public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
            return null;
        }

        public String[] getUsedLibraries() {
            return null;
        }

        public int[] getAccessTypeList() {
            return null;
        }
    }
}

