/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.getpop;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.entries.getpop.JobEntryGetPOP;
import org.pentaho.di.job.entries.getpop.MailConnection;
import org.pentaho.di.utils.TestUtils;

public class JobEntryGetPOPTest {
    @Mock
    MailConnection mailConn;
    @Mock
    Job parentJob;
    @Mock
    Message message;
    JobEntryGetPOP entry = new JobEntryGetPOP();

    @Before
    public void before() throws IOException, KettleException, MessagingException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.parentJob.getLogLevel()).thenReturn((Object)LogLevel.BASIC);
        this.entry.setParentJob(this.parentJob);
        this.entry.setSaveMessage(true);
        Mockito.when((Object)this.message.getMessageNumber()).thenReturn((Object)1);
        Mockito.when((Object)this.message.getContent()).thenReturn(this.createMessageContent());
        Mockito.when((Object)this.mailConn.getMessage()).thenReturn((Object)this.message);
        ((MailConnection)Mockito.doNothing().when((Object)this.mailConn)).openFolder(Mockito.anyBoolean());
        ((MailConnection)Mockito.doNothing().when((Object)this.mailConn)).openFolder(Mockito.anyString(), Mockito.anyBoolean());
        Mockito.when((Object)this.mailConn.getMessagesCount()).thenReturn((Object)1);
    }

    private Object createMessageContent() throws IOException, MessagingException {
        MimeMultipart content = new MimeMultipart();
        MimeBodyPart contentText = new MimeBodyPart();
        contentText.setText("Hello World!");
        content.addBodyPart((BodyPart)contentText);
        MimeBodyPart contentFile = new MimeBodyPart();
        File testFile = TestUtils.getInputFile("GetPOP", "txt");
        FileDataSource fds = new FileDataSource(testFile.getAbsolutePath());
        contentFile.setDataHandler(new DataHandler((DataSource)fds));
        contentFile.setFileName(testFile.getName());
        content.addBodyPart((BodyPart)contentFile);
        return content;
    }

    @Test
    public void testFetchOneFolderModePop3() throws KettleException, MessagingException {
        this.entry.fetchOneFolder(this.mailConn, true, "junitImapFolder", "junitRealOutputFolder", "junitTargetAttachmentFolder", "junitRealMoveToIMAPFolder", "junitRealFilenamePattern", 0, (SimpleDateFormat)Mockito.mock(SimpleDateFormat.class));
        ((MailConnection)Mockito.verify((Object)this.mailConn)).openFolder(true);
        ((Message)Mockito.verify((Object)this.message)).setFlag(Flags.Flag.SEEN, true);
    }

    @Test
    public void testFetchOneFolderModeIMAPWithNonDefFolder() throws KettleException, MessagingException {
        this.entry.fetchOneFolder(this.mailConn, false, "junitImapFolder", "junitRealOutputFolder", "junitTargetAttachmentFolder", "junitRealMoveToIMAPFolder", "junitRealFilenamePattern", 0, (SimpleDateFormat)Mockito.mock(SimpleDateFormat.class));
        ((MailConnection)Mockito.verify((Object)this.mailConn)).openFolder("junitImapFolder", true);
        ((Message)Mockito.verify((Object)this.message)).setFlag(Flags.Flag.SEEN, true);
    }

    @Test
    public void testFetchOneFolderModeIMAPWithIsDefFolder() throws KettleException, MessagingException {
        this.entry.fetchOneFolder(this.mailConn, false, null, "junitRealOutputFolder", "junitTargetAttachmentFolder", "junitRealMoveToIMAPFolder", "junitRealFilenamePattern", 0, (SimpleDateFormat)Mockito.mock(SimpleDateFormat.class));
        ((MailConnection)Mockito.verify((Object)this.mailConn)).openFolder(true);
        ((Message)Mockito.verify((Object)this.message)).setFlag(Flags.Flag.SEEN, true);
    }

    @Test
    public void testCreateSameAttachmentsFolder() throws IOException {
        File attachmentsDir = new File(TestUtils.createTempDir());
        attachmentsDir.deleteOnExit();
        this.entry.setCreateLocalFolder(true);
        this.entry.setSaveAttachment(true);
        this.entry.setOutputDirectory(attachmentsDir.getAbsolutePath());
        this.entry.setDifferentFolderForAttachment(false);
        String outputFolderName = "";
        String attachmentsFolderName = "";
        try {
            outputFolderName = this.entry.createOutputDirectory(0);
            attachmentsFolderName = this.entry.createOutputDirectory(1);
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create folder " + e.getLocalizedMessage()));
        }
        Assert.assertTrue((String)"Output Folder should be a local path", (!Const.isEmpty((String)outputFolderName) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Attachment Folder should be a local path", (!Const.isEmpty((String)attachmentsFolderName) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Output and Attachment Folder should match", (boolean)outputFolderName.equals(attachmentsFolderName));
    }

    @Test
    public void testCreateDifferentAttachmentsFolder() throws IOException {
        File outputDir = new File(TestUtils.createTempDir());
        File attachmentsDir = new File(TestUtils.createTempDir());
        this.entry.setCreateLocalFolder(true);
        this.entry.setSaveAttachment(true);
        this.entry.setOutputDirectory(outputDir.getAbsolutePath());
        this.entry.setDifferentFolderForAttachment(true);
        this.entry.setAttachmentFolder(attachmentsDir.getAbsolutePath());
        String outputFolderName = "";
        String attachmentsFolderName = "";
        try {
            outputFolderName = this.entry.createOutputDirectory(0);
            attachmentsFolderName = this.entry.createOutputDirectory(1);
        }
        catch (Exception e) {
            Assert.fail((String)("Could not create folder: " + e.getLocalizedMessage()));
        }
        Assert.assertTrue((String)"Output Folder should be a local path", (!Const.isEmpty((String)outputFolderName) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Attachment Folder should be a local path", (!Const.isEmpty((String)attachmentsFolderName) ? 1 : 0) != 0);
        Assert.assertFalse((String)"Output and Attachment Folder should not match", (boolean)outputFolderName.equals(attachmentsFolderName));
    }

    @Test
    public void testFolderIsNotCreatedWhenCreateFolderSettingIsDisabled() throws IOException {
        File outputDir = new File(TestUtils.createTempDir());
        File attachmentsDir = new File(TestUtils.createTempDir());
        outputDir.delete();
        attachmentsDir.delete();
        this.entry.setCreateLocalFolder(false);
        this.entry.setSaveAttachment(true);
        this.entry.setOutputDirectory(outputDir.getAbsolutePath());
        this.entry.setDifferentFolderForAttachment(true);
        this.entry.setAttachmentFolder(attachmentsDir.getAbsolutePath());
        try {
            this.entry.createOutputDirectory(0);
            Assert.fail((String)"A KettleException should have been thrown");
        }
        catch (Exception e) {
            if (e instanceof KettleException) {
                Assert.assertTrue((String)"Output Folder should not be created", (boolean)BaseMessages.getString(JobEntryGetPOP.class, (String)"JobGetMailsFromPOP.Error.OutputFolderNotExist", (String[])new String[]{outputDir.getAbsolutePath()}).equals(Const.trim((String)e.getMessage())));
            }
            Assert.fail((String)("Output Folder should not have been created: " + e.getLocalizedMessage()));
        }
        try {
            this.entry.createOutputDirectory(1);
            Assert.fail((String)"A KettleException should have been thrown");
        }
        catch (Exception e) {
            if (e instanceof KettleException) {
                Assert.assertTrue((String)"Output Folder should not be created", (boolean)BaseMessages.getString(JobEntryGetPOP.class, (String)"JobGetMailsFromPOP.Error.AttachmentFolderNotExist", (String[])new String[]{attachmentsDir.getAbsolutePath()}).equals(Const.trim((String)e.getMessage())));
            }
            Assert.fail((String)("Attachments Folder should not have been created: " + e.getLocalizedMessage()));
        }
    }

    @Test
    public void testEnvVariablesAreSubstitutedForFolders() {
        String outputVariableName = "myOutputVar";
        String outputVariableValue = "myOutputFolder";
        String attachmentVariableName = "myAttachmentVar";
        String attachmentVariableValue = "myOutputFolder";
        this.entry.setVariable(outputVariableName, outputVariableValue);
        this.entry.setVariable(attachmentVariableName, attachmentVariableValue);
        String tempDirBase = TestUtils.createTempDir();
        File outputDir = new File(tempDirBase, outputVariableValue);
        outputDir.mkdir();
        File attachmentDir = new File(tempDirBase, attachmentVariableValue);
        attachmentDir.mkdir();
        String outputDirWithVariable = tempDirBase + File.separator + "${" + outputVariableName + "}";
        String attachmentDirWithVariable = tempDirBase + File.separator + "${" + attachmentVariableName + "}";
        this.entry.setOutputDirectory(outputDirWithVariable);
        this.entry.setAttachmentFolder(attachmentDirWithVariable);
        Assert.assertTrue((String)"Error in Direct substitute test for output directory", (boolean)outputDir.toString().equals(this.entry.getRealOutputDirectory()));
        Assert.assertTrue((String)"Error in Direct substitute test for  attachment directory", (boolean)attachmentDir.toString().equals(this.entry.getRealAttachmentFolder()));
        try {
            String outputRes = this.entry.createOutputDirectory(0);
            Assert.assertTrue((String)"Variables not working in createOutputDirectory: output directory", (boolean)outputRes.equals(outputDir.toString()));
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected exception when calling createOutputDirectory for output directory");
        }
        try {
            String attachOutputRes = this.entry.createOutputDirectory(1);
            Assert.assertTrue((String)"Variables not working in createOutputDirectory: attachment with options false", (boolean)attachOutputRes.equals(outputDir.toString()));
            this.entry.setSaveAttachment(true);
            this.entry.setDifferentFolderForAttachment(true);
            String attachRes = this.entry.createOutputDirectory(1);
            Assert.assertTrue((String)"Variables not working in createOutputDirectory: attachment with options true", (boolean)attachRes.equals(outputDir.toString()));
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected exception when calling createOutputDirectory for attachment directory");
        }
    }
}

