/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.job;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JobEntryJobTest {
    private final String JOB_ENTRY_JOB_NAME = "JobEntryJobName";
    private final String JOB_ENTRY_FILE_NAME = "JobEntryFileName";
    private final String JOB_ENTRY_FILE_DIRECTORY = "JobEntryFileDirectory";
    private final String JOB_ENTRY_DESCRIPTION = "JobEntryDescription";

    public Node getEntryNode(boolean includeJobname, ObjectLocationSpecificationMethod method) throws ParserConfigurationException, SAXException, IOException {
        JobEntryJob jobEntryJob = this.getJobEntryJob();
        jobEntryJob.setDescription("JobEntryDescription");
        jobEntryJob.setFileName("JobEntryFileName");
        jobEntryJob.setDirectory("JobEntryFileDirectory");
        if (includeJobname) {
            jobEntryJob.setJobName("JobEntryFileName");
        }
        if (method != null) {
            jobEntryJob.setSpecificationMethod(method);
        }
        String string = "<job>" + jobEntryJob.getXML() + "</job>";
        ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(stream);
        Node entryNode = doc.getFirstChild();
        return entryNode;
    }

    private JobEntryJob getJobEntryJob() {
        JobEntryJob jobEntryJob = new JobEntryJob("JobEntryJobName");
        return jobEntryJob;
    }

    private void testJobEntry(Repository rep, boolean includeJobName, ObjectLocationSpecificationMethod method, ObjectLocationSpecificationMethod expectedMethod) throws KettleXMLException, ParserConfigurationException, SAXException, IOException {
        List databases = (List)Mockito.mock(List.class);
        List slaveServers = (List)Mockito.mock(List.class);
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        JobEntryJob jobEntryJob = this.getJobEntryJob();
        jobEntryJob.loadXML(this.getEntryNode(includeJobName, method), databases, slaveServers, rep, metaStore);
        Assert.assertEquals((String)"If we connect to repository then we use rep_name method", (Object)expectedMethod, (Object)jobEntryJob.getSpecificationMethod());
    }

    @Test
    public void testChooseSpecMethodByRepositoryConnectionStatus() throws KettleXMLException, ParserConfigurationException, SAXException, IOException {
        Repository rep = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)rep.isConnected()).thenReturn((Object)true);
        this.testJobEntry(null, false, null, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(null, false, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.testJobEntry(null, false, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(null, false, ObjectLocationSpecificationMethod.FILENAME, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(null, true, null, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(null, true, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.testJobEntry(null, true, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(null, true, ObjectLocationSpecificationMethod.FILENAME, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(rep, false, null, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(rep, false, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.testJobEntry(rep, false, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(rep, false, ObjectLocationSpecificationMethod.FILENAME, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(rep, true, null, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(rep, true, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(rep, true, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(rep, true, ObjectLocationSpecificationMethod.FILENAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
    }
}

