/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.RepositoryMeta;

public class RepositoriesMetaTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        if (!KettleEnvironment.isInitialized()) {
            KettleEnvironment.init();
        }
    }

    @Test
    public void testToString() throws Exception {
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        Assert.assertEquals((Object)"RepositoriesMeta", (Object)repositoriesMeta.toString());
    }

    @Test
    public void testReadData() throws Exception {
        RepositoriesMeta meta = new RepositoriesMeta();
        RepositoriesMeta spy = (RepositoriesMeta)Mockito.spy((Object)meta);
        LogChannel log = (LogChannel)Mockito.mock(LogChannel.class);
        Mockito.when((Object)spy.getKettleUserRepositoriesFile()).thenReturn((Object)this.getClass().getResource("repositories.xml").getPath());
        Mockito.when((Object)spy.newLogChannel()).thenReturn((Object)log);
        spy.readData();
        String repositoriesXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + Const.CR + "<repositories>" + Const.CR + "  <connection>" + Const.CR + "    <name>local postgres</name>" + Const.CR + "    <server>localhost</server>" + Const.CR + "    <type>POSTGRESQL</type>" + Const.CR + "    <access>Native</access>" + Const.CR + "    <database>hibernate</database>" + Const.CR + "    <port>5432</port>" + Const.CR + "    <username>auser</username>" + Const.CR + "    <password>Encrypted 2be98afc86aa7f285bb18bd63c99dbdde</password>" + Const.CR + "    <servername/>" + Const.CR + "    <data_tablespace/>" + Const.CR + "    <index_tablespace/>" + Const.CR + "    <attributes>" + Const.CR + "      <attribute><code>FORCE_IDENTIFIERS_TO_LOWERCASE</code><attribute>N</attribute></attribute>" + Const.CR + "      <attribute><code>FORCE_IDENTIFIERS_TO_UPPERCASE</code><attribute>N</attribute></attribute>" + Const.CR + "      <attribute><code>IS_CLUSTERED</code><attribute>N</attribute></attribute>" + Const.CR + "      <attribute><code>PORT_NUMBER</code><attribute>5432</attribute></attribute>" + Const.CR + "      <attribute><code>PRESERVE_RESERVED_WORD_CASE</code><attribute>N</attribute></attribute>" + Const.CR + "      <attribute><code>QUOTE_ALL_FIELDS</code><attribute>N</attribute></attribute>" + Const.CR + "      <attribute><code>SUPPORTS_BOOLEAN_DATA_TYPE</code><attribute>Y</attribute></attribute>" + Const.CR + "      <attribute><code>SUPPORTS_TIMESTAMP_DATA_TYPE</code><attribute>Y</attribute></attribute>" + Const.CR + "      <attribute><code>USE_POOLING</code><attribute>N</attribute></attribute>" + Const.CR + "    </attributes>" + Const.CR + "  </connection>" + Const.CR + "  <repository>    <id>KettleFileRepository</id>" + Const.CR + "    <name>Test Repository</name>" + Const.CR + "    <description>Test Repository Description</description>" + Const.CR + "    <base_directory>test-repository</base_directory>" + Const.CR + "    <read_only>N</read_only>" + Const.CR + "    <hides_hidden_files>N</hides_hidden_files>" + Const.CR + "  </repository>  </repositories>" + Const.CR;
        Assert.assertEquals((Object)repositoriesXml, (Object)spy.getXML());
        RepositoriesMeta clone = spy.clone();
        Assert.assertEquals((Object)repositoriesXml, (Object)spy.getXML());
        Assert.assertNotSame((Object)clone, (Object)spy);
        Assert.assertEquals((long)1L, (long)spy.nrRepositories());
        RepositoryMeta repository = spy.getRepository(0);
        Assert.assertEquals((Object)"Test Repository", (Object)repository.getName());
        Assert.assertEquals((Object)"Test Repository Description", (Object)repository.getDescription());
        Assert.assertEquals((Object)("  <repository>    <id>KettleFileRepository</id>" + Const.CR + "    <name>Test Repository</name>" + Const.CR + "    <description>Test Repository Description</description>" + Const.CR + "    <base_directory>test-repository</base_directory>" + Const.CR + "    <read_only>N</read_only>" + Const.CR + "    <hides_hidden_files>N</hides_hidden_files>" + Const.CR + "  </repository>"), (Object)repository.getXML());
        Assert.assertSame((Object)repository, (Object)spy.searchRepository("Test Repository"));
        Assert.assertSame((Object)repository, (Object)spy.findRepositoryById("KettleFileRepository"));
        Assert.assertSame((Object)repository, (Object)spy.findRepository("Test Repository"));
        Assert.assertNull((Object)spy.findRepository("not found"));
        Assert.assertNull((Object)spy.findRepositoryById("not found"));
        Assert.assertEquals((long)0L, (long)spy.indexOfRepository(repository));
        spy.removeRepository(0);
        Assert.assertEquals((long)0L, (long)spy.nrRepositories());
        Assert.assertNull((Object)spy.searchRepository("Test Repository"));
        spy.addRepository(0, repository);
        Assert.assertEquals((long)1L, (long)spy.nrRepositories());
        spy.removeRepository(1);
        Assert.assertEquals((long)1L, (long)spy.nrRepositories());
        Assert.assertEquals((long)1L, (long)spy.nrDatabases());
        Assert.assertEquals((Object)"local postgres", (Object)spy.getDatabase(0).getName());
        DatabaseMeta searchDatabase = spy.searchDatabase("local postgres");
        Assert.assertSame((Object)searchDatabase, (Object)spy.getDatabase(0));
        Assert.assertEquals((long)0L, (long)spy.indexOfDatabase(searchDatabase));
        spy.removeDatabase(0);
        Assert.assertEquals((long)0L, (long)spy.nrDatabases());
        Assert.assertNull((Object)spy.searchDatabase("local postgres"));
        spy.addDatabase(0, searchDatabase);
        Assert.assertEquals((long)1L, (long)spy.nrDatabases());
        spy.removeDatabase(1);
        Assert.assertEquals((long)1L, (long)spy.nrDatabases());
        Assert.assertEquals((Object)"Unable to read repository with id [junk]. RepositoryMeta is not available.", (Object)spy.getErrorMessage());
    }

    @Test
    public void testNothingToRead() throws Exception {
        RepositoriesMeta meta = new RepositoriesMeta();
        RepositoriesMeta spy = (RepositoriesMeta)Mockito.spy((Object)meta);
        LogChannel log = (LogChannel)Mockito.mock(LogChannel.class);
        Mockito.when((Object)spy.getKettleUserRepositoriesFile()).thenReturn((Object)"filedoesnotexist.xml");
        Mockito.when((Object)spy.newLogChannel()).thenReturn((Object)log);
        Assert.assertTrue((boolean)spy.readData());
        Assert.assertEquals((long)0L, (long)spy.nrDatabases());
        Assert.assertEquals((long)0L, (long)spy.nrRepositories());
    }

    @Test
    public void testReadDataFromInputStream() throws Exception {
        RepositoriesMeta meta = new RepositoriesMeta();
        RepositoriesMeta spy = (RepositoriesMeta)Mockito.spy((Object)meta);
        LogChannel log = (LogChannel)Mockito.mock(LogChannel.class);
        Mockito.when((Object)spy.newLogChannel()).thenReturn((Object)log);
        InputStream inputStream = this.getClass().getResourceAsStream("repositories.xml");
        spy.readDataFromInputStream(inputStream);
        Assert.assertEquals((long)1L, (long)spy.nrDatabases());
        Assert.assertEquals((long)1L, (long)spy.nrRepositories());
    }

    @Test
    public void testErrorReadingInputStream() throws Exception {
        RepositoriesMeta meta = new RepositoriesMeta();
        RepositoriesMeta spy = (RepositoriesMeta)Mockito.spy((Object)meta);
        LogChannel log = (LogChannel)Mockito.mock(LogChannel.class);
        Mockito.when((Object)spy.newLogChannel()).thenReturn((Object)log);
        try {
            spy.readDataFromInputStream(this.getClass().getResourceAsStream("filedoesnotexist.xml"));
        }
        catch (KettleException e) {
            Assert.assertEquals((Object)(Const.CR + "Error reading information from file:" + Const.CR + "InputStream cannot be null" + Const.CR), (Object)e.getMessage());
        }
    }

    @Test
    public void testErrorReadingFile() throws Exception {
        RepositoriesMeta meta = new RepositoriesMeta();
        RepositoriesMeta spy = (RepositoriesMeta)Mockito.spy((Object)meta);
        LogChannel log = (LogChannel)Mockito.mock(LogChannel.class);
        Mockito.when((Object)spy.newLogChannel()).thenReturn((Object)log);
        Mockito.when((Object)spy.getKettleUserRepositoriesFile()).thenReturn((Object)this.getClass().getResource("bad-repositories.xml").getPath());
        try {
            spy.readData();
        }
        catch (KettleException e) {
            Assert.assertEquals((Object)(Const.CR + "Error reading information from file:" + Const.CR + "The element type \"repositories\" must be terminated by the matching end-tag \"</repositories>\"." + Const.CR), (Object)e.getMessage());
        }
    }

    @Test
    public void testWriteFile() throws Exception {
        RepositoriesMeta meta = new RepositoriesMeta();
        RepositoriesMeta spy = (RepositoriesMeta)Mockito.spy((Object)meta);
        LogChannel log = (LogChannel)Mockito.mock(LogChannel.class);
        Mockito.when((Object)spy.newLogChannel()).thenReturn((Object)log);
        String path = this.getClass().getResource("repositories.xml").getPath().replace("repositories.xml", "new-repositories.xml");
        Mockito.when((Object)spy.getKettleUserRepositoriesFile()).thenReturn((Object)path);
        spy.writeData();
        InputStream resourceAsStream = this.getClass().getResourceAsStream("new-repositories.xml");
        Assert.assertEquals((Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + Const.CR + "<repositories>" + Const.CR + "  </repositories>" + Const.CR), (Object)IOUtils.toString((InputStream)resourceAsStream));
        new File(path).delete();
    }

    @Test
    public void testErrorWritingFile() throws Exception {
        RepositoriesMeta meta = new RepositoriesMeta();
        RepositoriesMeta spy = (RepositoriesMeta)Mockito.spy((Object)meta);
        LogChannel log = (LogChannel)Mockito.mock(LogChannel.class);
        Mockito.when((Object)spy.newLogChannel()).thenReturn((Object)log);
        Mockito.when((Object)spy.getKettleUserRepositoriesFile()).thenReturn(null);
        try {
            spy.writeData();
        }
        catch (KettleException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith(Const.CR + "Error writing repositories metadata"));
        }
    }
}

