/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.RepositoryCommonValidations;
import org.pentaho.di.repository.UserInfo;

public class RepositoryCommonValidationsTest {
    @Test(expected=NullPointerException.class)
    public void checkUserInfo_Null() {
        RepositoryCommonValidations.checkUserInfo(null);
    }

    @Test
    public void checkUserInfo_LoginIsNull() {
        Assert.assertFalse((boolean)RepositoryCommonValidations.checkUserInfo((IUser)RepositoryCommonValidationsTest.user(null, "name")));
    }

    @Test
    public void checkUserInfo_LoginIsBlank() {
        Assert.assertFalse((boolean)RepositoryCommonValidations.checkUserInfo((IUser)RepositoryCommonValidationsTest.user("", "name")));
    }

    @Test
    public void checkUserInfo_LoginContainsSpaces() {
        Assert.assertFalse((boolean)RepositoryCommonValidations.checkUserInfo((IUser)RepositoryCommonValidationsTest.user("  \t\n ", "name")));
    }

    @Test
    public void checkUserInfo_BothAreMeaningful() {
        Assert.assertTrue((boolean)RepositoryCommonValidations.checkUserInfo((IUser)RepositoryCommonValidationsTest.user("login", "name")));
    }

    @Test(expected=NullPointerException.class)
    public void normalizeUserInfo_Null() {
        RepositoryCommonValidations.normalizeUserInfo(null);
    }

    @Test
    public void normalizeUserInfo_Valid() {
        IUser normalized = RepositoryCommonValidations.normalizeUserInfo((IUser)RepositoryCommonValidationsTest.user("login", "name"));
        Assert.assertEquals((Object)"login", (Object)normalized.getLogin());
        Assert.assertEquals((Object)"login", (Object)normalized.getName());
    }

    @Test
    public void normalizeUserInfo_WithSpaces() {
        IUser normalized = RepositoryCommonValidations.normalizeUserInfo((IUser)RepositoryCommonValidationsTest.user("  login \t\n ", "name"));
        Assert.assertEquals((Object)"login", (Object)normalized.getLogin());
        Assert.assertEquals((Object)"login", (Object)normalized.getName());
    }

    private static IUser user(String login, String name) {
        return new UserInfo(login, null, name, name, true);
    }
}

