/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImportFeedbackInterface;
import org.pentaho.di.repository.RepositoryImporter;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.pentaho.di.trans.steps.metainject.MetaInjectMeta;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositoryImporterTest {
    private static final String ROOT_PATH = "/test_root";
    private static final String USER_NAME_PATH = "/userName";
    @Mock
    private RepositoryImportFeedbackInterface feedback;
    private RepositoryDirectoryInterface baseDirectory;
    private Node entityNode;

    @Before
    public void beforeTest() {
        NodeList nodeList = (NodeList)Mockito.mock(NodeList.class);
        this.entityNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.entityNode.getChildNodes()).thenReturn((Object)nodeList);
        this.baseDirectory = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)this.baseDirectory.getPath()).thenReturn((Object)ROOT_PATH);
    }

    @Test
    public void testImportJob_patchJobEntries_without_variables() throws KettleException {
        JobEntryTrans jobEntryTrans = RepositoryImporterTest.createJobEntryTrans(USER_NAME_PATH);
        MappingMeta mappingMeta = RepositoryImporterTest.createMappingMeta();
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryTrans, mappingMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importJob(this.entityNode, this.feedback);
        ((JobEntryTrans)Mockito.verify((Object)jobEntryTrans)).setDirectory("/test_root/userName");
    }

    @Test
    public void testImportJob_patchJobEntries_with_variable() throws KettleException {
        JobEntryTrans jobEntryTrans = RepositoryImporterTest.createJobEntryTrans("${USER_VARIABLE}");
        MappingMeta mappingMeta = RepositoryImporterTest.createMappingMeta();
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryTrans, mappingMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importJob(this.entityNode, this.feedback);
        ((JobEntryTrans)Mockito.verify((Object)jobEntryTrans)).setDirectory("${USER_VARIABLE}");
    }

    @Test
    public void testImportJob_patchJobEntries_when_directory_path_starts_with_variable() throws KettleException {
        JobEntryTrans jobEntryTrans = RepositoryImporterTest.createJobEntryTrans("${USER_VARIABLE}/myDir");
        MappingMeta mappingMeta = RepositoryImporterTest.createMappingMeta();
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryTrans, mappingMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importJob(this.entityNode, this.feedback);
        ((JobEntryTrans)Mockito.verify((Object)jobEntryTrans)).setDirectory("${USER_VARIABLE}/myDir");
        JobEntryTrans jobEntryTrans2 = RepositoryImporterTest.createJobEntryTrans("${USER_VARIABLE}/myDir");
        RepositoryImporter importerWithCompatibilityImportPath = RepositoryImporterTest.createRepositoryImporter(jobEntryTrans2, mappingMeta, false);
        importerWithCompatibilityImportPath.setBaseDirectory(this.baseDirectory);
        importerWithCompatibilityImportPath.importJob(this.entityNode, this.feedback);
        ((JobEntryTrans)Mockito.verify((Object)jobEntryTrans2)).setDirectory("/test_root/${USER_VARIABLE}/myDir");
    }

    @Test
    public void testImportJob_patchJobEntries_when_directory_path_ends_with_variable() throws KettleException {
        JobEntryTrans jobEntryTrans = RepositoryImporterTest.createJobEntryTrans("/myDir/${USER_VARIABLE}");
        MappingMeta mappingMeta = RepositoryImporterTest.createMappingMeta();
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryTrans, mappingMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importJob(this.entityNode, this.feedback);
        ((JobEntryTrans)Mockito.verify((Object)jobEntryTrans)).setDirectory("/myDir/${USER_VARIABLE}");
        JobEntryTrans jobEntryTrans2 = RepositoryImporterTest.createJobEntryTrans("/myDir/${USER_VARIABLE}");
        RepositoryImporter importerWithCompatibilityImportPath = RepositoryImporterTest.createRepositoryImporter(jobEntryTrans2, mappingMeta, false);
        importerWithCompatibilityImportPath.setBaseDirectory(this.baseDirectory);
        importerWithCompatibilityImportPath.importJob(this.entityNode, this.feedback);
        ((JobEntryTrans)Mockito.verify((Object)jobEntryTrans2)).setDirectory("/test_root/myDir/${USER_VARIABLE}");
    }

    @Test
    public void testImportTrans_patchTransEntries_without_variables() throws KettleException {
        JobEntryTrans jobEntryTrans = RepositoryImporterTest.createJobEntryTrans();
        MappingMeta mappingMeta = RepositoryImporterTest.createMappingMeta(USER_NAME_PATH);
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryTrans, mappingMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importTransformation(this.entityNode, this.feedback);
        ((MappingMeta)Mockito.verify((Object)mappingMeta)).setDirectoryPath("/test_root/userName");
    }

    @Test
    public void testImportTrans_patchTransEntries_with_variable() throws KettleException {
        JobEntryTrans jobEntryTrans = RepositoryImporterTest.createJobEntryTrans();
        MappingMeta mappingMeta = RepositoryImporterTest.createMappingMeta("${USER_VARIABLE}");
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryTrans, mappingMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importTransformation(this.entityNode, this.feedback);
        ((MappingMeta)Mockito.verify((Object)mappingMeta)).setDirectoryPath("${USER_VARIABLE}");
    }

    @Test
    public void testImportTrans_patchTransEntries_when_directory_path_starts_with_variable() throws KettleException {
        JobEntryTrans jobEntryTrans = RepositoryImporterTest.createJobEntryTrans();
        MappingMeta mappingMeta = RepositoryImporterTest.createMappingMeta("${USER_VARIABLE}/myDir");
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryTrans, mappingMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importTransformation(this.entityNode, this.feedback);
        ((MappingMeta)Mockito.verify((Object)mappingMeta)).setDirectoryPath("${USER_VARIABLE}/myDir");
        MappingMeta mappingMeta2 = RepositoryImporterTest.createMappingMeta("${USER_VARIABLE}/myDir");
        RepositoryImporter importerWithCompatibilityImportPath = RepositoryImporterTest.createRepositoryImporter(jobEntryTrans, mappingMeta2, false);
        importerWithCompatibilityImportPath.setBaseDirectory(this.baseDirectory);
        importerWithCompatibilityImportPath.importTransformation(this.entityNode, this.feedback);
        ((MappingMeta)Mockito.verify((Object)mappingMeta2)).setDirectoryPath("/test_root/${USER_VARIABLE}/myDir");
    }

    @Test
    public void testImportTrans_patchTransEntries_when_directory_path_ends_with_variable() throws KettleException {
        JobEntryTrans jobEntryTrans = RepositoryImporterTest.createJobEntryTrans();
        MappingMeta mappingMeta = RepositoryImporterTest.createMappingMeta("/myDir/${USER_VARIABLE}");
        RepositoryImporter importer = RepositoryImporterTest.createRepositoryImporter(jobEntryTrans, mappingMeta, true);
        importer.setBaseDirectory(this.baseDirectory);
        importer.importTransformation(this.entityNode, this.feedback);
        ((MappingMeta)Mockito.verify((Object)mappingMeta)).setDirectoryPath("/myDir/${USER_VARIABLE}");
        MappingMeta mappingMeta2 = RepositoryImporterTest.createMappingMeta("/myDir/${USER_VARIABLE}");
        RepositoryImporter importerWithCompatibilityImportPath = RepositoryImporterTest.createRepositoryImporter(jobEntryTrans, mappingMeta2, false);
        importerWithCompatibilityImportPath.setBaseDirectory(this.baseDirectory);
        importerWithCompatibilityImportPath.importTransformation(this.entityNode, this.feedback);
        ((MappingMeta)Mockito.verify((Object)mappingMeta2)).setDirectoryPath("/test_root/myDir/${USER_VARIABLE}");
    }

    @Test
    public void testPatchTransSteps_with_meta_inject_step() {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        LogChannelInterface log = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        RepositoryImporter importer = (RepositoryImporter)Mockito.spy((Object)new RepositoryImporter(repository, log));
        importer.setBaseDirectory((RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class));
        ((RepositoryImporter)Mockito.doReturn((Object)"TEST_PATH").when((Object)importer)).resolvePath(Matchers.anyString(), Matchers.anyString());
        MetaInjectMeta metaInjectMeta = (MetaInjectMeta)Mockito.mock(MetaInjectMeta.class);
        ((MetaInjectMeta)Mockito.doReturn((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME).when((Object)metaInjectMeta)).getSpecificationMethod();
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        ((StepMeta)Mockito.doReturn((Object)metaInjectMeta).when((Object)stepMeta)).getStepMetaInterface();
        ((StepMeta)Mockito.doReturn((Object)true).when((Object)stepMeta)).isEtlMetaInject();
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransMeta)Mockito.doReturn(Collections.singletonList(stepMeta)).when((Object)transMeta)).getSteps();
        importer.patchTransSteps(transMeta);
        ((MetaInjectMeta)Mockito.verify((Object)metaInjectMeta)).setDirectoryPath("TEST_PATH");
    }

    private static JobEntryTrans createJobEntryTrans() {
        return RepositoryImporterTest.createJobEntryTrans("");
    }

    private static JobEntryTrans createJobEntryTrans(String directory) {
        JobEntryTrans jet = (JobEntryTrans)Mockito.mock(JobEntryTrans.class);
        Mockito.when((Object)jet.getSpecificationMethod()).thenReturn((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        Mockito.when((Object)jet.getDirectory()).thenReturn((Object)directory);
        return jet;
    }

    private static MappingMeta createMappingMeta() {
        return RepositoryImporterTest.createMappingMeta("");
    }

    private static MappingMeta createMappingMeta(String directory) {
        MappingMeta mappingMeta = (MappingMeta)Mockito.mock(MappingMeta.class);
        Mockito.when((Object)mappingMeta.getSpecificationMethod()).thenReturn((Object)ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        Mockito.when((Object)mappingMeta.getDirectoryPath()).thenReturn((Object)directory);
        return mappingMeta;
    }

    private static RepositoryImporter createRepositoryImporter(final JobEntryTrans jobEntryTrans, final MappingMeta mappingMeta, final boolean needToCheckPathForVariables) {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        LogChannelInterface log = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        RepositoryImporter importer = new RepositoryImporter(repository, log){

            JobMeta createJobMetaForNode(Node jobnode) throws KettleXMLException {
                JobMeta meta = (JobMeta)Mockito.mock(JobMeta.class);
                JobEntryCopy jec = (JobEntryCopy)Mockito.mock(JobEntryCopy.class);
                Mockito.when((Object)jec.isTransformation()).thenReturn((Object)true);
                Mockito.when((Object)jec.getEntry()).thenReturn((Object)jobEntryTrans);
                Mockito.when((Object)meta.getJobCopies()).thenReturn(Collections.singletonList(jec));
                return meta;
            }

            TransMeta createTransMetaForNode(Node transnode) throws KettleMissingPluginsException, KettleXMLException {
                TransMeta meta = (TransMeta)Mockito.mock(TransMeta.class);
                StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
                Mockito.when((Object)stepMeta.isMapping()).thenReturn((Object)true);
                Mockito.when((Object)stepMeta.getStepMetaInterface()).thenReturn((Object)mappingMeta);
                Mockito.when((Object)meta.getSteps()).thenReturn(Collections.singletonList(stepMeta));
                return meta;
            }

            protected void replaceSharedObjects(JobMeta transMeta) throws KettleException {
            }

            protected void replaceSharedObjects(TransMeta transMeta) throws KettleException {
            }

            boolean needToCheckPathForVariables() {
                return needToCheckPathForVariables;
            }
        };
        return importer;
    }
}

