/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.shared;

import java.io.File;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.shared.SharedObjectsMetaStore;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;

public class TestSharedObjectsMetaStore
extends TestCase {
    private static String databaseMetaXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><connection><name>db</name><server>127.0.0.1</server><type>H2</type><access>Native</access><database>mem:db</database><port>${PORT_NUMBER_STRING}</port><username>sa</username><password></password></connection>";
    private static String namespace = "pentaho";

    public void testSharedObjectsMetaStore() throws Exception {
        KettleEnvironment.init();
        File sharedObjectsFile = File.createTempFile("shared-objects", ".xml");
        String sharedObjectsFilename = sharedObjectsFile.toString();
        sharedObjectsFile.delete();
        SharedObjects sharedObjects = new SharedObjects(sharedObjectsFilename);
        SharedObjectsMetaStore metaStore = new SharedObjectsMetaStore(sharedObjects);
        List elementTypes = metaStore.getElementTypes(namespace);
        TestSharedObjectsMetaStore.assertEquals((int)1, (int)elementTypes.size());
        IMetaStoreElementType databaseElementType = metaStore.getElementType(namespace, "Database connection");
        TestSharedObjectsMetaStore.assertNotNull((Object)databaseElementType);
        List elements = metaStore.getElements(namespace, databaseElementType);
        TestSharedObjectsMetaStore.assertEquals((int)0, (int)elements.size());
        DatabaseMeta databaseMeta = new DatabaseMeta(databaseMetaXml);
        sharedObjects.storeObject((SharedObjectInterface)databaseMeta);
        elements = metaStore.getElements(namespace, databaseElementType);
        TestSharedObjectsMetaStore.assertEquals((int)1, (int)elements.size());
        IMetaStoreElement databaseElement = (IMetaStoreElement)elements.get(0);
        sharedObjects.removeObject((SharedObjectInterface)databaseMeta);
        elements = metaStore.getElements(namespace, databaseElementType);
        TestSharedObjectsMetaStore.assertEquals((int)0, (int)elements.size());
        metaStore.createElement(namespace, databaseElementType, databaseElement);
        elements = metaStore.getElements(namespace, databaseElementType);
        TestSharedObjectsMetaStore.assertEquals((int)1, (int)elements.size());
        TestSharedObjectsMetaStore.assertNotNull((Object)sharedObjects.getSharedDatabase(databaseMeta.getName()));
    }
}

