/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;

public class StepIOMetaIT {
    @Test
    public void streamsListIsThreadsafe_NewObject() throws Exception {
        StepIOMeta meta = new StepIOMeta(true, false, false, false, false, false);
        this.checkStreamsListIsThreadSafe(meta);
    }

    @Test
    public void streamsListIsThreadsafe_ClonedObject() throws Exception {
        StepIOMeta meta = new StepIOMeta(true, false, false, false, false, false);
        this.checkStreamsListIsThreadSafe(meta.clone());
    }

    private void checkStreamsListIsThreadSafe(StepIOMeta meta) throws Exception {
        int cycles = 1000;
        StreamAdder adder1 = new StreamAdder(meta, 1000);
        StreamAdder adder2 = new StreamAdder(meta, 1000);
        Thread t1 = new Thread((Runnable)adder1, "StepIOMetaIT_thread1");
        Thread t2 = new Thread((Runnable)adder2, "StepIOMetaIT_thread2");
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assert.assertNull((Object)adder1.getException());
        Assert.assertNull((Object)adder2.getException());
    }

    private static class StreamAdder
    implements Runnable {
        private final StepIOMeta meta;
        private final int cycles;
        private Exception exception;

        public StreamAdder(StepIOMeta meta, int cycles) {
            this.meta = meta;
            this.cycles = cycles;
            this.exception = null;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.cycles; ++i) {
                    Stream stream = new Stream(StreamInterface.StreamType.INPUT, null, null, null, null);
                    this.meta.addStream((StreamInterface)stream);
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

