/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.BitSet;
import java.util.List;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.readallcache.IndexTestBase;
import org.pentaho.di.trans.steps.databaselookup.readallcache.LtIndex;

@RunWith(value=Parameterized.class)
public class GeIndexTest
extends IndexTestBase<LtIndex> {
    @Parameterized.Parameters
    public static List<Object[]> createSampleData() {
        return IndexTestBase.createSampleData();
    }

    public GeIndexTest(Long[][] rows) {
        super(LtIndex.class, rows);
    }

    @Override
    void doAssertMatches(BitSet candidates, long lookupValue, long actualValue) {
        if (actualValue < lookupValue) {
            Assert.fail((String)String.format("All found values are expected to be greater than [%d] or equal to it, but got [%d] among %s", lookupValue, actualValue, candidates));
        }
    }

    @Override
    LtIndex createIndexInstance(int column, ValueMetaInterface meta, int rowsAmount) throws Exception {
        return (LtIndex)LtIndex.greaterOrEqualCache((int)column, (ValueMetaInterface)meta, (int)rowsAmount);
    }

    @Override
    public void lookupFor_MinusOne() {
        this.testFindsCorrectly(-1L, 5);
    }

    @Override
    public void lookupFor_Zero() {
        this.testFindsCorrectly(0L, 5);
    }

    @Override
    public void lookupFor_One() {
        this.testFindsCorrectly(1L, 4);
    }

    @Override
    public void lookupFor_Two() {
        this.testFindsCorrectly(2L, 3);
    }

    @Override
    public void lookupFor_Three() {
        this.testFindsCorrectly(3L, 1);
    }

    @Override
    public void lookupFor_Hundred() {
        this.testFindsNothing(100L);
    }
}

