/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.dimensionlookup;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.dimensionlookup.DimensionLookup;
import org.pentaho.di.trans.steps.dimensionlookup.DimensionLookupData;
import org.pentaho.di.trans.steps.dimensionlookup.DimensionLookupMeta;

public class DimensionLookupTest {
    private DatabaseMeta databaseMeta;
    private StepMeta stepMeta;
    private DimensionLookup dimensionLookup;
    private DimensionLookup dimensionLookupSpy;
    private DimensionLookupMeta dimensionLookupMeta;
    private DimensionLookupData dimensionLookupData;

    @Before
    public void setUp() throws Exception {
        this.databaseMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        ((DatabaseMeta)Mockito.doReturn((Object)"").when((Object)this.databaseMeta)).quoteField(Matchers.anyString());
        this.dimensionLookupMeta = (DimensionLookupMeta)Mockito.mock(DimensionLookupMeta.class);
        ((DimensionLookupMeta)Mockito.doReturn((Object)this.databaseMeta).when((Object)this.dimensionLookupMeta)).getDatabaseMeta();
        ((DimensionLookupMeta)Mockito.doReturn((Object)new String[0]).when((Object)this.dimensionLookupMeta)).getKeyLookup();
        ((DimensionLookupMeta)Mockito.doReturn((Object)new String[0]).when((Object)this.dimensionLookupMeta)).getFieldLookup();
        ((DimensionLookupMeta)Mockito.doReturn((Object)new int[0]).when((Object)this.dimensionLookupMeta)).getFieldUpdate();
        this.stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        ((StepMeta)Mockito.doReturn((Object)"step").when((Object)this.stepMeta)).getName();
        ((StepMeta)Mockito.doReturn((Object)Mockito.mock(StepPartitioningMeta.class)).when((Object)this.stepMeta)).getTargetStepPartitioningMeta();
        ((StepMeta)Mockito.doReturn((Object)this.dimensionLookupMeta).when((Object)this.stepMeta)).getStepMetaInterface();
        Database db = (Database)Mockito.mock(Database.class);
        ((Database)Mockito.doReturn((Object)Mockito.mock(Connection.class)).when((Object)db)).getConnection();
        this.dimensionLookupData = (DimensionLookupData)Mockito.mock(DimensionLookupData.class);
        this.dimensionLookupData.db = db;
        this.dimensionLookupData.keynrs = new int[0];
        this.dimensionLookupData.fieldnrs = new int[0];
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransMeta)Mockito.doReturn((Object)this.stepMeta).when((Object)transMeta)).findStep(Matchers.anyString());
        this.dimensionLookup = new DimensionLookup(this.stepMeta, (StepDataInterface)this.dimensionLookupData, 1, transMeta, (Trans)Mockito.mock(Trans.class));
        this.dimensionLookup.setData(this.dimensionLookupData);
        this.dimensionLookup.setMeta(this.dimensionLookupMeta);
        this.dimensionLookupSpy = (DimensionLookup)Mockito.spy((Object)this.dimensionLookup);
        ((DimensionLookup)Mockito.doReturn((Object)this.stepMeta).when((Object)this.dimensionLookupSpy)).getStepMeta();
        ((DimensionLookup)Mockito.doReturn((Object)false).when((Object)this.dimensionLookupSpy)).isRowLevel();
        ((DimensionLookup)Mockito.doReturn((Object)false).when((Object)this.dimensionLookupSpy)).isDebug();
        ((DimensionLookup)Mockito.doReturn((Object)true).when((Object)this.dimensionLookupSpy)).isAutoIncrement();
        ((DimensionLookup)Mockito.doNothing().when((Object)this.dimensionLookupSpy)).logDetailed(Matchers.anyString());
    }

    @Test
    public void testDimInsert() throws Exception {
        RowMetaInterface rowMetaInterface = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Object[] objects = ((List)Mockito.mock(List.class)).toArray();
        Date date = (Date)Mockito.mock(Date.class);
        this.dimensionLookupSpy.dimInsert(rowMetaInterface, objects, new Long("132323"), true, null, date, date);
        ((DatabaseMeta)Mockito.verify((Object)this.databaseMeta, (VerificationMode)Mockito.times((int)0))).supportsAutoGeneratedKeys();
        this.dimensionLookupSpy.dimInsert(rowMetaInterface, objects, null, true, null, date, date);
        ((DatabaseMeta)Mockito.verify((Object)this.databaseMeta, (VerificationMode)Mockito.times((int)2))).supportsAutoGeneratedKeys();
    }
}

