/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import org.junit.Test;
import org.pentaho.di.trans.steps.excelinput.BaseExcelParsingTest;
import org.pentaho.di.trans.steps.excelinput.ExcelInputField;
import org.pentaho.di.trans.steps.excelinput.ExcelInputMeta;
import org.pentaho.di.trans.steps.excelinput.SpreadSheetType;

public class ExcelInputContentParsingTest
extends BaseExcelParsingTest {
    @Test
    public void testXLS() throws Exception {
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.JXL);
        this.init("sample.xls");
        this.setFields(new ExcelInputField(), new ExcelInputField());
        this.process();
        this.check(new Object[][]{{"test", null}, {"test", "test"}});
    }

    @Test
    public void testXLSX() throws Exception {
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.POI);
        this.init("sample.xlsx");
        this.setFields(new ExcelInputField(), new ExcelInputField());
        this.process();
        this.check(new Object[][]{{"test", null}, {"test", "test"}});
    }

    @Test
    public void testXLSXStream() throws Exception {
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.SAX_POI);
        this.init("sample.xlsx");
        this.setFields(new ExcelInputField(), new ExcelInputField());
        this.process();
        this.check(new Object[][]{{"test", null}, {"test", "test"}});
    }

    @Test
    public void testODS24() throws Exception {
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.ODS);
        this.init("sample-2.4.ods");
        this.setFields(new ExcelInputField(), new ExcelInputField());
        this.process();
        this.check(new Object[][]{{"test", null}, {"test", "test"}});
    }

    @Test
    public void testODS341() throws Exception {
        ((ExcelInputMeta)this.meta).setSpreadSheetType(SpreadSheetType.ODS);
        this.init("sample-3.4.1.ods");
        this.setFields(new ExcelInputField(), new ExcelInputField());
        this.process();
        this.check(new Object[][]{{"AAABBC", "Nissan"}, {"AAABBC", "Nissan"}, {"AAABBC", "Nissan"}, {"AAABBC", "Nissan"}});
    }
}

