/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileinput.text;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.trans.steps.fileinput.text.BOMDetector;

public class BOMDetectorTest {
    BufferedInputStream getFile(String filename) throws Exception {
        String inPrefix = '/' + this.getClass().getPackage().getName().replace('.', '/') + "/files/";
        InputStream file = this.getClass().getResourceAsStream(inPrefix + filename);
        Assert.assertNotNull((String)("There is no file " + filename), (Object)file);
        return new BufferedInputStream(file);
    }

    public void testBOM(String file, String charset) throws Exception {
        BufferedInputStream in = this.getFile(file);
        BOMDetector detector = new BOMDetector(in);
        Assert.assertEquals((String)"Wrong BOM detected", (Object)charset, (Object)detector.getCharset());
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)in, detector.getCharset()));
        String data = rd.readLine();
        Assert.assertEquals((String)"Wrong data in file", (Object)"data;1", (Object)data);
        in.close();
    }

    @Test
    public void testBOMs() throws Exception {
        this.testBOM("test-BOM-UTF-8.txt", "UTF-8");
        this.testBOM("test-BOM-UTF-16BE.txt", "UTF-16BE");
        this.testBOM("test-BOM-UTF-16LE.txt", "UTF-16LE");
        this.testBOM("test-BOM-UTF-32BE.txt", "UTF-32BE");
        this.testBOM("test-BOM-UTF-32LE.txt", "UTF-32LE");
        this.testBOM("test-BOM-GB-18030.txt", "GB18030");
    }
}

