/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileinput.text;

import org.junit.Test;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.steps.fileinput.BaseFileInputField;
import org.pentaho.di.trans.steps.fileinput.text.BaseTextParsingTest;
import org.pentaho.di.trans.steps.fileinput.text.TextFileFilter;
import org.pentaho.di.trans.steps.fileinput.text.TextFileFilterProcessor;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputData;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;

public class TextFileInputContentParsingTest
extends BaseTextParsingTest {
    @Test
    public void testDefaultOptions() throws Exception {
        this.initByFile("default.csv");
        this.setFields(new BaseFileInputField(), new BaseFileInputField(), new BaseFileInputField());
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third", "3", "3.3"}});
    }

    @Test
    public void testSeparator() throws Exception {
        ((TextFileInputMeta)this.meta).content.separator = ",";
        this.initByFile("separator.csv");
        this.setFields(new BaseFileInputField(), new BaseFileInputField(), new BaseFileInputField());
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third;third", "3", "3.3"}});
    }

    @Test
    public void testEscape() throws Exception {
        ((TextFileInputMeta)this.meta).content.escapeCharacter = "\\";
        this.initByFile("escape.csv");
        this.setFields(new BaseFileInputField(), new BaseFileInputField(), new BaseFileInputField());
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third;third", "3", "3.3"}});
    }

    @Test
    public void testHeader() throws Exception {
        ((TextFileInputMeta)this.meta).content.header = false;
        this.initByFile("default.csv");
        this.setFields(new BaseFileInputField(), new BaseFileInputField(), new BaseFileInputField());
        this.process();
        this.check(new Object[][]{{"Field 1", "Field 2", "Field 3"}, {"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third", "3", "3.3"}});
    }

    @Test
    public void testGzipCompression() throws Exception {
        ((TextFileInputMeta)this.meta).content.fileCompression = "GZip";
        this.initByFile("default.csv.gz");
        this.setFields(new BaseFileInputField(), new BaseFileInputField(), new BaseFileInputField());
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third", "3", "3.3"}});
    }

    @Test
    public void testVfsGzipCompression() throws Exception {
        ((TextFileInputMeta)this.meta).content.fileCompression = "None";
        String url = "gz:" + this.getClass().getResource(this.inPrefix + "default.csv.gz");
        this.initByURL(url);
        this.setFields(new BaseFileInputField(), new BaseFileInputField(), new BaseFileInputField());
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third", "3", "3.3"}});
    }

    @Test
    public void testVfsBzip2Compression() throws Exception {
        ((TextFileInputMeta)this.meta).content.fileCompression = "None";
        String url = "bz2:" + this.getClass().getResource(this.inPrefix + "default.csv.bz2");
        this.initByURL(url);
        this.setFields(new BaseFileInputField(), new BaseFileInputField(), new BaseFileInputField());
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third", "3", "3.3"}});
    }

    @Test
    public void testFixedWidth() throws Exception {
        ((TextFileInputMeta)this.meta).content.fileType = "Fixed";
        this.initByFile("fixed.csv");
        this.setFields(new BaseFileInputField("f1", 0, 7), new BaseFileInputField("f2", 8, 7), new BaseFileInputField("f3", 16, 7));
        this.process();
        this.check(new Object[][]{{"first  ", "1      ", "1.1"}, {"second ", "2      ", "2.2"}, {"third  ", "3      ", "3.3"}});
    }

    @Test
    public void testFilterEmptyBacklog5381() throws Exception {
        ((TextFileInputMeta)this.meta).content.header = false;
        ((TextFileInputMeta)this.meta).content.fileType = "Fixed";
        ((TextFileInputMeta)this.meta).content.noEmptyLines = true;
        ((TextFileInputMeta)this.meta).content.fileFormat = "mixed";
        this.initByFile("filterempty-BACKLOG-5381.csv");
        this.setFields(new BaseFileInputField("f", 0, 100));
        this.process();
        this.check(new Object[][]{{"FirstLine => FirstLine "}, {"ThirdLine => SecondLine"}, {"SixthLine => ThirdLine"}, {"NinthLine => FourthLine"}, {""}});
    }

    @Test
    public void testFilterVariables() throws Exception {
        this.initByFile("default.csv");
        Variables vars = new Variables();
        vars.setVariable("VAR_TEST", "second");
        ((TextFileInputData)this.data).filterProcessor = new TextFileFilterProcessor(new TextFileFilter[]{new TextFileFilter(0, "${VAR_TEST}", false, false)}, (VariableSpace)vars);
        this.setFields(new BaseFileInputField(), new BaseFileInputField(), new BaseFileInputField());
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"third", "3", "3.3"}});
    }

    @Test
    public void testBOM_UTF8() throws Exception {
        ((TextFileInputMeta)this.meta).content.encoding = "UTF-32LE";
        ((TextFileInputMeta)this.meta).content.header = false;
        this.initByFile("test-BOM-UTF-8.txt");
        this.setFields(new BaseFileInputField(), new BaseFileInputField());
        this.process();
        this.check(new Object[][]{{"data", "1"}});
    }

    @Test
    public void testBOM_UTF16BE() throws Exception {
        ((TextFileInputMeta)this.meta).content.encoding = "UTF-32LE";
        ((TextFileInputMeta)this.meta).content.header = false;
        this.initByFile("test-BOM-UTF-16BE.txt");
        this.setFields(new BaseFileInputField(), new BaseFileInputField());
        this.process();
        this.check(new Object[][]{{"data", "1"}});
    }
}

