/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.insertupdate;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdate;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdateData;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdateMeta;

public class InsertUpdateMetaTest {
    private StepMeta stepMeta;
    private InsertUpdate upd;
    private InsertUpdateData ud;
    private InsertUpdateMeta umi;

    @BeforeClass
    public static void initEnvironment() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        TransMeta transMeta = new TransMeta();
        transMeta.setName("delete1");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("max.sz", "10");
        transMeta.injectVariables(vars);
        this.umi = new InsertUpdateMeta();
        this.ud = new InsertUpdateData();
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String deletePid = plugReg.getPluginId(StepPluginType.class, (Object)this.umi);
        this.stepMeta = new StepMeta(deletePid, "delete", (StepMetaInterface)this.umi);
        Trans trans = new Trans(transMeta);
        transMeta.addStep(this.stepMeta);
        this.upd = new InsertUpdate(this.stepMeta, (StepDataInterface)this.ud, 1, transMeta, trans);
        this.upd.copyVariablesFrom((VariableSpace)transMeta);
    }

    @Test
    public void testCommitCountFixed() {
        this.umi.setCommitSize("100");
        Assert.assertTrue((this.umi.getCommitSize((VariableSpace)this.upd) == 100 ? 1 : 0) != 0);
    }

    @Test
    public void testCommitCountVar() {
        this.umi.setCommitSize("${max.sz}");
        Assert.assertTrue((this.umi.getCommitSize((VariableSpace)this.upd) == 10 ? 1 : 0) != 0);
    }

    @Test
    public void testProvidesModeler() throws Exception {
        InsertUpdateMeta insertUpdateMeta = new InsertUpdateMeta();
        insertUpdateMeta.setUpdateLookup(new String[]{"f1", "f2", "f3"});
        insertUpdateMeta.setUpdateStream(new String[]{"s4", "s5", "s6"});
        InsertUpdateData tableOutputData = new InsertUpdateData();
        tableOutputData.insertRowMeta = (RowMetaInterface)Mockito.mock(RowMeta.class);
        Assert.assertEquals((Object)tableOutputData.insertRowMeta, (Object)insertUpdateMeta.getRowMeta((StepDataInterface)tableOutputData));
        Assert.assertEquals((long)3L, (long)insertUpdateMeta.getDatabaseFields().size());
        Assert.assertEquals((Object)"f1", insertUpdateMeta.getDatabaseFields().get(0));
        Assert.assertEquals((Object)"f2", insertUpdateMeta.getDatabaseFields().get(1));
        Assert.assertEquals((Object)"f3", insertUpdateMeta.getDatabaseFields().get(2));
        Assert.assertEquals((long)3L, (long)insertUpdateMeta.getStreamFields().size());
        Assert.assertEquals((Object)"s4", insertUpdateMeta.getStreamFields().get(0));
        Assert.assertEquals((Object)"s5", insertUpdateMeta.getStreamFields().get(1));
        Assert.assertEquals((Object)"s6", insertUpdateMeta.getStreamFields().get(2));
    }

    @Test
    public void testCommitCountMissedVar() {
        this.umi.setCommitSize("missed-var");
        try {
            this.umi.getCommitSize((VariableSpace)this.upd);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

