/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.insertupdate;

import java.sql.PreparedStatement;
import java.sql.Timestamp;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdate;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdateData;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdateMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class PDI3499Test {
    StepMockHelper<InsertUpdateMeta, InsertUpdateData> smh;

    @Before
    public void setUp() {
        this.smh = new StepMockHelper<InsertUpdateMeta, InsertUpdateData>("insertUpdate", InsertUpdateMeta.class, InsertUpdateData.class);
        Mockito.when((Object)this.smh.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.smh.logChannelInterface);
        Mockito.when((Object)this.smh.trans.isRunning()).thenReturn((Object)true);
    }

    @Test
    public void testDateLazyConversion() throws KettleException {
        Database db = (Database)Mockito.mock(Database.class);
        RowMeta returnRowMeta = new RowMeta();
        ((Database)Mockito.doReturn((Object)new Object[]{new Timestamp(System.currentTimeMillis())}).when((Object)db)).getLookup((PreparedStatement)Matchers.any(PreparedStatement.class));
        returnRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaDate("TimeStamp"));
        ((Database)Mockito.doReturn((Object)returnRowMeta).when((Object)db)).getReturnRowMeta();
        ValueMetaString storageMetadata = new ValueMetaString("Date");
        storageMetadata.setConversionMask("yyyy-MM-dd");
        ValueMetaDate valueMeta = new ValueMetaDate("Date");
        valueMeta.setStorageType(1);
        valueMeta.setStorageMetadata((ValueMetaInterface)storageMetadata);
        RowMeta inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        InsertUpdateMeta stepMeta = (InsertUpdateMeta)this.smh.processRowsStepMetaInterface;
        ((InsertUpdateMeta)Mockito.doReturn((Object)new Boolean[]{true}).when((Object)stepMeta)).getUpdate();
        InsertUpdateData stepData = (InsertUpdateData)this.smh.processRowsStepDataInterface;
        stepData.lookupParameterRowMeta = inputRowMeta;
        stepData.db = db;
        stepData.valuenrs = new int[]{0};
        stepData.keynrs = stepData.valuenrs;
        stepData.keynrs2 = new int[]{-1};
        stepData.updateParameterRowMeta = (RowMetaInterface)Mockito.when((Object)((RowMeta)Mockito.mock(RowMeta.class)).size()).thenReturn((Object)2).getMock();
        InsertUpdate step = new InsertUpdate(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        step.setInputRowMeta((RowMetaInterface)inputRowMeta);
        step.getInputRowSets().add(this.smh.getMockInputRowSet(new Object[][]{{"2013-12-20".getBytes()}}));
        step.init(this.smh.initStepMetaInterface, this.smh.initStepDataInterface);
        step.first = false;
        step.processRow((StepMetaInterface)stepMeta, (StepDataInterface)stepData);
    }
}

