/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jobexecutor;

import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutor;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorData;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorMeta;

public class JobExecutorTest {
    private JobExecutor executor;
    private JobExecutorMeta meta;
    private JobExecutorData data;

    @Before
    public void setUp() throws Exception {
        this.executor = StepMockUtil.getStep(JobExecutor.class, JobExecutorMeta.class, "TransExecutorUnitTest");
        this.executor = (JobExecutor)Mockito.spy((Object)this.executor);
        this.executor.setInputRowMeta((RowMetaInterface)Mockito.mock(RowMetaInterface.class));
        ((JobExecutor)Mockito.doNothing().when((Object)this.executor)).discardLogLines((JobExecutorData)Matchers.any(JobExecutorData.class));
        this.meta = new JobExecutorMeta();
        this.data = new JobExecutorData();
        ((JobExecutor)Mockito.doReturn((Object)Mockito.mock(Job.class)).when((Object)this.executor)).createJob((Repository)Matchers.any(Repository.class), (JobMeta)Matchers.any(JobMeta.class), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class));
        this.data.groupBuffer = new ArrayList();
        this.data.groupSize = -1;
        this.data.groupTime = -1;
        this.data.groupField = null;
    }

    @After
    public void tearDown() {
        this.executor = null;
        this.meta = null;
        this.data = null;
    }

    @Test
    public void shouldAccumulateRowsWhenGroupFieldIsSpecified() throws KettleException {
        this.prepareMultipleRowsForExecutor();
        this.data.groupField = "groupField";
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("groupField"));
        this.executor.setInputRowMeta((RowMetaInterface)rowMeta);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)1L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)4L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)1L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)3L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)0L, (long)this.data.groupBuffer.size());
    }

    @Test
    public void shouldAccumulateRowsByCount() throws KettleException {
        this.prepareMultipleRowsForExecutor();
        this.data.groupSize = 5;
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)1L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)4L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)0L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)1L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)2L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)0L, (long)this.data.groupBuffer.size());
    }

    private void prepareMultipleRowsForExecutor() throws KettleException {
        ((JobExecutor)Mockito.doReturn((Object)new Object[]{"value1"}).doReturn((Object)new Object[]{"value1"}).doReturn((Object)new Object[]{"value1"}).doReturn((Object)new Object[]{"value1"}).doReturn((Object)new Object[]{"value12"}).doReturn((Object)new Object[]{"value12"}).doReturn((Object)new Object[]{"value12"}).doReturn(null).when((Object)this.executor)).getRow();
    }
}

