/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadsave;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.MemoryRepository;
import org.pentaho.di.trans.steps.loadsave.getter.Getter;
import org.pentaho.di.trans.steps.loadsave.setter.Setter;
import org.pentaho.di.trans.steps.loadsave.validator.DefaultFieldLoadSaveValidatorFactory;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidatorFactory;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.test.util.JavaBeanManipulator;
import org.w3c.dom.Node;

public class LoadSaveTester {
    private final Class<? extends StepMetaInterface> clazz;
    private final List<String> xmlAttributes;
    private final List<String> repoAttributes;
    private final JavaBeanManipulator<? extends StepMetaInterface> manipulator;
    private final FieldLoadSaveValidatorFactory fieldLoadSaveValidatorFactory;

    public LoadSaveTester(Class<? extends StepMetaInterface> clazz, List<String> commonAttributes, List<String> xmlAttributes, List<String> repoAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap) {
        this.clazz = clazz;
        this.xmlAttributes = new ArrayList<String>(commonAttributes);
        this.xmlAttributes.addAll(xmlAttributes);
        this.repoAttributes = new ArrayList<String>(commonAttributes);
        this.repoAttributes.addAll(commonAttributes);
        ArrayList<String> combinedAttributes = new ArrayList<String>(commonAttributes);
        combinedAttributes.addAll(repoAttributes);
        combinedAttributes.addAll(xmlAttributes);
        this.manipulator = new JavaBeanManipulator<StepMetaInterface>(clazz, combinedAttributes, getterMap, setterMap);
        HashMap fieldLoadSaveValidatorMethodMap = new HashMap();
        for (Map.Entry<String, FieldLoadSaveValidator<?>> entry : fieldLoadSaveValidatorAttributeMap.entrySet()) {
            fieldLoadSaveValidatorMethodMap.put(this.manipulator.getGetter(entry.getKey()), entry.getValue());
        }
        this.fieldLoadSaveValidatorFactory = new DefaultFieldLoadSaveValidatorFactory(fieldLoadSaveValidatorMethodMap, fieldLoadSaveValidatorTypeMap);
    }

    public LoadSaveTester(Class<? extends StepMetaInterface> clazz, List<String> commonAttributes, Map<String, String> getterMap, Map<String, String> setterMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorAttributeMap, Map<String, FieldLoadSaveValidator<?>> fieldLoadSaveValidatorTypeMap) {
        this(clazz, commonAttributes, new ArrayList<String>(), new ArrayList<String>(), getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap);
    }

    public LoadSaveTester(Class<? extends StepMetaInterface> clazz, List<String> commonAttributes, List<String> xmlAttributes, List<String> repoAttributes, Map<String, String> getterMap, Map<String, String> setterMap) {
        this(clazz, commonAttributes, xmlAttributes, repoAttributes, getterMap, setterMap, new HashMap(), new HashMap());
    }

    public LoadSaveTester(Class<? extends StepMetaInterface> clazz, List<String> commonAttributes, Map<String, String> getterMap, Map<String, String> setterMap) {
        this(clazz, commonAttributes, new ArrayList<String>(), new ArrayList<String>(), getterMap, setterMap, new HashMap(), new HashMap());
    }

    public FieldLoadSaveValidatorFactory getFieldLoadSaveValidatorFactory() {
        return this.fieldLoadSaveValidatorFactory;
    }

    private Map<String, FieldLoadSaveValidator<?>> createValidatorMapAndInvokeSetters(List<String> attributes, StepMetaInterface metaToSave) {
        HashMap validatorMap = new HashMap();
        for (String attribute : attributes) {
            Getter<?> getter = this.manipulator.getGetter(attribute);
            Setter<?> setter = this.manipulator.getSetter(attribute);
            FieldLoadSaveValidator<?> validator = this.fieldLoadSaveValidatorFactory.createValidator(getter);
            try {
                setter.set(metaToSave, validator.getTestObject());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke setter for " + attribute, e);
            }
            validatorMap.put(attribute, validator);
        }
        return validatorMap;
    }

    private StepMetaInterface createMeta() {
        try {
            return this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create meta of class " + this.clazz.getCanonicalName(), e);
        }
    }

    private void validateLoadedMeta(List<String> attributes, Map<String, FieldLoadSaveValidator<?>> validatorMap, StepMetaInterface metaSaved, StepMetaInterface metaLoaded) {
        for (String attribute : attributes) {
            try {
                Getter<?> getterMethod = this.manipulator.getGetter(attribute);
                Object originalValue = getterMethod.get(metaSaved);
                Object value = getterMethod.get(metaLoaded);
                FieldLoadSaveValidator<?> validator = validatorMap.get(attribute);
                Method[] validatorMethods = validator.getClass().getMethods();
                Method validatorMethod = null;
                for (Method method : validatorMethods) {
                    Class<?>[] types;
                    if (!"validateTestObject".equals(method.getName()) || (types = method.getParameterTypes()).length != 2 || types[1] != Object.class || originalValue != null && !types[0].isAssignableFrom(originalValue.getClass())) continue;
                    validatorMethod = method;
                    break;
                }
                if (validatorMethod == null) {
                    throw new RuntimeException("Couldn't find proper validateTestObject method on " + validator.getClass().getCanonicalName());
                }
                if (((Boolean)validatorMethod.invoke(validator, originalValue, value)).booleanValue()) continue;
                throw new KettleException("Attribute " + attribute + " started with value " + validatorMap.get(attribute).getTestObject() + " ended with value " + value);
            }
            catch (Exception e) {
                throw new RuntimeException("Error validating " + attribute, e);
            }
        }
    }

    public void testXmlRoundTrip() throws KettleException {
        StepMetaInterface metaToSave = this.createMeta();
        Map<String, FieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters(this.xmlAttributes, metaToSave);
        StepMetaInterface metaLoaded = this.createMeta();
        String xml = "<step>" + metaToSave.getXML() + "</step>";
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
        metaLoaded.loadXML(XMLHandler.getSubNode((Node)XMLHandler.loadXMLFile((InputStream)is, null, (boolean)false, (boolean)false), (String)"step"), (List)null, (IMetaStore)null);
        this.validateLoadedMeta(this.xmlAttributes, validatorMap, metaToSave, metaLoaded);
    }

    public void testRepoRoundTrip() throws KettleException {
        StepMetaInterface metaToSave = this.createMeta();
        Map<String, FieldLoadSaveValidator<?>> validatorMap = this.createValidatorMapAndInvokeSetters(this.repoAttributes, metaToSave);
        StepMetaInterface metaLoaded = this.createMeta();
        MemoryRepository rep = new MemoryRepository();
        metaToSave.saveRep((Repository)rep, null, null, null);
        metaLoaded.readRep((Repository)rep, (IMetaStore)null, null, null);
        this.validateLoadedMeta(this.repoAttributes, validatorMap, metaToSave, metaLoaded);
    }
}

