/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadsave.validator;

import java.lang.reflect.Array;
import java.util.Random;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;

public class ArrayLoadSaveValidator<ObjectType>
implements FieldLoadSaveValidator<ObjectType[]> {
    private final FieldLoadSaveValidator<ObjectType> validator;
    private final Integer elements;

    public ArrayLoadSaveValidator(FieldLoadSaveValidator<ObjectType> fieldValidator) {
        this(fieldValidator, null);
    }

    public ArrayLoadSaveValidator(FieldLoadSaveValidator<ObjectType> fieldValidator, Integer elements) {
        this.validator = fieldValidator;
        this.elements = elements;
    }

    @Override
    public ObjectType[] getTestObject() {
        int max = this.elements == null ? new Random().nextInt(100) + 50 : this.elements;
        Object[] result = null;
        for (int i = 0; i < max; ++i) {
            ObjectType element = this.validator.getTestObject();
            if (result == null) {
                result = (Object[])Array.newInstance(element.getClass(), max);
            }
            result[i] = element;
        }
        return result;
    }

    @Override
    public boolean validateTestObject(ObjectType[] original, Object actual) {
        if (original.getClass().isAssignableFrom(actual.getClass())) {
            Object[] otherList = (Object[])actual;
            if (original.length != otherList.length) {
                return false;
            }
            for (int i = 0; i < original.length; ++i) {
                if (this.validator.validateTestObject(original[i], otherList[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

