/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadsave.validator;

import java.util.Random;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;

public class PrimitiveIntegerArrayLoadSaveValidator
implements FieldLoadSaveValidator<int[]> {
    private final FieldLoadSaveValidator<Integer> validator;
    private final Integer elements;

    public PrimitiveIntegerArrayLoadSaveValidator(FieldLoadSaveValidator<Integer> fieldValidator) {
        this(fieldValidator, null);
    }

    public PrimitiveIntegerArrayLoadSaveValidator(FieldLoadSaveValidator<Integer> fieldValidator, Integer elements) {
        this.validator = fieldValidator;
        this.elements = elements;
    }

    @Override
    public int[] getTestObject() {
        int max = this.elements == null ? new Random().nextInt(100) + 50 : this.elements;
        int[] result = new int[max];
        for (int i = 0; i < max; ++i) {
            result[i] = this.validator.getTestObject();
        }
        return result;
    }

    @Override
    public boolean validateTestObject(int[] original, Object actual) {
        if (original.getClass().isAssignableFrom(actual.getClass())) {
            int[] otherList = (int[])actual;
            if (original.length != otherList.length) {
                return false;
            }
            for (int i = 0; i < original.length; ++i) {
                if (this.validator.validateTestObject(original[i], otherList[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

