/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mappinginput;

import java.util.ArrayList;
import java.util.HashMap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.plugins.Plugin;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappinginput.MappingInputData;
import org.pentaho.di.trans.steps.mappinginput.MappingInputMeta;

public class MappingInputFieldsTest {
    private static Plugin p1;
    private static Plugin p2;
    MappingInput step;
    MappingInputMeta meta;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.getInstance().registerPluginType(ValueMetaPluginType.class);
        HashMap<Class<ValueMetaInterface>, String> classes = new HashMap<Class<ValueMetaInterface>, String>();
        classes.put(ValueMetaInterface.class, "org.pentaho.di.core.row.value.ValueMetaString");
        p1 = new Plugin(new String[]{"2"}, ValueMetaPluginType.class, ValueMetaInterface.class, "", "", "", "", false, true, classes, null, null, null);
        classes = new HashMap();
        classes.put(ValueMetaInterface.class, "org.pentaho.di.core.row.value.ValueMetaInteger");
        p2 = new Plugin(new String[]{"5"}, ValueMetaPluginType.class, ValueMetaInterface.class, "", "", "", "", false, true, classes, null, null, null);
        PluginRegistry.getInstance().registerPlugin(ValueMetaPluginType.class, (PluginInterface)p1);
        PluginRegistry.getInstance().registerPlugin(ValueMetaPluginType.class, (PluginInterface)p2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (p1 != null) {
            PluginRegistry.getInstance().removePlugin(ValueMetaPluginType.class, (PluginInterface)p1);
        }
        if (p2 != null) {
            PluginRegistry.getInstance().removePlugin(ValueMetaPluginType.class, (PluginInterface)p2);
        }
    }

    @Before
    public void setUp() throws Exception {
        this.meta = new MappingInputMeta();
        this.meta.setFieldName(new String[]{"n2", "n4"});
        this.meta.setFieldType(new int[]{5, 5});
        this.meta.setFieldLength(new int[]{0, 0});
        this.meta.setFieldPrecision(new int[]{0, 0});
        StepMeta sm = new StepMeta("MappingInput", "SubTrans", (StepMetaInterface)this.meta);
        TransMeta tm = new TransMeta();
        tm.addStep(sm);
        SimpleLoggingObject loi = new SimpleLoggingObject("lo", LoggingObjectType.STEP, null);
        Trans tr = new Trans(tm, (LoggingObjectInterface)loi);
        this.step = new MappingInput(sm, null, 0, tm, tr);
        this.step.getTrans().setRunning(true);
    }

    @Test
    public void testSelectingAndSortingUnspecifiedFields() throws Exception {
        this.meta.setSelectingAndSortingUnspecifiedFields(true);
        MappingInputData sdi = new MappingInputData();
        sdi.linked = true;
        sdi.valueRenames = new ArrayList();
        sdi.valueRenames.add(new MappingValueRename("number2", "n2"));
        sdi.valueRenames.add(new MappingValueRename("number4", "n4"));
        BlockingRowSet in = new BlockingRowSet(10);
        BlockingRowSet out = new BlockingRowSet(10);
        RowMeta rm = new RowMeta();
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("string", 2));
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("number1", 5));
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("number2", 5));
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("number3", 5));
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("number", 5));
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("number4", 5));
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("number5", 5));
        in.putRow((RowMetaInterface)rm, new Object[]{"str", new Integer(100501), new Integer(100502), new Integer(100503), new Integer(100500), new Integer(100504), new Integer(100505)});
        in.putRow((RowMetaInterface)rm, new Object[]{"str_1", new Integer(200501), new Integer(200502), new Integer(200503), new Integer(200500), new Integer(200504), new Integer(200505)});
        this.step.getInputRowSets().add(in);
        this.step.getOutputRowSets().add(out);
        Assert.assertTrue((boolean)this.step.init((StepMetaInterface)this.meta, (StepDataInterface)sdi));
        Assert.assertTrue((boolean)this.step.processRow((StepMetaInterface)this.meta, (StepDataInterface)sdi));
        Object[] outRowData = out.getRow();
        RowMetaInterface outMeta = out.getRowMeta();
        Assert.assertEquals((String)"All fields are expected.", (long)7L, (long)outMeta.size());
        int i = 0;
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"n2", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"n4", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number1", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number3", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number5", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)2L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"string", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(100502), (Object)outRowData[0]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(100504), (Object)outRowData[1]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(100500), (Object)outRowData[2]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(100501), (Object)outRowData[3]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(100503), (Object)outRowData[4]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(100505), (Object)outRowData[5]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)"str", (Object)outRowData[6]);
        Assert.assertTrue((boolean)this.step.processRow((StepMetaInterface)this.meta, (StepDataInterface)sdi));
        outRowData = out.getRow();
        outMeta = out.getRowMeta();
        Assert.assertEquals((String)"All fields are expected.", (long)7L, (long)outMeta.size());
        i = 0;
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"n2", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"n4", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number1", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number3", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number5", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)2L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"string", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(200502), (Object)outRowData[0]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(200504), (Object)outRowData[1]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(200500), (Object)outRowData[2]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(200501), (Object)outRowData[3]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(200503), (Object)outRowData[4]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(200505), (Object)outRowData[5]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)"str_1", (Object)outRowData[6]);
    }

    @Test
    public void testOnlySpecifiedFields() throws Exception {
        this.meta.setSelectingAndSortingUnspecifiedFields(false);
        MappingInputData sdi = new MappingInputData();
        sdi.linked = true;
        sdi.valueRenames = new ArrayList();
        sdi.valueRenames.add(new MappingValueRename("number2", "n2"));
        sdi.valueRenames.add(new MappingValueRename("number4", "n4"));
        BlockingRowSet in = new BlockingRowSet(10);
        BlockingRowSet out = new BlockingRowSet(10);
        RowMeta rm = new RowMeta();
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("string", 2));
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("number1", 5));
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("number2", 5));
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("number3", 5));
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("number", 5));
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("number4", 5));
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("number5", 5));
        in.putRow((RowMetaInterface)rm, new Object[]{"str", new Integer(100501), new Integer(100502), new Integer(100503), new Integer(100500), new Integer(100504), new Integer(100505)});
        in.putRow((RowMetaInterface)rm, new Object[]{"str_1", new Integer(200501), new Integer(200502), new Integer(200503), new Integer(200500), new Integer(200504), new Integer(200505)});
        this.step.getInputRowSets().add(in);
        this.step.getOutputRowSets().add(out);
        Assert.assertTrue((boolean)this.step.init((StepMetaInterface)this.meta, (StepDataInterface)sdi));
        Assert.assertTrue((boolean)this.step.processRow((StepMetaInterface)this.meta, (StepDataInterface)sdi));
        Object[] outRowData = out.getRow();
        RowMetaInterface outMeta = out.getRowMeta();
        Assert.assertEquals((String)"All fields are expected.", (long)7L, (long)outMeta.size());
        int i = 0;
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)2L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"string", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number1", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"n2", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number3", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"n4", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number5", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field value mismatch.", (Object)"str", (Object)outRowData[0]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(100501), (Object)outRowData[1]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(100502), (Object)outRowData[2]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(100503), (Object)outRowData[3]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(100500), (Object)outRowData[4]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(100504), (Object)outRowData[5]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(100505), (Object)outRowData[6]);
        Assert.assertTrue((boolean)this.step.processRow((StepMetaInterface)this.meta, (StepDataInterface)sdi));
        outRowData = out.getRow();
        outMeta = out.getRowMeta();
        Assert.assertEquals((String)"All fields are expected.", (long)7L, (long)outMeta.size());
        i = 0;
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)2L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"string", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number1", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"n2", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number3", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"n4", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field type-meta mismatch.", (long)5L, (long)outMeta.getValueMeta(i).getType());
        Assert.assertEquals((String)"the field name-meta mismatch.", (Object)"number5", (Object)outMeta.getValueMeta(i++).getName());
        Assert.assertEquals((String)"the field value mismatch.", (Object)"str_1", (Object)outRowData[0]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(200501), (Object)outRowData[1]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(200502), (Object)outRowData[2]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(200503), (Object)outRowData[3]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(200500), (Object)outRowData[4]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(200504), (Object)outRowData[5]);
        Assert.assertEquals((String)"the field value mismatch.", (Object)new Integer(200505), (Object)outRowData[6]);
    }
}

