/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.memgroupby;

import java.util.HashMap;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.memgroupby.Aggregate;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupBy;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByData;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class MemoryGroupByAggregationNullsTest {
    static StepMockHelper<MemoryGroupByMeta, MemoryGroupByData> mockHelper;
    MemoryGroupBy step;
    MemoryGroupByData data;
    static int def;
    Aggregate aggregate;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        mockHelper = new StepMockHelper<MemoryGroupByMeta, MemoryGroupByData>("Memory Group By", MemoryGroupByMeta.class, MemoryGroupByData.class);
        Mockito.when((Object)MemoryGroupByAggregationNullsTest.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)MemoryGroupByAggregationNullsTest.mockHelper.logChannelInterface);
        Mockito.when((Object)MemoryGroupByAggregationNullsTest.mockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @Before
    public void setUp() throws Exception {
        RowMetaInterface rmi;
        this.data = new MemoryGroupByData();
        this.data.subjectnrs = new int[]{0};
        MemoryGroupByMeta meta = new MemoryGroupByMeta();
        meta.setAggregateType(new int[]{5});
        meta.setAggregateField(new String[]{"x"});
        ValueMetaInteger vmi = new ValueMetaInteger();
        Mockito.when((Object)MemoryGroupByAggregationNullsTest.mockHelper.stepMeta.getStepMetaInterface()).thenReturn((Object)meta);
        this.data.inputRowMeta = rmi = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        this.data.outputRowMeta = rmi;
        this.data.groupMeta = rmi;
        this.data.groupnrs = new int[0];
        this.data.map = new HashMap();
        Mockito.when((Object)rmi.getValueMeta(Mockito.anyInt())).thenReturn((Object)vmi);
        this.data.aggMeta = rmi;
        this.step = new MemoryGroupBy(MemoryGroupByAggregationNullsTest.mockHelper.stepMeta, (StepDataInterface)this.data, 0, MemoryGroupByAggregationNullsTest.mockHelper.transMeta, MemoryGroupByAggregationNullsTest.mockHelper.trans);
        this.aggregate = new Aggregate();
        this.aggregate.agg = new Object[]{def};
        this.data.map.put(this.getHashEntry(), this.aggregate);
    }

    MemoryGroupByData.HashEntry getHashEntry() {
        return this.data.getHashEntry(new Object[this.data.groupMeta.size()]);
    }

    @Test
    public void calcAggregateResulTestMin_1_Test() throws KettleException {
        this.step.setMinNullIsValued(true);
        this.step.addToAggregate(new Object[]{null});
        Aggregate agg = (Aggregate)this.data.map.get(this.getHashEntry());
        Assert.assertNotNull((String)"Hash code strategy changed?", (Object)agg);
        Assert.assertNull((String)"Value is set", (Object)agg.agg[0]);
    }

    @Test
    public void calcAggregateResulTestMin_5_Test() throws KettleException {
        this.step.setMinNullIsValued(false);
        this.step.addToAggregate(new Object[]{null});
        Aggregate agg = (Aggregate)this.data.map.get(this.getHashEntry());
        Assert.assertNotNull((String)"Hash code strategy changed?", (Object)agg);
        Assert.assertEquals((String)"Value is NOT set", (Object)def, (Object)agg.agg[0]);
    }

    @Test
    public void getAggregateResulTestMin_0_Test() throws KettleValueException {
        this.step.setAllNullsAreZero(true);
        Object[] row = this.step.getAggregateResult(this.aggregate);
        Assert.assertEquals((String)"Default value is not corrupted", (Object)def, (Object)row[0]);
    }

    @Test
    public void getAggregateResulTestMin_1_Test() throws KettleValueException {
        this.aggregate.agg[0] = null;
        this.step.setAllNullsAreZero(true);
        Object[] row = this.step.getAggregateResult(this.aggregate);
        Assert.assertEquals((String)"Returns 0 if aggregation is null", (Object)new Long(0L), (Object)row[0]);
    }

    @Test
    public void getAggregateResulTestMin_3_Test() throws KettleValueException {
        this.aggregate.agg[0] = null;
        this.step.setAllNullsAreZero(false);
        Object[] row = this.step.getAggregateResult(this.aggregate);
        Assert.assertNull((String)"Returns null if aggregation is null", (Object)row[0]);
    }

    static {
        def = 113;
    }
}

