/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.nullif;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.nullif.NullIf;
import org.pentaho.di.trans.steps.nullif.NullIfData;
import org.pentaho.di.trans.steps.nullif.NullIfMeta;
import org.pentaho.metastore.api.IMetaStore;

public class NullIfTest {
    StepMockHelper<NullIfMeta, NullIfData> smh;

    @Before
    public void setUp() {
        this.smh = new StepMockHelper<NullIfMeta, NullIfData>("Field NullIf processor", NullIfMeta.class, NullIfData.class);
        Mockito.when((Object)this.smh.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.smh.logChannelInterface);
        Mockito.when((Object)this.smh.trans.isRunning()).thenReturn((Object)true);
    }

    private RowSet mockInputRowSet() {
        return this.smh.getMockInputRowSet(new Object[][]{{"value1", "nullable-value", "value3"}});
    }

    private NullIfMeta mockProcessRowMeta() throws KettleStepException {
        NullIfMeta processRowMeta = (NullIfMeta)this.smh.processRowsStepMetaInterface;
        ((NullIfMeta)Mockito.doReturn((Object)new String[]{"nullable-field"}).when((Object)processRowMeta)).getFieldName();
        ((NullIfMeta)Mockito.doReturn((Object)new String[]{"nullable-value"}).when((Object)processRowMeta)).getFieldValue();
        ((NullIfMeta)Mockito.doCallRealMethod().when((Object)processRowMeta)).getFields((RowMetaInterface)Matchers.any(RowMetaInterface.class), Matchers.anyString(), (RowMetaInterface[])Matchers.any(RowMetaInterface[].class), (StepMeta)Matchers.any(StepMeta.class), (VariableSpace)Matchers.any(VariableSpace.class), (Repository)Matchers.any(Repository.class), (IMetaStore)Matchers.any(IMetaStore.class));
        return processRowMeta;
    }

    private RowMeta getInputRowMeta() {
        RowMeta inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("some-field"));
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("nullable-field"));
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("another-field"));
        return inputRowMeta;
    }

    @Test
    public void test() throws KettleException {
        boolean hasMoreRows;
        KettleEnvironment.init();
        NullIf step = new NullIf(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        step.init(this.smh.initStepMetaInterface, this.smh.stepDataInterface);
        step.setInputRowMeta((RowMetaInterface)this.getInputRowMeta());
        step.getInputRowSets().add(this.mockInputRowSet());
        step.getOutputRowSets().add(new QueueRowSet());
        while (hasMoreRows = step.processRow((StepMetaInterface)this.mockProcessRowMeta(), this.smh.processRowsStepDataInterface)) {
        }
        RowSet outputRowSet = (RowSet)step.getOutputRowSets().get(0);
        Object[] actualRow = outputRowSet.getRow();
        Object[] expectedRow = new Object[]{"value1", null, "value3"};
        Assert.assertEquals((String)"Output row is of an unexpected length", (int)expectedRow.length, (int)outputRowSet.getRowMeta().size());
        for (int i = 0; i < expectedRow.length; ++i) {
            Assert.assertEquals((String)("Unexpected output value at index " + i), (Object)expectedRow[i], (Object)actualRow[i]);
        }
    }
}

