/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pgbulkloader;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoader;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoaderData;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoaderMeta;

public class PGBulkLoaderMetaTest {
    private StepMeta stepMeta;
    private PGBulkLoader loader;
    private PGBulkLoaderData ld;
    private PGBulkLoaderMeta lm;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)ValueMetaPluginType.getInstance());
        PluginRegistry.init((boolean)true);
    }

    @Before
    public void setUp() {
        TransMeta transMeta = new TransMeta();
        transMeta.setName("loader");
        this.lm = new PGBulkLoaderMeta();
        this.ld = new PGBulkLoaderData();
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String loaderPid = plugReg.getPluginId(StepPluginType.class, (Object)this.lm);
        this.stepMeta = new StepMeta(loaderPid, "loader", (StepMetaInterface)this.lm);
        Trans trans = new Trans(transMeta);
        transMeta.addStep(this.stepMeta);
        this.loader = new PGBulkLoader(this.stepMeta, (StepDataInterface)this.ld, 1, transMeta, trans);
    }

    @Test
    public void testTopLevelMetadataEntries() {
        try {
            List entries = this.loader.getStepMeta().getStepMetaInterface().getStepMetaInjectionInterface().getStepInjectionMetadataEntries();
            String masterKeys = "SCHEMA TABLE LOADACTION STOPONERROR DELIMITER ENCLOSURE PSQLPATH DBNAMEOVERRIDE MAPPINGS ";
            for (StepInjectionMetaEntry entry : entries) {
                String key = entry.getKey();
                Assert.assertTrue((boolean)masterKeys.contains(key));
                masterKeys = masterKeys.replace(key, "");
            }
            Assert.assertTrue((masterKeys.trim().length() == 0 ? 1 : 0) != 0);
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testChildLevelMetadataEntries() {
        try {
            List entries = this.loader.getStepMeta().getStepMetaInterface().getStepMetaInjectionInterface().getStepInjectionMetadataEntries();
            String childKeys = "STREAMNAME FIELDNAME DATEMASK ";
            StepInjectionMetaEntry mappingEntry = null;
            for (StepInjectionMetaEntry entry : entries) {
                String key = entry.getKey();
                if (!key.equals("MAPPINGS")) continue;
                mappingEntry = entry;
                break;
            }
            Assert.assertNotNull(mappingEntry);
            List fieldAttributes = ((StepInjectionMetaEntry)mappingEntry.getDetails().get(0)).getDetails();
            for (StepInjectionMetaEntry attribute : fieldAttributes) {
                String key = attribute.getKey();
                Assert.assertTrue((boolean)childKeys.contains(key));
                childKeys = childKeys.replace(key, "");
            }
            Assert.assertTrue((childKeys.trim().length() == 0 ? 1 : 0) != 0);
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInjection() {
        try {
            List entries = this.loader.getStepMeta().getStepMetaInterface().getStepMetaInjectionInterface().getStepInjectionMetadataEntries();
            for (StepInjectionMetaEntry entry : entries) {
                entry.setValueType(this.lm.findAttribute(entry.getKey()).getType());
                switch (entry.getValueType()) {
                    case 2: {
                        entry.setValue((Object)"new_".concat(entry.getKey()));
                        break;
                    }
                    case 4: {
                        entry.setValue((Object)Boolean.TRUE);
                        break;
                    }
                }
                if (entry.getDetails().isEmpty()) continue;
                List childEntries = ((StepInjectionMetaEntry)entry.getDetails().get(0)).getDetails();
                for (StepInjectionMetaEntry childEntry : childEntries) {
                    childEntry.setValue((Object)"new_".concat(childEntry.getKey()));
                }
            }
            this.loader.getStepMeta().getStepMetaInterface().getStepMetaInjectionInterface().injectStepMetadataEntries(entries);
            Assert.assertEquals((String)"Schema name not properly injected... ", (Object)"new_SCHEMA", (Object)this.lm.getSchemaName());
            Assert.assertEquals((String)"Table name not properly injected... ", (Object)"new_TABLE", (Object)this.lm.getTableName());
            Assert.assertEquals((String)"DB Name Override not properly injected... ", (Object)"new_DBNAMEOVERRIDE", (Object)this.lm.getDbNameOverride());
            Assert.assertEquals((String)"Delimiter not properly injected... ", (Object)"new_DELIMITER", (Object)this.lm.getDelimiter());
            Assert.assertEquals((String)"Enclosure not properly injected... ", (Object)"new_ENCLOSURE", (Object)this.lm.getEnclosure());
            Assert.assertEquals((String)"Load action not properly injected... ", (Object)"new_LOADACTION", (Object)this.lm.getLoadAction());
            Assert.assertEquals((String)"PSQL path not properly injected... ", (Object)"new_PSQLPATH", (Object)this.lm.getPsqlpath());
            Assert.assertEquals((String)"Stop on error not properly injected... ", (Object)Boolean.TRUE, (Object)this.lm.isStopOnError());
            Assert.assertEquals((String)"Field name not properly injected... ", (Object)"new_FIELDNAME", (Object)this.lm.getFieldTable()[0]);
            Assert.assertEquals((String)"Stream name not properly injected... ", (Object)"new_STREAMNAME", (Object)this.lm.getFieldStream()[0]);
            Assert.assertEquals((String)"Date Mask not properly injected... ", (Object)"new_DATEMASK", (Object)this.lm.getDateMask()[0]);
        }
        catch (KettleException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

