/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rest;

import com.sun.jersey.api.container.httpserver.HttpServerFactory;
import com.sun.net.httpserver.HttpServer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.rest.Rest;
import org.pentaho.di.trans.steps.rest.RestData;
import org.pentaho.di.trans.steps.rest.RestMeta;

public class RestIT {
    public static final String HTTP_LOCALHOST_9998 = "http://localhost:9998/";
    private StepMockHelper<RestMeta, RestData> stepMockHelper;
    private HttpServer server;

    @BeforeClass
    public static void setupBeforeClass() throws KettleException {
        KettleClientEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<RestMeta, RestData>("REST CLIENT TEST", RestMeta.class, RestData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
        ((Trans)Mockito.verify((Object)this.stepMockHelper.trans, (VerificationMode)Mockito.never())).stopAll();
        this.server = HttpServerFactory.create((String)HTTP_LOCALHOST_9998);
        this.server.start();
    }

    @After
    public void tearDown() throws Exception {
        this.server.stop(0);
    }

    @Test
    public void testNoContent() throws Exception {
        RestData data = new RestData();
        Object[] expectedRow = new Object[]{"", 204L, null, null, null, null, null, null, null, null, null, null};
        RestHandler rest = new RestHandler(this.stepMockHelper.stepMeta, (StepDataInterface)data, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        rest.setInputRowMeta(inputRowMeta);
        Mockito.when((Object)inputRowMeta.clone()).thenReturn((Object)inputRowMeta);
        Mockito.when((Object)((RestMeta)this.stepMockHelper.processRowsStepMetaInterface).getUrl()).thenReturn((Object)"http://localhost:9998/restTest/restNoContentAnswer");
        Mockito.when((Object)((RestMeta)this.stepMockHelper.processRowsStepMetaInterface).getMethod()).thenReturn((Object)"GET");
        rest.init((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)data);
        data.resultFieldName = "ResultFieldName";
        data.resultCodeFieldName = "ResultCodeFieldName";
        Assert.assertTrue((boolean)rest.processRow((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)data));
        System.out.println(Arrays.toString(expectedRow));
        Object[] out = rest.getOutputRow();
        System.out.println(Arrays.toString(out));
        Assert.assertTrue((boolean)Arrays.equals(expectedRow, out));
    }

    @Test
    public void testLoadSaveRoundTrip() throws KettleException {
        List<String> attributes = Arrays.asList("applicationType", "method", "url", "urlInField", "dynamicMethod", "methodFieldName", "urlField", "bodyField", "httpLogin", "httpPassword", "proxyHost", "proxyPort", "preemptive", "trustStoreFile", "trustStorePassword", "headerField", "headerName", "parameterField", "parameterName", "matrixParameterField", "matrixParameterName", "fieldName", "resultCodeFieldName", "responseTimeFieldName");
        HashMap fieldLoadSaveValidatorAttributeMap = new HashMap();
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 25);
        fieldLoadSaveValidatorAttributeMap.put("headerField", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("headerName", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("parameterField", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("parameterName", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("matrixParameterField", stringArrayLoadSaveValidator);
        fieldLoadSaveValidatorAttributeMap.put("matrixParameterName", stringArrayLoadSaveValidator);
        LoadSaveTester loadSaveTester = new LoadSaveTester(RestMeta.class, attributes, new HashMap<String, String>(), new HashMap<String, String>(), fieldLoadSaveValidatorAttributeMap, new HashMap());
        loadSaveTester.testRepoRoundTrip();
        loadSaveTester.testXmlRoundTrip();
    }

    private class RestHandler
    extends Rest {
        Object[] row;
        Object[] outputRow;

        public RestHandler(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
            this.row = new Object[]{"anyData"};
        }

        public void setRow(Object[] row) {
            this.row = row;
        }

        public Object[] getRow() throws KettleException {
            return this.row;
        }

        public void putRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            this.outputRow = row;
        }

        public Object[] getOutputRow() {
            return this.outputRow;
        }
    }
}

