/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.selectvalues;

import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleConversionException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.StepAttributesInterface;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.selectvalues.SelectMetadataChange;
import org.pentaho.di.trans.steps.selectvalues.SelectValues;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesData;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;

public class SelectValuesTest {
    private static final String SELECTED_FIELD = "field";
    private final Object[] inputRow = new Object[]{"a string"};
    private SelectValues step;

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        StepMockHelper<SelectValuesMeta, StepDataInterface> helper = StepMockUtil.getStepMockHelper(SelectValuesMeta.class, "SelectValuesTest");
        Mockito.when((Object)helper.stepMeta.isDoingErrorHandling()).thenReturn((Object)true);
        this.step = new SelectValues(helper.stepMeta, helper.stepDataInterface, 1, helper.transMeta, helper.trans);
        this.step = (SelectValues)Mockito.spy((Object)this.step);
        ((SelectValues)Mockito.doReturn((Object)this.inputRow).when((Object)this.step)).getRow();
        ((SelectValues)Mockito.doNothing().when((Object)this.step)).putError((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        RowMeta inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(SELECTED_FIELD));
        this.step.setInputRowMeta((RowMetaInterface)inputRowMeta);
    }

    @Test
    public void errorRowSetObtainsFieldName() throws Exception {
        SelectValuesMeta stepMeta = new SelectValuesMeta();
        stepMeta.allocate(1, 0, 1);
        stepMeta.getSelectName()[0] = SELECTED_FIELD;
        stepMeta.getMeta()[0] = new SelectMetadataChange((StepAttributesInterface)stepMeta, SELECTED_FIELD, null, 5, -2, -2, 0, null, false, null, null, false, null, null, null);
        SelectValuesData stepData = new SelectValuesData();
        stepData.select = true;
        stepData.metadata = true;
        stepData.firstselect = true;
        stepData.firstmetadata = true;
        this.step.processRow((StepMetaInterface)stepMeta, (StepDataInterface)stepData);
        ((SelectValues)Mockito.verify((Object)this.step)).putError((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyLong(), Matchers.anyString(), (String)Mockito.eq((Object)SELECTED_FIELD), Matchers.anyString());
        boolean properException = false;
        try {
            this.step.metadataValues(this.step.getInputRowMeta(), this.inputRow);
        }
        catch (KettleConversionException e) {
            properException = true;
        }
        Assert.assertTrue((boolean)properException);
    }
}

