/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.simplemapping;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.simplemapping.RowDataInputMapper;
import org.pentaho.di.trans.steps.simplemapping.SimpleMapping;
import org.pentaho.di.trans.steps.simplemapping.SimpleMappingData;
import org.pentaho.di.trans.steps.simplemapping.SimpleMappingMeta;

public class SimpleMappingTest {
    private static final String MAPPING_INPUT_STEP_NAME = "MAPPING_INPUT_STEP_NAME";
    private static final String MAPPING_OUTPUT_STEP_NAME = "MAPPING_OUTPUT_STEP_NAME";
    private StepMockHelper<SimpleMappingMeta, SimpleMappingData> stepMockHelper;
    private SimpleMappingData simpleMpData = new SimpleMappingData();
    private SimpleMapping smp;

    @Before
    public void setup() throws Exception {
        this.stepMockHelper = new StepMockHelper<SimpleMappingMeta, SimpleMappingData>("SIMPLE_MAPPING_TEST", SimpleMappingMeta.class, SimpleMappingData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
        MappingInput mpInputMock = (MappingInput)Mockito.mock(MappingInput.class);
        Mockito.when((Object)mpInputMock.getStepname()).thenReturn((Object)MAPPING_INPUT_STEP_NAME);
        MappingOutput mpOutputMock = (MappingOutput)Mockito.mock(MappingOutput.class);
        Mockito.when((Object)mpOutputMock.getStepname()).thenReturn((Object)MAPPING_OUTPUT_STEP_NAME);
        RowDataInputMapper rdInputMpMock = (RowDataInputMapper)Mockito.mock(RowDataInputMapper.class);
        RowMetaInterface rwMetaInMock = (RowMetaInterface)Mockito.mock(RowMeta.class);
        ((RowDataInputMapper)Mockito.doReturn((Object)Boolean.TRUE).when((Object)rdInputMpMock)).putRow(rwMetaInMock, new Object[0]);
        RowProducer rProducerMock = (RowProducer)Mockito.mock(RowProducer.class);
        Mockito.when((Object)rProducerMock.putRow((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyBoolean())).thenReturn((Object)true);
        MappingIODefinition mpIODefMock = (MappingIODefinition)Mockito.mock(MappingIODefinition.class);
        this.simpleMpData.mappingInput = mpInputMock;
        this.simpleMpData.mappingOutput = mpOutputMock;
        this.simpleMpData.rowDataInputMapper = rdInputMpMock;
        this.simpleMpData.mappingTrans = this.stepMockHelper.trans;
        Mockito.when((Object)this.stepMockHelper.trans.findStepInterface(MAPPING_OUTPUT_STEP_NAME, 0)).thenReturn((Object)mpOutputMock);
        Mockito.when((Object)this.stepMockHelper.trans.addRowProducer(MAPPING_INPUT_STEP_NAME, 0)).thenReturn((Object)rProducerMock);
        Mockito.when((Object)((SimpleMappingMeta)this.stepMockHelper.processRowsStepMetaInterface).getInputMapping()).thenReturn((Object)mpIODefMock);
    }

    @Test
    public void testStepSetUpAsWasStarted_AtProcessingFirstRow() throws KettleException {
        this.smp = new SimpleMapping(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        this.smp.init(this.stepMockHelper.initStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        this.smp.getInputRowSets().add(this.stepMockHelper.getMockInputRowSet(new Object[][]{new Object[0]}));
        Assert.assertTrue((String)"The step is processing in first", (boolean)this.smp.first);
        Assert.assertTrue((boolean)this.smp.processRow(this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)this.simpleMpData));
        Assert.assertFalse((String)"The step is processing not in first", (boolean)this.smp.first);
        Assert.assertTrue((String)"The step was started", (boolean)this.smp.getData().wasStarted);
    }

    @Test
    public void testStepShouldProcessError_WhenMappingTransHasError() throws KettleException {
        int errorCount = 1;
        Mockito.when((Object)this.stepMockHelper.trans.getErrors()).thenReturn((Object)errorCount);
        Mockito.when((Object)this.stepMockHelper.trans.isFinished()).thenReturn((Object)Boolean.TRUE);
        this.simpleMpData.wasStarted = true;
        this.smp = new SimpleMapping(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        this.smp.init(this.stepMockHelper.initStepMetaInterface, (StepDataInterface)this.simpleMpData);
        this.smp.dispose(this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)this.simpleMpData);
        ((Trans)Mockito.verify((Object)this.stepMockHelper.trans, (VerificationMode)Mockito.times((int)1))).isFinished();
        ((Trans)Mockito.verify((Object)this.stepMockHelper.trans, (VerificationMode)Mockito.never())).waitUntilFinished();
        ((Trans)Mockito.verify((Object)this.stepMockHelper.trans, (VerificationMode)Mockito.never())).getActiveSubtransformations();
        ((Trans)Mockito.verify((Object)this.stepMockHelper.trans, (VerificationMode)Mockito.times((int)1))).getErrors();
        Assert.assertTrue((String)"The step contains the errors", (this.smp.getErrors() == (long)errorCount ? 1 : 0) != 0);
    }

    @Test
    public void testStepShouldStopProcessingInput_IfUnderlyingTransitionIsStopped() throws Exception {
        MappingInput mappingInput = (MappingInput)Mockito.mock(MappingInput.class);
        Mockito.when((Object)mappingInput.getStepname()).thenReturn((Object)MAPPING_INPUT_STEP_NAME);
        ((SimpleMappingData)this.stepMockHelper.processRowsStepDataInterface).mappingInput = mappingInput;
        RowProducer rowProducer = (RowProducer)Mockito.mock(RowProducer.class);
        Mockito.when((Object)rowProducer.putRow((RowMetaInterface)Matchers.any(RowMetaInterface.class), (Object[])Matchers.any(Object[].class), Matchers.anyBoolean())).thenReturn((Object)true);
        StepInterface stepInterface = (StepInterface)Mockito.mock(StepInterface.class);
        Trans mappingTrans = (Trans)Mockito.mock(Trans.class);
        Mockito.when((Object)mappingTrans.addRowProducer(Matchers.anyString(), Matchers.anyInt())).thenReturn((Object)rowProducer);
        Mockito.when((Object)mappingTrans.findStepInterface(Matchers.anyString(), Matchers.anyInt())).thenReturn((Object)stepInterface);
        Mockito.when((Object)mappingTrans.isFinishedOrStopped()).thenReturn((Object)Boolean.FALSE).thenReturn((Object)Boolean.TRUE);
        ((SimpleMappingData)this.stepMockHelper.processRowsStepDataInterface).mappingTrans = mappingTrans;
        MappingOutput mappingOutput = (MappingOutput)Mockito.mock(MappingOutput.class);
        Mockito.when((Object)mappingOutput.getStepname()).thenReturn((Object)MAPPING_OUTPUT_STEP_NAME);
        ((SimpleMappingData)this.stepMockHelper.processRowsStepDataInterface).mappingOutput = mappingOutput;
        this.smp = new SimpleMapping(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        this.smp.init(this.stepMockHelper.initStepMetaInterface, (StepDataInterface)this.simpleMpData);
        this.smp.getInputRowSets().add(this.stepMockHelper.getMockInputRowSet(new Object[][]{new Object[0]}));
        this.smp.getInputRowSets().add(this.stepMockHelper.getMockInputRowSet(new Object[][]{new Object[0]}));
        Assert.assertTrue((boolean)this.smp.processRow(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.processRowsStepDataInterface));
        Assert.assertFalse((boolean)this.smp.processRow(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.processRowsStepDataInterface));
    }

    @After
    public void tearDown() {
        this.stepMockHelper.cleanUp();
    }
}

