/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.transexecutor;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.transexecutor.TransExecutor;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorData;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;

public class TransExecutorUnitTest {
    private TransExecutor executor;
    private TransExecutorMeta meta;
    private TransExecutorData data;
    private Trans internalTrans;
    private Result internalResult;

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.executor = StepMockUtil.getStep(TransExecutor.class, TransExecutorMeta.class, "TransExecutorUnitTest");
        this.executor = (TransExecutor)Mockito.spy((Object)this.executor);
        TransMeta internalTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransExecutor)Mockito.doReturn((Object)internalTransMeta).when((Object)this.executor)).loadExecutorTransMeta();
        this.internalTrans = (Trans)Mockito.spy((Object)new Trans());
        this.internalTrans.setLog((LogChannelInterface)Mockito.mock(LogChannelInterface.class));
        ((Trans)Mockito.doNothing().when((Object)this.internalTrans)).prepareExecution((String[])Mockito.any(String[].class));
        ((Trans)Mockito.doNothing().when((Object)this.internalTrans)).startThreads();
        ((Trans)Mockito.doNothing().when((Object)this.internalTrans)).waitUntilFinished();
        ((TransExecutor)Mockito.doNothing().when((Object)this.executor)).discardLogLines((TransExecutorData)Mockito.any(TransExecutorData.class));
        ((TransExecutor)Mockito.doReturn((Object)this.internalTrans).when((Object)this.executor)).createInternalTrans();
        this.internalResult = new Result();
        Mockito.when((Object)this.internalTrans.getResult()).thenReturn((Object)this.internalResult);
        this.meta = new TransExecutorMeta();
        this.data = new TransExecutorData();
    }

    @After
    public void tearDown() {
        this.executor = null;
        this.meta = null;
        this.data = null;
        this.internalTrans = null;
        this.internalResult = null;
    }

    @Test
    public void collectsResultsFromInternalTransformation() throws Exception {
        this.prepareOneRowForExecutor();
        RowMetaAndData expectedResult = new RowMetaAndData((RowMetaInterface)new RowMeta(), new Object[]{"fake result"});
        this.internalResult.getRows().add(expectedResult);
        QueueRowSet rowSet = new QueueRowSet();
        StepMeta stepMeta = this.mockStepAndMapItToRowSet("stepMetaMock", (RowSet)rowSet);
        this.meta.setOutputRowsSourceStepMeta(stepMeta);
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.setInputRowMeta((RowMetaInterface)new RowMeta());
        Assert.assertTrue((String)"Passing one line at first time", (boolean)this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        Assert.assertFalse((String)"Executing the internal trans during the second round", (boolean)this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        Object[] resultsRow = rowSet.getRowImmediate();
        Assert.assertNotNull((Object)resultsRow);
        Assert.assertArrayEquals((Object[])expectedResult.getData(), (Object[])resultsRow);
        Assert.assertNull((String)"Only one row is expected", (Object)rowSet.getRowImmediate());
    }

    @Test
    public void collectsExecutionResults() throws Exception {
        this.prepareOneRowForExecutor();
        StepMeta parentStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)parentStepMeta.getName()).thenReturn((Object)"parentStepMeta");
        this.meta.setParentStepMeta(parentStepMeta);
        this.internalResult.setResult(true);
        this.meta.setExecutionResultField("executionResultField");
        this.internalResult.setNrErrors(1L);
        this.meta.setExecutionNrErrorsField("executionNrErrorsField");
        this.internalResult.setNrLinesRead(2L);
        this.meta.setExecutionLinesReadField("executionLinesReadField");
        this.internalResult.setNrLinesWritten(3L);
        this.meta.setExecutionLinesWrittenField("executionLinesWrittenField");
        this.internalResult.setNrLinesInput(4L);
        this.meta.setExecutionLinesInputField("executionLinesInputField");
        this.internalResult.setNrLinesOutput(5L);
        this.meta.setExecutionLinesOutputField("executionLinesOutputField");
        this.internalResult.setNrLinesRejected(6L);
        this.meta.setExecutionLinesRejectedField("executionLinesRejectedField");
        this.internalResult.setNrLinesUpdated(7L);
        this.meta.setExecutionLinesUpdatedField("executionLinesUpdatedField");
        this.internalResult.setNrLinesDeleted(8L);
        this.meta.setExecutionLinesDeletedField("executionLinesDeletedField");
        this.internalResult.setNrFilesRetrieved(9L);
        this.meta.setExecutionFilesRetrievedField("executionFilesRetrievedField");
        this.internalResult.setExitStatus(10);
        this.meta.setExecutionExitStatusField("executionExitStatusField");
        QueueRowSet rowSet = new QueueRowSet();
        StepMeta stepMeta = this.mockStepAndMapItToRowSet("stepMetaMock", (RowSet)rowSet);
        this.meta.setExecutionResultTargetStepMeta(stepMeta);
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.setInputRowMeta((RowMetaInterface)new RowMeta());
        Assert.assertTrue((String)"Passing one line at first time", (boolean)this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        Assert.assertFalse((String)"Executing the internal trans during the second round", (boolean)this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        Object[] resultsRow = rowSet.getRowImmediate();
        Assert.assertNotNull((Object)resultsRow);
        Assert.assertNull((String)"Only one row is expected", (Object)rowSet.getRowImmediate());
        Assert.assertEquals((Object)this.internalResult.getResult(), (Object)resultsRow[0]);
        Assert.assertEquals((Object)this.internalResult.getNrErrors(), (Object)resultsRow[1]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesRead(), (Object)resultsRow[2]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesWritten(), (Object)resultsRow[3]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesInput(), (Object)resultsRow[4]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesOutput(), (Object)resultsRow[5]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesRejected(), (Object)resultsRow[6]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesUpdated(), (Object)resultsRow[7]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesDeleted(), (Object)resultsRow[8]);
        Assert.assertEquals((Object)this.internalResult.getNrFilesRetrieved(), (Object)resultsRow[9]);
        Assert.assertEquals((long)this.internalResult.getExitStatus(), (long)((Number)resultsRow[10]).intValue());
    }

    @Test
    public void shouldAccumulateRowsWhenGroupFieldIsSpecified() throws KettleException {
        this.prepareMultipleRowsForExecutor();
        this.meta.setGroupField("groupField");
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("groupField"));
        this.executor.setInputRowMeta((RowMetaInterface)rowMeta);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)1L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)4L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)1L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)3L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)0L, (long)this.data.groupBuffer.size());
    }

    @Test
    public void shouldAccumulateRowsByCount() throws KettleException {
        this.prepareMultipleRowsForExecutor();
        this.meta.setGroupSize("5");
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)1L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)4L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)0L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)1L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)2L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)0L, (long)this.data.groupBuffer.size());
    }

    private void prepareMultipleRowsForExecutor() throws KettleException {
        ((TransExecutor)Mockito.doReturn((Object)new Object[]{"value1"}).doReturn((Object)new Object[]{"value1"}).doReturn((Object)new Object[]{"value1"}).doReturn((Object)new Object[]{"value1"}).doReturn((Object)new Object[]{"value12"}).doReturn((Object)new Object[]{"value12"}).doReturn((Object)new Object[]{"value12"}).doReturn(null).when((Object)this.executor)).getRow();
    }

    private void prepareOneRowForExecutor() throws Exception {
        ((TransExecutor)Mockito.doReturn((Object)new Object[]{"row"}).doReturn(null).when((Object)this.executor)).getRow();
    }

    private StepMeta mockStepAndMapItToRowSet(String stepName, RowSet rowSet) throws KettleStepException {
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)stepMeta.getName()).thenReturn((Object)stepName);
        ((TransExecutor)Mockito.doReturn((Object)rowSet).when((Object)this.executor)).findOutputRowSet(stepName);
        return stepMeta;
    }
}

