/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.utils;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.core.vfs.KettleVFS;

public class TestUtils {
    public static String createTempDir() {
        String ret = null;
        try {
            File file = File.createTempFile("temp_pentaho_test_dir", String.valueOf(System.currentTimeMillis()));
            file.delete();
            file.mkdir();
            file.deleteOnExit();
            ret = file.getAbsolutePath();
        }
        catch (Exception ex) {
            System.out.println("Can't create temp folder");
            ex.printStackTrace();
        }
        return ret;
    }

    public static File getInputFile(String prefix, String suffix) throws IOException {
        File inputFile = File.createTempFile(prefix, suffix);
        inputFile.deleteOnExit();
        FileUtils.writeStringToFile((File)inputFile, (String)UUID.randomUUID().toString(), (String)"UTF-8");
        return inputFile;
    }

    public static String createRamFile(String path) {
        try {
            FileObject file = KettleVFS.getInstance().getFileSystemManager().resolveFile("ram://" + path);
            file.createFile();
            return file.getName().getURI();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileObject getFileObject(String vfsPath) {
        try {
            return KettleVFS.getInstance().getFileSystemManager().resolveFile(vfsPath);
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toUnixLineSeparators(String string) {
        if (string != null) {
            string = string.replaceAll("\r", "");
        }
        return string;
    }
}

