/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.dependency;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.dependency.ActionDependency;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.dependency.URIHandlerException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class DependencyChecker {
    public static String dependenciesAsString(List<String> missingDependencies) {
        return StringUtils.join(missingDependencies, (String)"#");
    }

    public static String[] dependenciesAsArray(String missingDependencies) {
        return missingDependencies.split("#");
    }

    public static ActionDependency checkForAvailability(String missingDependencies, Configuration actionConf, boolean stopOnFirstMissing) throws CommandException {
        return DependencyChecker.checkForAvailability(DependencyChecker.dependenciesAsArray(missingDependencies), actionConf, stopOnFirstMissing);
    }

    public static ActionDependency checkForAvailability(String[] missingDependencies, Configuration actionConf, boolean stopOnFirstMissing) throws CommandException {
        XLog LOG = XLog.getLog(DependencyChecker.class);
        String user = ParamChecker.notEmpty(actionConf.get("user.name"), "user.name");
        ArrayList<String> missingDeps = new ArrayList<String>();
        ArrayList<String> availableDeps = new ArrayList<String>();
        URIHandlerService uriService = Services.get().get(URIHandlerService.class);
        boolean continueChecking = true;
        try {
            for (int index = 0; index < missingDependencies.length; ++index) {
                if (continueChecking) {
                    String dependency = missingDependencies[index];
                    URI uri = new URI(dependency);
                    URIHandler uriHandler = uriService.getURIHandler(uri);
                    LOG.debug("Checking for the availability of dependency [{0}] ", dependency);
                    if (uriHandler.exists(uri, actionConf, user)) {
                        LOG.debug("Dependency [{0}] is available", dependency);
                        availableDeps.add(dependency);
                        continue;
                    }
                    LOG.debug("Dependency [{0}] is missing", dependency);
                    missingDeps.add(dependency);
                    if (!stopOnFirstMissing) continue;
                    continueChecking = false;
                    continue;
                }
                missingDeps.add(missingDependencies[index]);
            }
        }
        catch (URISyntaxException e) {
            throw new CommandException(ErrorCode.E0906, e.getMessage(), e);
        }
        catch (URIHandlerException e) {
            throw new CommandException(e);
        }
        return new ActionDependency(missingDeps, availableDeps);
    }
}

