/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.QueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class CoordActionQueryExecutor
extends QueryExecutor<CoordinatorActionBean, CoordActionQuery> {
    private static CoordActionQueryExecutor instance = new CoordActionQueryExecutor();

    private CoordActionQueryExecutor() {
    }

    public static QueryExecutor<CoordinatorActionBean, CoordActionQuery> getInstance() {
        return instance;
    }

    @Override
    public Query getUpdateQuery(CoordActionQuery namedQuery, CoordinatorActionBean actionBean, EntityManager em) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case UPDATE_COORD_ACTION: {
                query.setParameter("actionNumber", (Object)actionBean.getActionNumber());
                query.setParameter("actionXml", (Object)actionBean.getActionXmlBlob());
                query.setParameter("consoleUrl", (Object)actionBean.getConsoleUrl());
                query.setParameter("createdConf", (Object)actionBean.getCreatedConfBlob());
                query.setParameter("errorCode", (Object)actionBean.getErrorCode());
                query.setParameter("errorMessage", (Object)actionBean.getErrorMessage());
                query.setParameter("externalStatus", (Object)actionBean.getExternalStatus());
                query.setParameter("missingDependencies", (Object)actionBean.getMissingDependenciesBlob());
                query.setParameter("runConf", (Object)actionBean.getRunConfBlob());
                query.setParameter("timeOut", (Object)actionBean.getTimeOut());
                query.setParameter("trackerUri", (Object)actionBean.getTrackerUri());
                query.setParameter("type", (Object)actionBean.getType());
                query.setParameter("createdTime", (Object)actionBean.getCreatedTimestamp());
                query.setParameter("externalId", (Object)actionBean.getExternalId());
                query.setParameter("jobId", (Object)actionBean.getJobId());
                query.setParameter("lastModifiedTime", (Object)new Date());
                query.setParameter("nominalTime", (Object)actionBean.getNominalTimestamp());
                query.setParameter("slaXml", (Object)actionBean.getSlaXmlBlob());
                query.setParameter("status", (Object)actionBean.getStatus().toString());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_COORD_ACTION_STATUS_PENDING_TIME: {
                query.setParameter("status", (Object)actionBean.getStatus().toString());
                query.setParameter("pending", (Object)actionBean.getPending());
                query.setParameter("lastModifiedTime", (Object)new Date());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_COORD_ACTION_FOR_INPUTCHECK: {
                query.setParameter("status", (Object)actionBean.getStatus().toString());
                query.setParameter("lastModifiedTime", (Object)new Date());
                query.setParameter("actionXml", (Object)actionBean.getActionXmlBlob());
                query.setParameter("missingDependencies", (Object)actionBean.getMissingDependenciesBlob());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_COORD_ACTION_FOR_PUSH_INPUTCHECK: {
                query.setParameter("status", (Object)actionBean.getStatus().toString());
                query.setParameter("lastModifiedTime", (Object)new Date());
                query.setParameter("actionXml", (Object)actionBean.getActionXmlBlob());
                query.setParameter("pushMissingDependencies", (Object)actionBean.getPushMissingDependenciesBlob());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_COORD_ACTION_DEPENDENCIES: {
                query.setParameter("missingDependencies", (Object)actionBean.getMissingDependenciesBlob());
                query.setParameter("pushMissingDependencies", (Object)actionBean.getPushMissingDependenciesBlob());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_COORD_ACTION_FOR_START: {
                query.setParameter("status", (Object)actionBean.getStatus().toString());
                query.setParameter("lastModifiedTime", (Object)new Date());
                query.setParameter("runConf", (Object)actionBean.getRunConfBlob());
                query.setParameter("externalId", (Object)actionBean.getExternalId());
                query.setParameter("pending", (Object)actionBean.getPending());
                query.setParameter("errorCode", (Object)actionBean.getErrorCode());
                query.setParameter("errorMessage", (Object)actionBean.getErrorMessage());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_COORD_ACTION_FOR_MODIFIED_DATE: {
                query.setParameter("lastModifiedTime", (Object)actionBean.getLastModifiedTimestamp());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            case UPDATE_COORD_ACTION_RERUN: {
                query.setParameter("actionXml", (Object)actionBean.getActionXmlBlob());
                query.setParameter("status", (Object)actionBean.getStatusStr());
                query.setParameter("externalId", (Object)actionBean.getExternalId());
                query.setParameter("externalStatus", (Object)actionBean.getExternalStatus());
                query.setParameter("rerunTime", (Object)actionBean.getRerunTimestamp());
                query.setParameter("lastModifiedTime", (Object)actionBean.getLastModifiedTimestamp());
                query.setParameter("createdTime", (Object)actionBean.getCreatedTimestamp());
                query.setParameter("createdConf", (Object)actionBean.getCreatedConfBlob());
                query.setParameter("runConf", (Object)actionBean.getRunConfBlob());
                query.setParameter("missingDependencies", (Object)actionBean.getMissingDependenciesBlob());
                query.setParameter("pushMissingDependencies", (Object)actionBean.getPushMissingDependenciesBlob());
                query.setParameter("errorCode", (Object)actionBean.getErrorCode());
                query.setParameter("errorMessage", (Object)actionBean.getErrorMessage());
                query.setParameter("id", (Object)actionBean.getId());
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + namedQuery.name());
            }
        }
        return query;
    }

    @Override
    public Query getSelectQuery(CoordActionQuery namedQuery, EntityManager em, Object ... parameters) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        CoordActionQuery caQuery = namedQuery;
        switch (caQuery) {
            case GET_COORD_ACTION: 
            case GET_COORD_ACTION_STATUS: {
                query.setParameter("id", parameters[0]);
                break;
            }
            case GET_COORD_ACTIONS_BY_LAST_MODIFIED_TIME: {
                query.setParameter("lastModifiedTime", (Object)new Timestamp(((Date)parameters[0]).getTime()));
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + caQuery.name());
            }
        }
        return query;
    }

    @Override
    public int executeUpdate(CoordActionQuery namedQuery, CoordinatorActionBean jobBean) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getUpdateQuery(namedQuery, jobBean, em);
        int ret = jpaService.executeUpdate(namedQuery.name(), query, em);
        return ret;
    }

    @Override
    public CoordinatorActionBean get(CoordActionQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        Object ret = jpaService.executeGet(namedQuery.name(), query, em);
        if (ret == null) {
            throw new JPAExecutorException(ErrorCode.E0605, query.toString());
        }
        CoordinatorActionBean bean = this.constructBean(namedQuery, ret);
        return bean;
    }

    @Override
    public List<CoordinatorActionBean> getList(CoordActionQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        JPAService jpaService = Services.get().get(JPAService.class);
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        List<?> retList = jpaService.executeGetList(namedQuery.name(), query, em);
        ArrayList<CoordinatorActionBean> beanList = new ArrayList<CoordinatorActionBean>();
        if (retList != null) {
            for (Object ret : retList) {
                beanList.add(this.constructBean(namedQuery, ret));
            }
        }
        return beanList;
    }

    private CoordinatorActionBean constructBean(CoordActionQuery namedQuery, Object ret) throws JPAExecutorException {
        CoordinatorActionBean bean;
        switch (namedQuery) {
            case GET_COORD_ACTION: {
                bean = (CoordinatorActionBean)ret;
                break;
            }
            case GET_COORD_ACTIONS_BY_LAST_MODIFIED_TIME: {
                bean = new CoordinatorActionBean();
                bean.setJobId((String)ret);
                break;
            }
            case GET_COORD_ACTION_STATUS: {
                bean = new CoordinatorActionBean();
                bean.setStatusStr((String)ret);
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot construct action bean for " + namedQuery.name());
            }
        }
        return bean;
    }

    @Override
    public Object getSingleValue(CoordActionQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        throw new UnsupportedOperationException();
    }

    public static enum CoordActionQuery {
        UPDATE_COORD_ACTION,
        UPDATE_COORD_ACTION_STATUS_PENDING_TIME,
        UPDATE_COORD_ACTION_FOR_INPUTCHECK,
        UPDATE_COORD_ACTION_FOR_PUSH_INPUTCHECK,
        UPDATE_COORD_ACTION_DEPENDENCIES,
        UPDATE_COORD_ACTION_FOR_START,
        UPDATE_COORD_ACTION_FOR_MODIFIED_DATE,
        UPDATE_COORD_ACTION_RERUN,
        GET_COORD_ACTION,
        GET_COORD_ACTION_STATUS,
        GET_COORD_ACTIVE_ACTIONS_COUNT_BY_JOBID,
        GET_COORD_ACTIONS_BY_LAST_MODIFIED_TIME;

    }
}

