/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetActionModifiedDateForRangeJPAExecutor
implements JPAExecutor<Date> {
    private String jobId = null;
    private String startAction;
    private String endAction;

    public CoordJobGetActionModifiedDateForRangeJPAExecutor(String jobId, String startAction, String endAction) {
        ParamChecker.notNull(jobId, "jobId");
        this.jobId = jobId;
        this.startAction = startAction;
        this.endAction = endAction;
    }

    @Override
    public String getName() {
        return "CoordJobGetActionIdsForDateRangeJPAExecutor";
    }

    @Override
    public Date execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_COORD_ACTIONS_MAX_MODIFIED_DATE_FOR_RANGE");
            q.setParameter("jobId", (Object)this.jobId);
            q.setParameter("startAction", (Object)this.startAction);
            q.setParameter("endAction", (Object)this.endAction);
            List coordActionIds = q.getResultList();
            return coordActionIds.isEmpty() ? new Date() : DateUtils.toDate((Timestamp)coordActionIds.get(0));
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }
}

