/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.mongodbinput;

import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mongodbinput.DiscoverFieldsCallback;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputData;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.dialog.ShowMessageDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.PasswordTextVar;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.mongo.MongoDbException;
import org.pentaho.mongo.MongoProperties;
import org.pentaho.mongo.NamedReadPreference;
import org.pentaho.mongo.wrapper.MongoClientWrapper;
import org.pentaho.mongo.wrapper.MongoWrapperUtil;
import org.pentaho.mongo.wrapper.field.MongoField;

public class MongoDbInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = MongoDbInputMeta.class;
    private CTabFolder m_wTabFolder;
    private CTabItem m_wConfigTab;
    private CTabItem m_wInputOptionsTab;
    private CTabItem m_wMongoQueryTab;
    private CTabItem m_wMongoFieldsTab;
    private TextVar wHostname;
    private TextVar wPort;
    private Button m_useAllReplicaSetMembersBut;
    private CCombo wDbName;
    private Button m_getDbsBut;
    private TextVar wFieldsName;
    private CCombo wCollection;
    private Button m_getCollectionsBut;
    private TextVar wJsonField;
    private StyledTextComp wJsonQuery;
    private Label wlJsonQuery;
    private Button m_queryIsPipelineBut;
    private TextVar wAuthUser;
    private TextVar wAuthPass;
    private Button m_kerberosBut;
    private Button m_outputAsJson;
    private TableView m_fieldsView;
    private TextVar m_connectionTimeout;
    private TextVar m_socketTimeout;
    private CCombo m_readPreference;
    private TableView m_tagsView;
    private ColumnInfo[] m_colInf;
    private Button m_executeForEachRowBut;
    private final MongoDbInputMeta input;

    public MongoDbInputDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (MongoDbInputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDbInputDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Text lastControl = this.wStepname;
        this.m_wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.m_wTabFolder, 5);
        this.m_wTabFolder.setSimple(false);
        this.m_wConfigTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wConfigTab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ConfigTab.TabTitle", (String[])new String[0]));
        Composite wConfigComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wConfigComp);
        FormLayout configLayout = new FormLayout();
        configLayout.marginWidth = 3;
        configLayout.marginHeight = 3;
        wConfigComp.setLayout((Layout)configLayout);
        Label wlHostname = new Label(wConfigComp, 131072);
        wlHostname.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Hostname.Label", (String[])new String[0]));
        wlHostname.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Hostname.Label.TipText", (String[])new String[0]));
        this.props.setLook((Control)wlHostname);
        FormData fdlHostname = new FormData();
        fdlHostname.left = new FormAttachment(0, 0);
        fdlHostname.right = new FormAttachment(middle, -margin);
        fdlHostname.top = new FormAttachment(0, margin);
        wlHostname.setLayoutData((Object)fdlHostname);
        this.wHostname = new TextVar((VariableSpace)this.transMeta, wConfigComp, 18436);
        this.props.setLook((Control)this.wHostname);
        this.wHostname.addModifyListener(lsMod);
        FormData fdHostname = new FormData();
        fdHostname.left = new FormAttachment(middle, 0);
        fdHostname.top = new FormAttachment(0, margin);
        fdHostname.right = new FormAttachment(100, 0);
        this.wHostname.setLayoutData((Object)fdHostname);
        lastControl = this.wHostname;
        Label wlPort = new Label(wConfigComp, 131072);
        wlPort.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Port.Label", (String[])new String[0]));
        wlPort.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Port.Label.TipText", (String[])new String[0]));
        this.props.setLook((Control)wlPort);
        FormData fdlPort = new FormData();
        fdlPort.left = new FormAttachment(0, 0);
        fdlPort.right = new FormAttachment(middle, -margin);
        fdlPort.top = new FormAttachment((Control)lastControl, margin);
        wlPort.setLayoutData((Object)fdlPort);
        this.wPort = new TextVar((VariableSpace)this.transMeta, wConfigComp, 18436);
        this.props.setLook((Control)this.wPort);
        this.wPort.addModifyListener(lsMod);
        FormData fdPort = new FormData();
        fdPort.left = new FormAttachment(middle, 0);
        fdPort.top = new FormAttachment((Control)lastControl, margin);
        fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData((Object)fdPort);
        lastControl = this.wPort;
        Label useAllReplicaLab = new Label(wConfigComp, 131072);
        useAllReplicaLab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.UseAllReplicaSetMembers.Label", (String[])new String[0]));
        useAllReplicaLab.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.UseAllReplicaSetMembers.TipText", (String[])new String[0]));
        this.props.setLook((Control)useAllReplicaLab);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)lastControl, margin);
        useAllReplicaLab.setLayoutData((Object)fd);
        this.m_useAllReplicaSetMembersBut = new Button(wConfigComp, 32);
        this.props.setLook((Control)this.m_useAllReplicaSetMembersBut);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)lastControl, margin);
        this.m_useAllReplicaSetMembersBut.setLayoutData((Object)fd);
        lastControl = this.m_useAllReplicaSetMembersBut;
        this.m_useAllReplicaSetMembersBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbInputDialog.this.input.setChanged();
            }
        });
        Label wlAuthUser = new Label(wConfigComp, 131072);
        wlAuthUser.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.AuthenticationUser.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAuthUser);
        FormData fdlAuthUser = new FormData();
        fdlAuthUser.left = new FormAttachment(0, -margin);
        fdlAuthUser.top = new FormAttachment((Control)lastControl, margin);
        fdlAuthUser.right = new FormAttachment(middle, -margin);
        wlAuthUser.setLayoutData((Object)fdlAuthUser);
        this.wAuthUser = new TextVar((VariableSpace)this.transMeta, wConfigComp, 18436);
        this.props.setLook((Control)this.wAuthUser);
        this.wAuthUser.addModifyListener(lsMod);
        FormData fdAuthUser = new FormData();
        fdAuthUser.left = new FormAttachment(middle, 0);
        fdAuthUser.top = new FormAttachment((Control)lastControl, margin);
        fdAuthUser.right = new FormAttachment(100, 0);
        this.wAuthUser.setLayoutData((Object)fdAuthUser);
        lastControl = this.wAuthUser;
        Label wlAuthPass = new Label(wConfigComp, 131072);
        wlAuthPass.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.AuthenticationPassword.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAuthPass);
        FormData fdlAuthPass = new FormData();
        fdlAuthPass.left = new FormAttachment(0, -margin);
        fdlAuthPass.top = new FormAttachment((Control)lastControl, margin);
        fdlAuthPass.right = new FormAttachment(middle, -margin);
        wlAuthPass.setLayoutData((Object)fdlAuthPass);
        this.wAuthPass = new PasswordTextVar((VariableSpace)this.transMeta, wConfigComp, 18436);
        this.props.setLook((Control)this.wAuthPass);
        this.wAuthPass.addModifyListener(lsMod);
        FormData fdAuthPass = new FormData();
        fdAuthPass.left = new FormAttachment(middle, 0);
        fdAuthPass.top = new FormAttachment((Control)this.wAuthUser, margin);
        fdAuthPass.right = new FormAttachment(100, 0);
        this.wAuthPass.setLayoutData((Object)fdAuthPass);
        lastControl = this.wAuthPass;
        Label kerbLab = new Label(wConfigComp, 131072);
        kerbLab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Kerberos.Label", (String[])new String[0]));
        this.props.setLook((Control)kerbLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.wAuthPass, margin);
        fd.right = new FormAttachment(middle, -margin);
        kerbLab.setLayoutData((Object)fd);
        this.m_kerberosBut = new Button(wConfigComp, 32);
        this.props.setLook((Control)this.m_kerberosBut);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.wAuthPass, margin);
        this.m_kerberosBut.setLayoutData((Object)fd);
        this.m_kerberosBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbInputDialog.this.wAuthPass.setEnabled(!MongoDbInputDialog.this.m_kerberosBut.getSelection());
            }
        });
        lastControl = this.m_kerberosBut;
        Label connectTimeoutL = new Label(wConfigComp, 131072);
        connectTimeoutL.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ConnectionTimeout.Label", (String[])new String[0]));
        this.props.setLook((Control)connectTimeoutL);
        connectTimeoutL.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ConnectionTimeout.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, -margin);
        fd.top = new FormAttachment((Control)lastControl, margin);
        fd.right = new FormAttachment(middle, -margin);
        connectTimeoutL.setLayoutData((Object)fd);
        this.m_connectionTimeout = new TextVar((VariableSpace)this.transMeta, wConfigComp, 18436);
        this.props.setLook((Control)this.m_connectionTimeout);
        this.m_connectionTimeout.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)lastControl, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_connectionTimeout.setLayoutData((Object)fd);
        lastControl = this.m_connectionTimeout;
        Label socketTimeoutL = new Label(wConfigComp, 131072);
        socketTimeoutL.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.SocketTimeout.Label", (String[])new String[0]));
        this.props.setLook((Control)connectTimeoutL);
        socketTimeoutL.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.SocketTimeout.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(0, -margin);
        fd.top = new FormAttachment((Control)lastControl, margin);
        fd.right = new FormAttachment(middle, -margin);
        socketTimeoutL.setLayoutData((Object)fd);
        this.m_socketTimeout = new TextVar((VariableSpace)this.transMeta, wConfigComp, 18436);
        this.props.setLook((Control)this.m_socketTimeout);
        this.m_socketTimeout.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)lastControl, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_socketTimeout.setLayoutData((Object)fd);
        lastControl = this.m_socketTimeout;
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wConfigComp.setLayoutData((Object)fd);
        wConfigComp.layout();
        this.m_wConfigTab.setControl((Control)wConfigComp);
        this.m_wInputOptionsTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wInputOptionsTab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.InputOptionsTab.TabTitle", (String[])new String[0]));
        Composite wInputOptionsComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wInputOptionsComp);
        FormLayout inputLayout = new FormLayout();
        inputLayout.marginWidth = 3;
        inputLayout.marginHeight = 3;
        wInputOptionsComp.setLayout((Layout)inputLayout);
        Label wlDbName = new Label(wInputOptionsComp, 131072);
        wlDbName.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.DbName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDbName);
        FormData fdlDbName = new FormData();
        fdlDbName.left = new FormAttachment(0, 0);
        fdlDbName.right = new FormAttachment(middle, -margin);
        fdlDbName.top = new FormAttachment(0, margin);
        wlDbName.setLayoutData((Object)fdlDbName);
        this.m_getDbsBut = new Button(wInputOptionsComp, 0x1000008);
        this.props.setLook((Control)this.m_getDbsBut);
        this.m_getDbsBut.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.DbName.Button", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        this.m_getDbsBut.setLayoutData((Object)fd);
        this.m_getDbsBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbInputDialog.this.setupDBNames();
            }
        });
        this.wDbName = new CCombo(wInputOptionsComp, 2048);
        this.props.setLook((Control)this.wDbName);
        this.wDbName.addModifyListener(lsMod);
        FormData fdDbName = new FormData();
        fdDbName.left = new FormAttachment(middle, 0);
        fdDbName.top = new FormAttachment(0, margin);
        fdDbName.right = new FormAttachment((Control)this.m_getDbsBut, 0);
        this.wDbName.setLayoutData((Object)fdDbName);
        lastControl = this.wDbName;
        this.wDbName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDbInputDialog.this.input.setChanged();
                MongoDbInputDialog.this.wDbName.setToolTipText(MongoDbInputDialog.this.transMeta.environmentSubstitute(MongoDbInputDialog.this.wDbName.getText()));
            }
        });
        Label wlCollection = new Label(wInputOptionsComp, 131072);
        wlCollection.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Collection.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCollection);
        FormData fdlCollection = new FormData();
        fdlCollection.left = new FormAttachment(0, 0);
        fdlCollection.right = new FormAttachment(middle, -margin);
        fdlCollection.top = new FormAttachment((Control)lastControl, margin);
        wlCollection.setLayoutData((Object)fdlCollection);
        this.m_getCollectionsBut = new Button(wInputOptionsComp, 0x1000008);
        this.props.setLook((Control)this.m_getCollectionsBut);
        this.m_getCollectionsBut.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.GetCollections.Button", (String[])new String[0]));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)lastControl, 0);
        this.m_getCollectionsBut.setLayoutData((Object)fd);
        this.m_getCollectionsBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbInputDialog.this.setupCollectionNamesForDB();
            }
        });
        this.wCollection = new CCombo(wInputOptionsComp, 2048);
        this.props.setLook((Control)this.wCollection);
        this.wCollection.addModifyListener(lsMod);
        FormData fdCollection = new FormData();
        fdCollection.left = new FormAttachment(middle, 0);
        fdCollection.top = new FormAttachment((Control)lastControl, margin);
        fdCollection.right = new FormAttachment((Control)this.m_getCollectionsBut, 0);
        this.wCollection.setLayoutData((Object)fdCollection);
        lastControl = this.wCollection;
        this.wCollection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbInputDialog.this.updateQueryTitleInfo();
            }
        });
        this.wCollection.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                MongoDbInputDialog.this.updateQueryTitleInfo();
            }
        });
        Label readPrefL = new Label(wInputOptionsComp, 131072);
        readPrefL.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ReadPreferenceLabel", (String[])new String[0]));
        this.props.setLook((Control)readPrefL);
        fd = new FormData();
        fd.left = new FormAttachment(0, -margin);
        fd.top = new FormAttachment((Control)lastControl, margin);
        fd.right = new FormAttachment(middle, -margin);
        readPrefL.setLayoutData((Object)fd);
        this.m_readPreference = new CCombo(wInputOptionsComp, 2048);
        this.props.setLook((Control)this.m_readPreference);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)lastControl, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_readPreference.setLayoutData((Object)fd);
        this.m_readPreference.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MongoDbInputDialog.this.input.setChanged();
                MongoDbInputDialog.this.m_readPreference.setToolTipText(MongoDbInputDialog.this.transMeta.environmentSubstitute(MongoDbInputDialog.this.m_readPreference.getText()));
            }
        });
        for (NamedReadPreference preference : NamedReadPreference.values()) {
            this.m_readPreference.add(preference.getName());
        }
        lastControl = this.m_readPreference;
        Button testUserTagsBut = new Button(wInputOptionsComp, 0x1000008);
        this.props.setLook((Control)testUserTagsBut);
        testUserTagsBut.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.TestUserTags.Button", (String[])new String[0]));
        testUserTagsBut.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.TestUserTags.Button.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.right = new FormAttachment(100, 0);
        testUserTagsBut.setLayoutData((Object)fd);
        testUserTagsBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbInputDialog.this.testUserSpecifiedTagSetsAgainstReplicaSet();
            }
        });
        Button joinTagsBut = new Button(wInputOptionsComp, 0x1000008);
        this.props.setLook((Control)joinTagsBut);
        joinTagsBut.setText("Join tags");
        joinTagsBut.setToolTipText("Join tags");
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.right = new FormAttachment((Control)testUserTagsBut, margin);
        joinTagsBut.setLayoutData((Object)fd);
        joinTagsBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbInputDialog.this.concatenateTags();
            }
        });
        Button getTagsBut = new Button(wInputOptionsComp, 0x1000008);
        this.props.setLook((Control)getTagsBut);
        getTagsBut.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.GetTags.Button", (String[])new String[0]));
        getTagsBut.setToolTipText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.GetTags.Button.TipText", (String[])new String[0]));
        fd = new FormData();
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.right = new FormAttachment((Control)joinTagsBut, margin);
        getTagsBut.setLayoutData((Object)fd);
        getTagsBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbInputDialog.this.setupTagSetComboValues();
            }
        });
        this.m_colInf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.TagSets.TagSetColumnTitle", (String[])new String[0]), 1, false)};
        this.m_colInf[0].setReadOnly(false);
        Label tagSetsTitle = new Label(wInputOptionsComp, 16384);
        tagSetsTitle.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.TagSets.Title", (String[])new String[0]));
        this.props.setLook((Control)tagSetsTitle);
        fd = new FormData();
        fd.left = new FormAttachment(0, -margin);
        fd.top = new FormAttachment((Control)lastControl, margin);
        fd.right = new FormAttachment(middle, -margin);
        tagSetsTitle.setLayoutData((Object)fd);
        lastControl = tagSetsTitle;
        this.m_tagsView = new TableView((VariableSpace)this.transMeta, wInputOptionsComp, 65538, this.m_colInf, 1, lsMod, this.props);
        fd = new FormData();
        fd.top = new FormAttachment((Control)lastControl, margin * 2);
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.m_tagsView.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wInputOptionsComp.setLayoutData((Object)fd);
        wInputOptionsComp.layout();
        this.m_wInputOptionsTab.setControl((Control)wInputOptionsComp);
        this.m_wMongoQueryTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wMongoQueryTab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.QueryTab.TabTitle", (String[])new String[0]));
        Composite wQueryComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wQueryComp);
        FormLayout queryLayout = new FormLayout();
        queryLayout.marginWidth = 3;
        queryLayout.marginHeight = 3;
        wQueryComp.setLayout((Layout)queryLayout);
        Label wlFieldsName = new Label(wQueryComp, 131072);
        wlFieldsName.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.FieldsName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFieldsName);
        FormData fdlFieldsName = new FormData();
        fdlFieldsName.left = new FormAttachment(0, 0);
        fdlFieldsName.right = new FormAttachment(middle, -margin);
        fdlFieldsName.bottom = new FormAttachment(100, -margin);
        wlFieldsName.setLayoutData((Object)fdlFieldsName);
        this.wFieldsName = new TextVar((VariableSpace)this.transMeta, wQueryComp, 18436);
        this.props.setLook((Control)this.wFieldsName);
        this.wFieldsName.addModifyListener(lsMod);
        FormData fdFieldsName = new FormData();
        fdFieldsName.left = new FormAttachment(middle, 0);
        fdFieldsName.bottom = new FormAttachment(100, -margin);
        fdFieldsName.right = new FormAttachment(100, 0);
        this.wFieldsName.setLayoutData((Object)fdFieldsName);
        lastControl = this.wFieldsName;
        Label executeForEachRLab = new Label(wQueryComp, 131072);
        executeForEachRLab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ExecuteForEachRow.Label", (String[])new String[0]));
        this.props.setLook((Control)executeForEachRLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, -margin);
        fd.bottom = new FormAttachment((Control)lastControl, -margin);
        fd.right = new FormAttachment(middle, -margin);
        executeForEachRLab.setLayoutData((Object)fd);
        this.m_executeForEachRowBut = new Button(wQueryComp, 32);
        this.props.setLook((Control)this.m_executeForEachRowBut);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)lastControl, -margin);
        this.m_executeForEachRowBut.setLayoutData((Object)fd);
        lastControl = this.m_executeForEachRowBut;
        Label queryIsPipelineL = new Label(wQueryComp, 131072);
        queryIsPipelineL.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Pipeline.Label", (String[])new String[0]));
        this.props.setLook((Control)queryIsPipelineL);
        fd = new FormData();
        fd.bottom = new FormAttachment((Control)lastControl, -margin);
        fd.left = new FormAttachment(0, -margin);
        fd.right = new FormAttachment(middle, -margin);
        queryIsPipelineL.setLayoutData((Object)fd);
        this.m_queryIsPipelineBut = new Button(wQueryComp, 32);
        this.props.setLook((Control)this.m_queryIsPipelineBut);
        fd = new FormData();
        fd.bottom = new FormAttachment((Control)lastControl, -margin);
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        this.m_queryIsPipelineBut.setLayoutData((Object)fd);
        lastControl = this.m_queryIsPipelineBut;
        this.m_queryIsPipelineBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbInputDialog.this.updateQueryTitleInfo();
            }
        });
        this.wlJsonQuery = new Label(wQueryComp, 0);
        this.wlJsonQuery.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.JsonQuery.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlJsonQuery);
        FormData fdlJsonQuery = new FormData();
        fdlJsonQuery.left = new FormAttachment(0, 0);
        fdlJsonQuery.right = new FormAttachment(100, -margin);
        fdlJsonQuery.top = new FormAttachment(0, margin);
        this.wlJsonQuery.setLayoutData((Object)fdlJsonQuery);
        this.wJsonQuery = new StyledTextComp((VariableSpace)this.transMeta, wQueryComp, 19202, "");
        this.props.setLook((Control)this.wJsonQuery, 1);
        this.wJsonQuery.addModifyListener(lsMod);
        FormData fdJsonQuery = new FormData();
        fdJsonQuery.left = new FormAttachment(0, 0);
        fdJsonQuery.top = new FormAttachment((Control)this.wlJsonQuery, margin);
        fdJsonQuery.right = new FormAttachment(100, -2 * margin);
        fdJsonQuery.bottom = new FormAttachment((Control)lastControl, -margin);
        this.wJsonQuery.setLayoutData((Object)fdJsonQuery);
        lastControl = this.wJsonQuery;
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wQueryComp.setLayoutData((Object)fd);
        wQueryComp.layout();
        this.m_wMongoQueryTab.setControl((Control)wQueryComp);
        this.m_wMongoFieldsTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wMongoFieldsTab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        wFieldsComp.setLayout((Layout)fieldsLayout);
        Label outputJLab = new Label(wFieldsComp, 131072);
        outputJLab.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.OutputJson.Label", (String[])new String[0]));
        this.props.setLook((Control)outputJLab);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        outputJLab.setLayoutData((Object)fd);
        this.m_outputAsJson = new Button(wFieldsComp, 32);
        this.props.setLook((Control)this.m_outputAsJson);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        this.m_outputAsJson.setLayoutData((Object)fd);
        lastControl = this.m_outputAsJson;
        this.m_outputAsJson.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbInputDialog.this.input.setChanged();
                MongoDbInputDialog.this.wGet.setEnabled(!MongoDbInputDialog.this.m_outputAsJson.getSelection());
                MongoDbInputDialog.this.wJsonField.setEnabled(MongoDbInputDialog.this.m_outputAsJson.getSelection());
            }
        });
        Label wlJsonField = new Label(wFieldsComp, 131072);
        wlJsonField.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.JsonField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlJsonField);
        FormData fdlJsonField = new FormData();
        fdlJsonField.left = new FormAttachment(0, 0);
        fdlJsonField.right = new FormAttachment(middle, -margin);
        fdlJsonField.top = new FormAttachment((Control)lastControl, margin);
        wlJsonField.setLayoutData((Object)fdlJsonField);
        this.wJsonField = new TextVar((VariableSpace)this.transMeta, wFieldsComp, 18436);
        this.props.setLook((Control)this.wJsonField);
        this.wJsonField.addModifyListener(lsMod);
        FormData fdJsonField = new FormData();
        fdJsonField.left = new FormAttachment(middle, 0);
        fdJsonField.top = new FormAttachment((Control)lastControl, margin);
        fdJsonField.right = new FormAttachment(100, 0);
        this.wJsonField.setLayoutData((Object)fdJsonField);
        lastControl = this.wJsonField;
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Button.GetFields", (String[])new String[0]));
        this.props.setLook((Control)this.wGet);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)fd);
        this.wGet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MongoDbInputMeta newMeta = (MongoDbInputMeta)((Object)MongoDbInputDialog.this.input.clone());
                MongoDbInputDialog.this.getFields(newMeta);
            }
        });
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.FIELD_NAME", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.FIELD_PATH", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.FIELD_TYPE", (String[])new String[0]), 2, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.FIELD_INDEXED", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.SAMPLE_ARRAYINFO", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.SAMPLE_PERCENTAGE", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Fields.SAMPLE_DISPARATE_TYPES", (String[])new String[0]), 1, false)};
        colinf[2].setComboValues(ValueMeta.getTypes());
        colinf[4].setReadOnly(true);
        colinf[5].setReadOnly(true);
        colinf[6].setReadOnly(true);
        this.m_fieldsView = new TableView((VariableSpace)this.transMeta, wFieldsComp, 65538, colinf, 1, lsMod, this.props);
        fd = new FormData();
        fd.top = new FormAttachment((Control)lastControl, margin * 2);
        fd.bottom = new FormAttachment((Control)this.wGet, -margin * 2);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.m_fieldsView.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fd);
        wFieldsComp.layout();
        this.m_wMongoFieldsTab.setControl((Control)wFieldsComp);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.wStepname, margin);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, -50);
        this.m_wTabFolder.setLayoutData((Object)fd);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, (Control)this.m_wTabFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                MongoDbInputDialog.this.cancel();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                MongoDbInputDialog.this.preview();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                MongoDbInputDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wPreview.addListener(13, this.lsPreview);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MongoDbInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wHostname.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MongoDbInputDialog.this.cancel();
            }
        });
        this.getData(this.input);
        this.input.setChanged(this.changed);
        this.m_wTabFolder.setSelection(0);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData(MongoDbInputMeta meta) {
        this.wHostname.setText(Const.NVL((String)meta.getHostnames(), (String)""));
        this.wPort.setText(Const.NVL((String)meta.getPort(), (String)""));
        this.m_useAllReplicaSetMembersBut.setSelection(meta.getUseAllReplicaSetMembers());
        this.wDbName.setText(Const.NVL((String)meta.getDbName(), (String)""));
        this.wFieldsName.setText(Const.NVL((String)meta.getFieldsName(), (String)""));
        this.wCollection.setText(Const.NVL((String)meta.getCollection(), (String)""));
        this.wJsonField.setText(Const.NVL((String)meta.getJsonFieldName(), (String)""));
        this.wJsonQuery.setText(Const.NVL((String)meta.getJsonQuery(), (String)""));
        this.wAuthUser.setText(Const.NVL((String)meta.getAuthenticationUser(), (String)""));
        this.wAuthPass.setText(Const.NVL((String)meta.getAuthenticationPassword(), (String)""));
        this.m_kerberosBut.setSelection(meta.getUseKerberosAuthentication());
        this.wAuthPass.setEnabled(!this.m_kerberosBut.getSelection());
        this.m_connectionTimeout.setText(Const.NVL((String)meta.getConnectTimeout(), (String)""));
        this.m_socketTimeout.setText(Const.NVL((String)meta.getSocketTimeout(), (String)""));
        this.m_readPreference.setText(Const.NVL((String)meta.getReadPreference(), (String)""));
        this.m_queryIsPipelineBut.setSelection(meta.getQueryIsPipeline());
        this.m_outputAsJson.setSelection(meta.getOutputJson());
        this.m_executeForEachRowBut.setSelection(meta.getExecuteForEachIncomingRow());
        this.setFieldTableFields(meta.getMongoFields());
        this.setTagsTableFields(meta.getReadPrefTagSets());
        this.wJsonField.setEnabled(meta.getOutputJson());
        this.wGet.setEnabled(!meta.getOutputJson());
        this.updateQueryTitleInfo();
        this.wStepname.selectAll();
    }

    private void updateQueryTitleInfo() {
        if (this.m_queryIsPipelineBut.getSelection()) {
            this.wlJsonQuery.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.JsonQuery.Label2", (String[])new String[0]) + ": db." + Const.NVL((String)this.wCollection.getText(), (String)"n/a") + ".aggregate(...");
            this.wFieldsName.setEnabled(false);
        } else {
            this.wlJsonQuery.setText(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.JsonQuery.Label", (String[])new String[0]));
            this.wFieldsName.setEnabled(true);
        }
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(MongoDbInputMeta meta) {
        TableItem item;
        int i;
        meta.setHostnames(this.wHostname.getText());
        meta.setPort(this.wPort.getText());
        meta.setUseAllReplicaSetMembers(this.m_useAllReplicaSetMembersBut.getSelection());
        meta.setDbName(this.wDbName.getText());
        meta.setFieldsName(this.wFieldsName.getText());
        meta.setCollection(this.wCollection.getText());
        meta.setJsonFieldName(this.wJsonField.getText());
        meta.setJsonQuery(this.wJsonQuery.getText());
        meta.setAuthenticationUser(this.wAuthUser.getText());
        meta.setAuthenticationPassword(this.wAuthPass.getText());
        meta.setUseKerberosAuthentication(this.m_kerberosBut.getSelection());
        meta.setConnectTimeout(this.m_connectionTimeout.getText());
        meta.setSocketTimeout(this.m_socketTimeout.getText());
        meta.setReadPreference(this.m_readPreference.getText());
        meta.setOutputJson(this.m_outputAsJson.getSelection());
        meta.setQueryIsPipeline(this.m_queryIsPipelineBut.getSelection());
        meta.setExecuteForEachIncomingRow(this.m_executeForEachRowBut.getSelection());
        int numNonEmpty = this.m_fieldsView.nrNonEmpty();
        if (numNonEmpty > 0) {
            ArrayList<MongoField> outputFields = new ArrayList<MongoField>();
            for (i = 0; i < numNonEmpty; ++i) {
                item = this.m_fieldsView.getNonEmpty(i);
                MongoField newField = new MongoField();
                newField.m_fieldName = item.getText(1).trim();
                newField.m_fieldPath = item.getText(2).trim();
                newField.m_kettleType = item.getText(3).trim();
                if (!Const.isEmpty((String)item.getText(4))) {
                    newField.m_indexedVals = MongoDbInputData.indexedValsList(item.getText(4).trim());
                }
                outputFields.add(newField);
            }
            meta.setMongoFields(outputFields);
        }
        numNonEmpty = this.m_tagsView.nrNonEmpty();
        ArrayList<String> tags = new ArrayList<String>();
        if (numNonEmpty > 0) {
            for (i = 0; i < numNonEmpty; ++i) {
                item = this.m_tagsView.getNonEmpty(i);
                String t = item.getText(1).trim();
                if (!t.startsWith("{")) {
                    t = "{" + t;
                }
                if (!t.endsWith("}")) {
                    t = t + "}";
                }
                tags.add(t);
            }
        }
        meta.setReadPrefTagSets(tags);
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    public boolean isTableDisposed() {
        return this.m_fieldsView.isDisposed();
    }

    private void setTagsTableFields(List<String> tags) {
        if (tags == null) {
            return;
        }
        this.m_tagsView.clearAll();
        for (String t : tags) {
            TableItem item = new TableItem(this.m_tagsView.table, 0);
            item.setText(1, t);
        }
        this.m_tagsView.removeEmptyRows();
        this.m_tagsView.setRowNums();
        this.m_tagsView.optWidth(true);
    }

    private void setFieldTableFields(List<MongoField> fields) {
        if (fields == null) {
            return;
        }
        this.m_fieldsView.clearAll();
        for (MongoField f : fields) {
            TableItem item = new TableItem(this.m_fieldsView.table, 0);
            this.updateTableItem(item, f);
        }
        this.m_fieldsView.removeEmptyRows();
        this.m_fieldsView.setRowNums();
        this.m_fieldsView.optWidth(true);
    }

    public void updateFieldTableFields(List<MongoField> fields) {
        HashMap<String, MongoField> fieldMap = new HashMap<String, MongoField>(fields.size());
        for (MongoField field : fields) {
            fieldMap.put(field.m_fieldName, field);
        }
        int index = 0;
        ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
        for (TableItem tableItem : this.m_fieldsView.getTable().getItems()) {
            String name = tableItem.getText(1);
            MongoField mongoField = (MongoField)fieldMap.remove(name);
            if (mongoField == null) {
                indicesToRemove.add(index);
            } else {
                this.updateTableItem(tableItem, mongoField);
            }
            ++index;
        }
        int[] indicesArray = new int[indicesToRemove.size()];
        for (int i = 0; i < indicesArray.length; ++i) {
            indicesArray[i] = (Integer)indicesToRemove.get(i);
        }
        for (MongoField mongoField : fieldMap.values()) {
            TableItem item = new TableItem(this.m_fieldsView.table, 0);
            this.updateTableItem(item, mongoField);
        }
        this.m_fieldsView.setRowNums();
        this.m_fieldsView.remove(indicesArray);
        this.m_fieldsView.removeEmptyRows();
        this.m_fieldsView.setRowNums();
        this.m_fieldsView.optWidth(true);
    }

    private void updateTableItem(TableItem tableItem, MongoField mongoField) {
        if (!Const.isEmpty((String)mongoField.m_fieldName)) {
            tableItem.setText(1, mongoField.m_fieldName);
        }
        if (!Const.isEmpty((String)mongoField.m_fieldPath)) {
            tableItem.setText(2, mongoField.m_fieldPath);
        }
        if (!Const.isEmpty((String)mongoField.m_kettleType)) {
            tableItem.setText(3, mongoField.m_kettleType);
        }
        if (mongoField.m_indexedVals != null && mongoField.m_indexedVals.size() > 0) {
            tableItem.setText(4, MongoDbInputData.indexedValsList(mongoField.m_indexedVals));
        }
        if (!Const.isEmpty((String)mongoField.m_arrayIndexInfo)) {
            tableItem.setText(5, mongoField.m_arrayIndexInfo);
        }
        if (!Const.isEmpty((String)mongoField.m_occurenceFraction)) {
            tableItem.setText(6, mongoField.m_occurenceFraction);
        }
        if (mongoField.m_disparateTypes) {
            tableItem.setText(7, "Y");
        }
    }

    private boolean checkForUnresolved(MongoDbInputMeta meta, String title) {
        boolean notOk;
        String query = this.transMeta.environmentSubstitute(meta.getJsonQuery());
        boolean bl = notOk = query.contains("${") || query.contains("?{");
        if (notOk) {
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, title, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Warning.Message.MongoQueryContainsUnresolvedVarsFieldSubs", (String[])new String[0]));
            smd.open();
        }
        return !notOk;
    }

    public void handleNotificationException(Exception exception) {
        new ErrorDialog(this.shell, this.stepname, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.ErrorDuringSampling", (String[])new String[0]), exception);
    }

    private void getFields(MongoDbInputMeta meta) {
        if (!(Const.isEmpty((String)this.wHostname.getText()) || Const.isEmpty((String)this.wDbName.getText()) || Const.isEmpty((String)this.wCollection.getText()))) {
            EnterNumberDialog end = new EnterNumberDialog(this.shell, 100, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.SampleDocuments.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.SampleDocuments.Message", (String[])new String[0]));
            int samples = end.open();
            if (samples > 0) {
                this.getInfo(meta);
                boolean current = meta.getExecuteForEachIncomingRow();
                meta.setExecuteForEachIncomingRow(false);
                if (!this.checkForUnresolved(meta, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Warning.Message.MongoQueryContainsUnresolvedVarsFieldSubs.SamplingTitle", (String[])new String[0]))) {
                    return;
                }
                try {
                    MongoDbInputDialog.discoverFields(meta, (VariableSpace)this.transMeta, samples, this);
                    meta.setExecuteForEachIncomingRow(current);
                }
                catch (KettleException e) {
                    new ErrorDialog(this.shell, this.stepname, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.ErrorDuringSampling", (String[])new String[0]), (Exception)((Object)e));
                }
            }
        } else {
            String missingConDetails = "";
            if (Const.isEmpty((String)this.wHostname.getText())) {
                missingConDetails = missingConDetails + " host name(s)";
            }
            if (Const.isEmpty((String)this.wDbName.getText())) {
                missingConDetails = missingConDetails + " database";
            }
            if (Const.isEmpty((String)this.wCollection.getText())) {
                missingConDetails = missingConDetails + " collection";
            }
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails", (String[])new String[]{missingConDetails}));
            smd.open();
        }
    }

    private void preview() {
        MongoDbInputMeta oneMeta = new MongoDbInputMeta();
        this.getInfo(oneMeta);
        oneMeta.setExecuteForEachIncomingRow(false);
        if (!this.checkForUnresolved(oneMeta, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Warning.Message.MongoQueryContainsUnresolvedVarsFieldSubs.PreviewTitle", (String[])new String[0]))) {
            return;
        }
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDBNames() {
        String current = this.wDbName.getText();
        this.wDbName.removeAll();
        String hostname = this.transMeta.environmentSubstitute(this.wHostname.getText());
        if (!Const.isEmpty((String)hostname)) {
            MongoDbInputMeta meta = new MongoDbInputMeta();
            this.getInfo(meta);
            try {
                MongoClientWrapper wrapper = MongoWrapperUtil.createMongoClientWrapper(meta, (VariableSpace)this.transMeta, (LogChannelInterface)this.log);
                List<Object> dbNames = new ArrayList();
                try {
                    dbNames = wrapper.getDatabaseNames();
                }
                finally {
                    wrapper.dispose();
                }
                for (String string : dbNames) {
                    this.wDbName.add(string);
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), e);
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), e);
            }
        } else {
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails", (String[])new String[]{"host name(s)"}));
            smd.open();
        }
        if (!Const.isEmpty((String)current)) {
            this.wDbName.setText(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupCollectionNamesForDB() {
        String hostname = this.transMeta.environmentSubstitute(this.wHostname.getText());
        String dB = this.transMeta.environmentSubstitute(this.wDbName.getText());
        String current = this.wCollection.getText();
        this.wCollection.removeAll();
        if (!Const.isEmpty((String)hostname) && !Const.isEmpty((String)dB)) {
            MongoDbInputMeta meta = new MongoDbInputMeta();
            this.getInfo(meta);
            try {
                MongoClientWrapper wrapper = MongoWrapperUtil.createMongoClientWrapper(meta, (VariableSpace)this.transMeta, (LogChannelInterface)this.log);
                Set<Object> collections = new HashSet();
                try {
                    collections = wrapper.getCollectionsNames(dB);
                }
                finally {
                    wrapper.dispose();
                }
                for (String string : collections) {
                    this.wCollection.add(string);
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), e);
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), e);
            }
        } else {
            String missingConnDetails = "";
            if (Const.isEmpty((String)hostname)) {
                missingConnDetails = missingConnDetails + "host name(s)";
            }
            if (Const.isEmpty((String)dB)) {
                missingConnDetails = missingConnDetails + " database";
            }
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails", (String[])new String[]{missingConnDetails}));
            smd.open();
        }
        if (!Const.isEmpty((String)current)) {
            this.wCollection.setText(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupTagSetComboValues() {
        block9: {
            String hostname = this.transMeta.environmentSubstitute(this.wHostname.getText());
            if (!Const.isEmpty((String)hostname)) {
                MongoDbInputMeta meta = new MongoDbInputMeta();
                this.getInfo(meta);
                try {
                    MongoClientWrapper wrapper = MongoWrapperUtil.createMongoClientWrapper(meta, (VariableSpace)this.transMeta, (LogChannelInterface)this.log);
                    List<Object> repSetTags = new ArrayList();
                    try {
                        repSetTags = wrapper.getAllTags();
                    }
                    finally {
                        wrapper.dispose();
                    }
                    if (repSetTags.size() == 0) {
                        ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Info.Message.NoTagSetsDefinedOnServer", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Info.Message.NoTagSetsDefinedOnServer", (String[])new String[0]));
                        smd.open();
                        break block9;
                    }
                    this.setTagsTableFields(repSetTags);
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), e);
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), e);
                }
            } else {
                ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.MissingConnectionDetails", (String[])new String[]{"host name(s)"}));
                smd.open();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUserSpecifiedTagSetsAgainstReplicaSet() {
        block25: {
            if (this.m_tagsView.nrNonEmpty() > 0) {
                ArrayList<DBObject> tagSets = new ArrayList<DBObject>();
                for (int i = 0; i < this.m_tagsView.nrNonEmpty(); ++i) {
                    DBObject setO;
                    TableItem item = this.m_tagsView.getNonEmpty(i);
                    String set = item.getText(1).trim();
                    if (!set.startsWith("{")) {
                        set = "{" + set;
                    }
                    if (!set.endsWith("}")) {
                        set = set + "}";
                    }
                    if ((setO = (DBObject)JSON.parse((String)set)) == null) continue;
                    tagSets.add(setO);
                }
                if (tagSets.size() > 0) {
                    String hostname = this.transMeta.environmentSubstitute(this.wHostname.getText());
                    try {
                        if (!Const.isEmpty((String)hostname)) {
                            MongoDbInputMeta meta = new MongoDbInputMeta();
                            this.getInfo(meta);
                            MongoClientWrapper wrapper = null;
                            try {
                                wrapper = MongoWrapperUtil.createMongoClientWrapper(meta, (VariableSpace)this.transMeta, (LogChannelInterface)this.log);
                            }
                            catch (MongoDbException e) {
                                throw new KettleException((Throwable)e);
                            }
                            List<Object> satisfy = new ArrayList();
                            try {
                                try {
                                    satisfy = wrapper.getReplicaSetMembersThatSatisfyTagSets(tagSets);
                                }
                                catch (MongoDbException e) {
                                    throw new KettleException((Throwable)e);
                                }
                            }
                            finally {
                                try {
                                    wrapper.dispose();
                                }
                                catch (MongoDbException e) {}
                            }
                            if (satisfy.size() == 0) {
                                this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Info.Message.NoReplicaSetMembersMatchTagSets", (String[])new String[0]));
                                ShowMessageDialog smd = new ShowMessageDialog(this.shell, 34, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Info.Message.NoReplicaSetMembersMatchTagSets.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Info.Message.NoReplicaSetMembersMatchTagSets", (String[])new String[0]));
                                smd.open();
                            } else {
                                StringBuilder builder = new StringBuilder();
                                builder.append("\n");
                                for (int i = 0; i < satisfy.size(); ++i) {
                                    builder.append((String)satisfy.get(i)).append("\n");
                                }
                                ShowMessageDialog smd = new ShowMessageDialog(this.shell, 34, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.Info.Message.MatchingReplicaSetMembers.Title", (String[])new String[0]), builder.toString());
                                smd.open();
                            }
                            break block25;
                        }
                        ShowMessageDialog smd = new ShowMessageDialog(this.shell, 33, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.NoConnectionDetailsSupplied.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.NoConnectionDetailsSupplied", (String[])new String[0]));
                        smd.open();
                    }
                    catch (KettleException ex) {
                        this.logError(BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), ex);
                        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.UnableToConnect", (String[])new String[0]), (Exception)((Object)ex));
                    }
                } else {
                    ShowMessageDialog smd = new ShowMessageDialog(this.shell, 33, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.NoParseableTagSets.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.NoParseableTagSets", (String[])new String[0]));
                    smd.open();
                }
            } else {
                ShowMessageDialog smd = new ShowMessageDialog(this.shell, 33, BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.NoTagSetsDefined.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MongoDbInputDialog.ErrorMessage.NoTagSetsDefined", (String[])new String[0]));
                smd.open();
            }
        }
    }

    private void concatenateTags() {
        int[] selectedTags = this.m_tagsView.getSelectionIndices();
        String concatenated = "";
        for (int i : selectedTags) {
            TableItem item = this.m_tagsView.table.getItem(i);
            String t = item.getText(1).trim();
            concatenated = concatenated + (concatenated.length() > 0 ? (!concatenated.endsWith(",") ? ", " : "") : "") + t;
        }
        TableItem item = new TableItem(this.m_tagsView.table, 0);
        item.setText(1, concatenated);
    }

    public static void discoverFields(final MongoDbInputMeta meta, VariableSpace vars, int docsToSample, final MongoDbInputDialog mongoDialog) throws KettleException {
        MongoProperties.Builder propertiesBuilder = MongoWrapperUtil.createPropertiesBuilder(meta, vars);
        String db = vars.environmentSubstitute(meta.getDbName());
        String collection = vars.environmentSubstitute(meta.getCollection());
        String query = vars.environmentSubstitute(meta.getJsonQuery());
        String fields = vars.environmentSubstitute(meta.getFieldsName());
        int numDocsToSample = docsToSample;
        if (numDocsToSample < 1) {
            numDocsToSample = 100;
        }
        try {
            MongoDbInputData.getMongoDbInputDiscoverFieldsHolder().getMongoDbInputDiscoverFields().discoverFields(propertiesBuilder, db, collection, query, fields, meta.getQueryIsPipeline(), numDocsToSample, meta, new DiscoverFieldsCallback(){

                @Override
                public void notifyFields(final List<MongoField> fields) {
                    if (fields.size() > 0) {
                        Spoon.getInstance().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!mongoDialog.isTableDisposed()) {
                                    meta.setMongoFields(fields);
                                    mongoDialog.updateFieldTableFields(meta.getMongoFields());
                                }
                            }
                        });
                    }
                }

                @Override
                public void notifyException(Exception exception) {
                    mongoDialog.handleNotificationException(exception);
                }
            });
        }
        catch (KettleException e) {
            throw new KettleException("Unable to discover fields from MongoDB", (Throwable)e);
        }
    }

    public static boolean discoverFields(MongoDbInputMeta meta, VariableSpace vars, int docsToSample) throws KettleException {
        MongoProperties.Builder propertiesBuilder = MongoWrapperUtil.createPropertiesBuilder(meta, vars);
        try {
            List<MongoField> discoveredFields;
            String db = vars.environmentSubstitute(meta.getDbName());
            String collection = vars.environmentSubstitute(meta.getCollection());
            String query = vars.environmentSubstitute(meta.getJsonQuery());
            String fields = vars.environmentSubstitute(meta.getFieldsName());
            int numDocsToSample = docsToSample;
            if (numDocsToSample < 1) {
                numDocsToSample = 100;
            }
            if ((discoveredFields = MongoDbInputData.getMongoDbInputDiscoverFieldsHolder().getMongoDbInputDiscoverFields().discoverFields(propertiesBuilder, db, collection, query, fields, meta.getQueryIsPipeline(), numDocsToSample, meta)).size() > 0) {
                meta.setMongoFields(discoveredFields);
                return true;
            }
        }
        catch (Exception e) {
            if (e instanceof KettleException) {
                throw (KettleException)((Object)e);
            }
            throw new KettleException("Unable to discover fields from MongoDB", (Throwable)e);
        }
        return false;
    }
}

