/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper;

import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.steps.mongodb.MongoDbMeta;
import org.pentaho.mongo.MongoDbException;
import org.pentaho.mongo.MongoProp;
import org.pentaho.mongo.MongoProperties;
import org.pentaho.mongo.MongoUtilLogger;
import org.pentaho.mongo.wrapper.KettleMongoUtilLogger;
import org.pentaho.mongo.wrapper.MongoClientWrapper;
import org.pentaho.mongo.wrapper.MongoClientWrapperFactory;
import org.pentaho.mongo.wrapper.MongoWrapperClientFactory;

public class MongoWrapperUtil {
    private static MongoWrapperClientFactory mongoWrapperClientFactory = new MongoWrapperClientFactory(){

        @Override
        public MongoClientWrapper createMongoClientWrapper(MongoProperties props, MongoUtilLogger log) throws MongoDbException {
            return MongoClientWrapperFactory.createMongoClientWrapper(props, log);
        }
    };

    public static void setMongoWrapperClientFactory(MongoWrapperClientFactory mongoWrapperClientFactory) {
        MongoWrapperUtil.mongoWrapperClientFactory = mongoWrapperClientFactory;
    }

    protected static MongoWrapperClientFactory getMongoWrapperClientFactory() {
        return mongoWrapperClientFactory;
    }

    public static MongoClientWrapper createMongoClientWrapper(MongoDbMeta mongoDbMeta, VariableSpace vars, LogChannelInterface log) throws MongoDbException {
        MongoProperties.Builder propertiesBuilder = MongoWrapperUtil.createPropertiesBuilder(mongoDbMeta, vars);
        return mongoWrapperClientFactory.createMongoClientWrapper(propertiesBuilder.build(), new KettleMongoUtilLogger(log));
    }

    public static MongoProperties.Builder createPropertiesBuilder(MongoDbMeta mongoDbMeta, VariableSpace vars) {
        MongoProperties.Builder propertiesBuilder = new MongoProperties.Builder();
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.HOST, vars.environmentSubstitute(mongoDbMeta.getHostnames()));
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.PORT, vars.environmentSubstitute(mongoDbMeta.getPort()));
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.DBNAME, vars.environmentSubstitute(mongoDbMeta.getDbName()));
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.connectTimeout, mongoDbMeta.getConnectTimeout());
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.socketTimeout, mongoDbMeta.getSocketTimeout());
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.readPreference, mongoDbMeta.getReadPreference());
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.writeConcern, mongoDbMeta.getWriteConcern());
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.wTimeout, mongoDbMeta.getWTimeout());
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.JOURNALED, Boolean.toString(mongoDbMeta.getJournal()));
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.USE_ALL_REPLICA_SET_MEMBERS, Boolean.toString(mongoDbMeta.getUseAllReplicaSetMembers()));
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.USERNAME, vars.environmentSubstitute(mongoDbMeta.getAuthenticationUser()));
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.PASSWORD, vars.environmentSubstitute(mongoDbMeta.getAuthenticationPassword()));
        MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.USE_KERBEROS, Boolean.toString(mongoDbMeta.getUseKerberosAuthentication()));
        if (mongoDbMeta.getReadPrefTagSets() != null) {
            StringBuilder tagSet = new StringBuilder();
            for (String tag : mongoDbMeta.getReadPrefTagSets()) {
                tagSet.append(tag);
                tagSet.append(",");
            }
            if (tagSet.length() > 0) {
                tagSet.setLength(tagSet.length() - 1);
            }
            MongoWrapperUtil.setIfNotNullOrEmpty(propertiesBuilder, MongoProp.tagSet, tagSet.toString());
        }
        return propertiesBuilder;
    }

    public static MongoClientWrapper createMongoClientWrapper(MongoProperties.Builder properties, LogChannelInterface log) throws MongoDbException {
        return mongoWrapperClientFactory.createMongoClientWrapper(properties.build(), new KettleMongoUtilLogger(log));
    }

    private static void setIfNotNullOrEmpty(MongoProperties.Builder builder, MongoProp prop, String value) {
        if (value != null && value.trim().length() > 0) {
            builder.set(prop, value);
        }
    }
}

