/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper.field;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.mongodbinput.DiscoverFieldsCallback;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputDiscoverFields;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;
import org.pentaho.mongo.MongoDbException;
import org.pentaho.mongo.MongoProperties;
import org.pentaho.mongo.wrapper.MongoClientWrapper;
import org.pentaho.mongo.wrapper.MongoDBAction;
import org.pentaho.mongo.wrapper.MongoWrapperUtil;
import org.pentaho.mongo.wrapper.field.MongoField;

public class MongodbInputDiscoverFieldsImpl
implements MongoDbInputDiscoverFields {
    private static final Class<?> PKG = MongodbInputDiscoverFieldsImpl.class;

    @Override
    public List<MongoField> discoverFields(MongoProperties.Builder properties, String db, final String collection, final String query, final String fields, final boolean isPipeline, final int docsToSample, MongoDbInputMeta step) throws KettleException {
        MongoClientWrapper clientWrapper = null;
        try {
            clientWrapper = MongoWrapperUtil.createMongoClientWrapper(properties, null);
        }
        catch (MongoDbException e) {
            throw new KettleException((Throwable)e);
        }
        try {
            List<MongoField> e = clientWrapper.perform(db, new MongoDBAction<List<MongoField>>(){

                @Override
                public List<MongoField> perform(DB db) throws MongoDbException {
                    DBCursor cursor = null;
                    int numDocsToSample = docsToSample;
                    if (numDocsToSample < 1) {
                        numDocsToSample = 100;
                    }
                    ArrayList<MongoField> discoveredFields = new ArrayList<MongoField>();
                    HashMap<String, MongoField> fieldLookup = new HashMap<String, MongoField>();
                    try {
                        if (Const.isEmpty((String)collection)) {
                            throw new KettleException(BaseMessages.getString((Class)PKG, (String)"MongoNoAuthWrapper.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
                        }
                        DBCollection dbcollection = db.getCollection(collection);
                        Iterator pipeSample = null;
                        if (isPipeline) {
                            pipeSample = MongodbInputDiscoverFieldsImpl.setUpPipelineSample(query, numDocsToSample, dbcollection);
                        } else if (Const.isEmpty((String)query) && Const.isEmpty((String)fields)) {
                            cursor = dbcollection.find().limit(numDocsToSample);
                        } else {
                            DBObject dbObject = (DBObject)JSON.parse((String)(Const.isEmpty((String)query) ? "{}" : query));
                            DBObject dbObject2 = (DBObject)JSON.parse((String)fields);
                            cursor = dbcollection.find(dbObject, dbObject2).limit(numDocsToSample);
                        }
                        int actualCount = 0;
                        while (cursor != null ? cursor.hasNext() : pipeSample.hasNext()) {
                            ++actualCount;
                            DBObject nextDoc = cursor != null ? cursor.next() : (DBObject)pipeSample.next();
                            MongodbInputDiscoverFieldsImpl.docToFields(nextDoc, fieldLookup);
                        }
                        MongodbInputDiscoverFieldsImpl.postProcessPaths(fieldLookup, discoveredFields, actualCount);
                        ArrayList<MongoField> arrayList = discoveredFields;
                        return arrayList;
                    }
                    catch (Exception e) {
                        throw new MongoDbException((Throwable)e);
                    }
                    finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                }
            });
            return e;
        }
        catch (Exception ex) {
            if (ex instanceof KettleException) {
                throw (KettleException)((Object)ex);
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToDiscoverFields", (String[])new String[0]), (Throwable)ex);
        }
        finally {
            try {
                clientWrapper.dispose();
            }
            catch (MongoDbException mongoDbException) {}
        }
    }

    @Override
    public void discoverFields(final MongoProperties.Builder properties, final String db, final String collection, final String query, final String fields, final boolean isPipeline, final int docsToSample, final MongoDbInputMeta step, final DiscoverFieldsCallback discoverFieldsCallback) throws KettleException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    discoverFieldsCallback.notifyFields(MongodbInputDiscoverFieldsImpl.this.discoverFields(properties, db, collection, query, fields, isPipeline, docsToSample, step));
                }
                catch (KettleException e) {
                    discoverFieldsCallback.notifyException((Exception)((Object)e));
                }
            }
        }).run();
    }

    protected static void postProcessPaths(Map<String, MongoField> fieldLookup, List<MongoField> discoveredFields, int numDocsProcessed) {
        ArrayList<String> fieldKeys = new ArrayList<String>(fieldLookup.keySet());
        Collections.sort(fieldKeys);
        for (String key : fieldKeys) {
            MongoField m = fieldLookup.get(key);
            m.m_occurenceFraction = "" + m.m_percentageOfSample + "/" + numDocsProcessed;
            MongodbInputDiscoverFieldsImpl.setMinArrayIndexes(m);
            if (m.m_fieldName.contains("[") && m.m_fieldName.contains(":")) {
                m.m_arrayIndexInfo = m.m_fieldName;
            }
            if (m.m_fieldName.indexOf(46) >= 0) {
                m.m_fieldName = m.m_fieldName.substring(m.m_fieldName.lastIndexOf(46) + 1, m.m_fieldName.length());
            }
            if (m.m_disparateTypes) {
                m.m_kettleType = ValueMeta.getTypeDesc((int)2);
            }
            discoveredFields.add(m);
        }
        HashMap<String, Integer> tempM = new HashMap<String, Integer>();
        for (MongoField m : discoveredFields) {
            if (tempM.get(m.m_fieldName) != null) {
                Integer toUse = (Integer)tempM.get(m.m_fieldName);
                String key = m.m_fieldName;
                m.m_fieldName = key + "_" + toUse;
                toUse = new Integer(toUse + 1);
                tempM.put(key, toUse);
                continue;
            }
            tempM.put(m.m_fieldName, 1);
        }
    }

    protected static void setMinArrayIndexes(MongoField m) {
        if (m.m_fieldName.indexOf(91) < 0) {
            return;
        }
        String temp = m.m_fieldPath;
        String tempComp = m.m_fieldName;
        StringBuffer updated = new StringBuffer();
        while (temp.indexOf(91) >= 0) {
            String firstPart = temp.substring(0, temp.indexOf(91));
            String innerPart = temp.substring(temp.indexOf(91) + 1, temp.indexOf(93));
            if (!innerPart.equals("-")) {
                updated.append(temp);
                temp = "";
                break;
            }
            updated.append(firstPart);
            String innerComp = tempComp.substring(tempComp.indexOf(91) + 1, tempComp.indexOf(93));
            if (temp.indexOf(93) < temp.length() - 1) {
                temp = temp.substring(temp.indexOf(93) + 1, temp.length());
                tempComp = tempComp.substring(tempComp.indexOf(93) + 1, tempComp.length());
            } else {
                temp = "";
            }
            String[] compParts = innerComp.split(":");
            String replace = "[" + compParts[0] + "]";
            updated.append(replace);
        }
        if (temp.length() > 0) {
            updated.append(temp);
        }
        m.m_fieldPath = updated.toString();
    }

    protected static void docToFields(DBObject doc, Map<String, MongoField> lookup) {
        String root = "$";
        String name = "$";
        if (doc instanceof BasicDBObject) {
            MongodbInputDiscoverFieldsImpl.processRecord((BasicDBObject)doc, root, name, lookup);
        } else if (doc instanceof BasicDBList) {
            MongodbInputDiscoverFieldsImpl.processList((BasicDBList)doc, root, name, lookup);
        }
    }

    private static void processRecord(BasicDBObject rec, String path, String name, Map<String, MongoField> lookup) {
        for (String key : rec.keySet()) {
            Object fieldValue = rec.get(key);
            if (fieldValue instanceof BasicDBObject) {
                MongodbInputDiscoverFieldsImpl.processRecord((BasicDBObject)fieldValue, path + "." + key, name + "." + key, lookup);
                continue;
            }
            if (fieldValue instanceof BasicDBList) {
                MongodbInputDiscoverFieldsImpl.processList((BasicDBList)fieldValue, path + "." + key, name + "." + key, lookup);
                continue;
            }
            String finalPath = path + "." + key;
            String finalName = name + "." + key;
            if (!lookup.containsKey(finalPath)) {
                MongoField newField = new MongoField();
                int kettleType = MongodbInputDiscoverFieldsImpl.mongoToKettleType(fieldValue);
                newField.m_mongoType = String.class;
                if (fieldValue != null) {
                    newField.m_mongoType = fieldValue.getClass();
                }
                newField.m_fieldName = finalName;
                newField.m_fieldPath = finalPath;
                newField.m_kettleType = ValueMeta.getTypeDesc((int)kettleType);
                newField.m_percentageOfSample = 1;
                lookup.put(finalPath, newField);
                continue;
            }
            MongoField m = lookup.get(finalPath);
            Class fieldClass = String.class;
            if (fieldValue != null) {
                fieldClass = fieldValue.getClass();
            }
            if (!m.m_mongoType.isAssignableFrom(fieldClass)) {
                m.m_disparateTypes = true;
            }
            ++m.m_percentageOfSample;
            MongodbInputDiscoverFieldsImpl.updateMaxArrayIndexes(m, finalName);
        }
    }

    private static void processList(BasicDBList list, String path, String name, Map<String, MongoField> lookup) {
        if (list.size() == 0) {
            return;
        }
        String nonPrimitivePath = path + "[-]";
        String primitivePath = path;
        for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            if (element instanceof BasicDBObject) {
                MongodbInputDiscoverFieldsImpl.processRecord((BasicDBObject)element, nonPrimitivePath, name + "[" + i + ":" + i + "]", lookup);
                continue;
            }
            if (element instanceof BasicDBList) {
                MongodbInputDiscoverFieldsImpl.processList((BasicDBList)element, nonPrimitivePath, name + "[" + i + ":" + i + "]", lookup);
                continue;
            }
            String finalPath = primitivePath + "[" + i + "]";
            String finalName = name + "[" + i + "]";
            if (!lookup.containsKey(finalPath)) {
                MongoField newField = new MongoField();
                int kettleType = MongodbInputDiscoverFieldsImpl.mongoToKettleType(element);
                newField.m_mongoType = String.class;
                if (element != null) {
                    newField.m_mongoType = element.getClass();
                }
                newField.m_fieldName = finalPath;
                newField.m_fieldPath = finalName;
                newField.m_kettleType = ValueMeta.getTypeDesc((int)kettleType);
                newField.m_percentageOfSample = 1;
                lookup.put(finalPath, newField);
                continue;
            }
            MongoField m = lookup.get(finalPath);
            Class elementClass = String.class;
            if (element != null) {
                elementClass = element.getClass();
            }
            if (!m.m_mongoType.isAssignableFrom(elementClass)) {
                m.m_disparateTypes = true;
            }
            ++m.m_percentageOfSample;
            MongodbInputDiscoverFieldsImpl.updateMaxArrayIndexes(m, finalName);
        }
    }

    protected static void updateMaxArrayIndexes(MongoField m, String update) {
        if (m.m_fieldName.indexOf(91) < 0) {
            return;
        }
        if (m.m_fieldName.split("\\[").length != update.split("\\[").length) {
            throw new IllegalArgumentException("Field path and update path do not seem to contain the same number of array parts!");
        }
        String temp = m.m_fieldName;
        String tempComp = update;
        StringBuffer updated = new StringBuffer();
        while (temp.indexOf(91) >= 0) {
            String firstPart = temp.substring(0, temp.indexOf(91));
            String innerPart = temp.substring(temp.indexOf(91) + 1, temp.indexOf(93));
            if (innerPart.indexOf(58) < 0) {
                updated.append(temp);
                temp = "";
                break;
            }
            updated.append(firstPart);
            String innerComp = tempComp.substring(tempComp.indexOf(91) + 1, tempComp.indexOf(93));
            if (temp.indexOf(93) < temp.length() - 1) {
                temp = temp.substring(temp.indexOf(93) + 1, temp.length());
                tempComp = tempComp.substring(tempComp.indexOf(93) + 1, tempComp.length());
            } else {
                temp = "";
            }
            String[] origParts = innerPart.split(":");
            String[] compParts = innerComp.split(":");
            int origMax = Integer.parseInt(origParts[1]);
            int compMax = Integer.parseInt(compParts[1]);
            if (compMax > origMax) {
                String newRange = "[" + origParts[0] + ":" + compMax + "]";
                updated.append(newRange);
                continue;
            }
            String oldRange = "[" + innerPart + "]";
            updated.append(oldRange);
        }
        if (temp.length() > 0) {
            updated.append(temp);
        }
        m.m_fieldName = updated.toString();
    }

    protected static int mongoToKettleType(Object fieldValue) {
        if (fieldValue == null) {
            return 2;
        }
        if (fieldValue instanceof Symbol || fieldValue instanceof String || fieldValue instanceof Code || fieldValue instanceof ObjectId || fieldValue instanceof MinKey || fieldValue instanceof MaxKey) {
            return 2;
        }
        if (fieldValue instanceof Date) {
            return 3;
        }
        if (fieldValue instanceof Number) {
            try {
                Integer.parseInt(fieldValue.toString());
                return 5;
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        if (fieldValue instanceof Binary) {
            return 8;
        }
        if (fieldValue instanceof BSONTimestamp) {
            return 5;
        }
        return 2;
    }

    private static Iterator<DBObject> setUpPipelineSample(String query, int numDocsToSample, DBCollection collection) throws KettleException {
        query = query + ", {$limit : " + numDocsToSample + "}";
        List<DBObject> samplePipe = MongodbInputDiscoverFieldsImpl.jsonPipelineToDBObjectList(query);
        DBObject first = samplePipe.get(0);
        DBObject[] remainder = new DBObject[samplePipe.size() - 1];
        for (int i = 1; i < samplePipe.size(); ++i) {
            remainder[i - 1] = samplePipe.get(i);
        }
        AggregationOutput result = collection.aggregate(first, remainder);
        return result.results().iterator();
    }

    public static List<DBObject> jsonPipelineToDBObjectList(String jsonPipeline) throws KettleException {
        ArrayList<DBObject> pipeline = new ArrayList<DBObject>();
        StringBuilder b = new StringBuilder(jsonPipeline.trim());
        int bracketCount = -1;
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 0; i < b.length(); ++i) {
            if (b.charAt(i) == '{') {
                if (bracketCount == -1) {
                    b.delete(0, i);
                    bracketCount = 0;
                    i = 0;
                }
                ++bracketCount;
            }
            if (b.charAt(i) == '}') {
                --bracketCount;
            }
            if (bracketCount != 0) continue;
            String part = b.substring(0, i + 1);
            parts.add(part);
            bracketCount = -1;
            if (i == b.length() - 1) break;
            b.delete(0, i + 1);
            i = 0;
        }
        for (String p : parts) {
            if (Const.isEmpty((String)p)) continue;
            DBObject o = (DBObject)JSON.parse((String)p);
            pipeline.add(o);
        }
        if (pipeline.size() == 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoNoAuthWrapper.ErrorMessage.UnableToParsePipelineOperators", (String[])new String[0]));
        }
        return pipeline;
    }
}

