/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.impl;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.pentaho.osgi.api.BlueprintStateService;
import org.pentaho.osgi.api.IKarafBlueprintWatcher;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.servicecoordination.api.IServiceBarrier;
import org.pentaho.platform.servicecoordination.api.IServiceBarrierManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafBlueprintWatcherImpl
implements IKarafBlueprintWatcher {
    private BundleContext bundleContext;
    private long timeout;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String KARAF_TIMEOUT_PROPERTY = "karafWaitForBoot";

    public KarafBlueprintWatcherImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.timeout = PentahoSystem.getApplicationContext().getProperty(KARAF_TIMEOUT_PROPERTY) == null ? 120000L : Long.valueOf(PentahoSystem.getApplicationContext().getProperty(KARAF_TIMEOUT_PROPERTY));
    }

    public void waitForBlueprint() throws IKarafBlueprintWatcher.BlueprintWatcherException {
        long entryTime = System.currentTimeMillis();
        ServiceTracker serviceTracker = new ServiceTracker(this.bundleContext, BlueprintStateService.class.getName(), null);
        serviceTracker.open();
        try {
            serviceTracker.waitForService(this.timeout);
        }
        catch (InterruptedException e) {
            this.logger.debug("BlueprintStateService ServiceTracker Interrupted");
        }
        ServiceReference serviceReference = this.bundleContext.getServiceReference(BlueprintStateService.class);
        if (serviceReference != null) {
            BlueprintStateService blueprintStateService = (BlueprintStateService)this.bundleContext.getService(serviceReference);
            try {
                while (true) {
                    ArrayList<String> unloadedBlueprints = new ArrayList<String>();
                    for (Bundle bundle : this.bundleContext.getBundles()) {
                        if (!blueprintStateService.hasBlueprint(bundle.getBundleId()).booleanValue() || blueprintStateService.isBlueprintLoaded(bundle.getBundleId()).booleanValue() || blueprintStateService.isBlueprintFailed(bundle.getBundleId()).booleanValue()) continue;
                        unloadedBlueprints.add(bundle.getSymbolicName());
                    }
                    if (unloadedBlueprints.size() > 0) {
                        if (System.currentTimeMillis() - this.timeout > entryTime) {
                            IServiceBarrier serviceBarrier = IServiceBarrierManager.LOCATOR.getManager().getServiceBarrier("KarafFeatureWatcherBarrier");
                            if (serviceBarrier == null || serviceBarrier.isAvailable()) {
                                throw new IKarafBlueprintWatcher.BlueprintWatcherException("Timed out waiting for blueprints to load: " + StringUtils.join(unloadedBlueprints, (String)","));
                            }
                            entryTime = System.currentTimeMillis();
                        }
                        this.logger.debug("KarafBlueprintWatcher is waiting for the following blueprints to load: " + StringUtils.join(unloadedBlueprints, (String)","));
                        Thread.sleep(100L);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new IKarafBlueprintWatcher.BlueprintWatcherException("Unknown error in KarafBlueprintWatcher", (Throwable)e);
            }
        }
    }
}

