/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.metrics;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingLong;

public class ScanMetrics
implements Writable {
    private static final byte SCANMETRICS_VERSION = 1;
    private static final Log LOG = LogFactory.getLog(ScanMetrics.class);
    private MetricsRegistry registry = new MetricsRegistry();
    public final MetricsTimeVaryingLong countOfRPCcalls = new MetricsTimeVaryingLong("RPC_CALLS", this.registry);
    public final MetricsTimeVaryingLong countOfRemoteRPCcalls = new MetricsTimeVaryingLong("REMOTE_RPC_CALLS", this.registry);
    public final MetricsTimeVaryingLong sumOfMillisSecBetweenNexts = new MetricsTimeVaryingLong("MILLIS_BETWEEN_NEXTS", this.registry);
    public final MetricsTimeVaryingLong countOfNSRE = new MetricsTimeVaryingLong("NOT_SERVING_REGION_EXCEPTION", this.registry);
    public final MetricsTimeVaryingLong countOfBytesInResults = new MetricsTimeVaryingLong("BYTES_IN_RESULTS", this.registry);
    public final MetricsTimeVaryingLong countOfBytesInRemoteResults = new MetricsTimeVaryingLong("BYTES_IN_REMOTE_RESULTS", this.registry);
    public final MetricsTimeVaryingLong countOfRegions = new MetricsTimeVaryingLong("REGIONS_SCANNED", this.registry);
    public final MetricsTimeVaryingLong countOfRPCRetries = new MetricsTimeVaryingLong("RPC_RETRIES", this.registry);
    public final MetricsTimeVaryingLong countOfRemoteRPCRetries = new MetricsTimeVaryingLong("REMOTE_RPC_RETRIES", this.registry);

    public void write(DataOutput out) throws IOException {
        out.writeByte(1);
        Collection mbs = this.registry.getMetricsList();
        int metricsCount = 0;
        for (MetricsBase mb : mbs) {
            if (mb instanceof MetricsTimeVaryingLong) {
                ++metricsCount;
                continue;
            }
            throw new IOException("unsupported metrics type. metrics name: " + mb.getName() + ", metrics description: " + mb.getDescription());
        }
        out.writeInt(metricsCount);
        for (MetricsBase mb : mbs) {
            out.writeUTF(mb.getName());
            out.writeLong(((MetricsTimeVaryingLong)mb).getCurrentIntervalValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 1) {
            throw new IOException("version " + version + " not supported");
        }
        int metricsCount = in.readInt();
        for (int i = 0; i < metricsCount; ++i) {
            String metricsName = in.readUTF();
            long v = in.readLong();
            MetricsBase mb = this.registry.get(metricsName);
            if (mb instanceof MetricsTimeVaryingLong) {
                ((MetricsTimeVaryingLong)mb).inc(v);
                continue;
            }
            LOG.warn((Object)("unsupported metrics type. metrics name: " + mb.getName() + ", metrics description: " + mb.getDescription()));
        }
    }

    public MetricsTimeVaryingLong[] getMetricsTimeVaryingLongArray() {
        Collection mbs = this.registry.getMetricsList();
        ArrayList<MetricsTimeVaryingLong> mlv = new ArrayList<MetricsTimeVaryingLong>();
        for (MetricsBase mb : mbs) {
            if (!(mb instanceof MetricsTimeVaryingLong)) continue;
            mlv.add((MetricsTimeVaryingLong)mb);
        }
        return mlv.toArray(new MetricsTimeVaryingLong[mlv.size()]);
    }
}

