/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.util.Methods;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public abstract class User {
    public static final String HBASE_SECURITY_CONF_KEY = "hbase.security.authentication";
    private static boolean IS_SECURE_HADOOP = true;
    private static Log LOG;
    protected UserGroupInformation ugi;

    public UserGroupInformation getUGI() {
        return this.ugi;
    }

    public String getName() {
        return this.ugi.getUserName();
    }

    public String[] getGroupNames() {
        return this.ugi.getGroupNames();
    }

    public abstract String getShortName();

    public abstract <T> T runAs(PrivilegedAction<T> var1);

    public abstract <T> T runAs(PrivilegedExceptionAction<T> var1) throws IOException, InterruptedException;

    public abstract void obtainAuthTokenForJob(Configuration var1, Job var2) throws IOException, InterruptedException;

    public abstract void obtainAuthTokenForJob(JobConf var1) throws IOException, InterruptedException;

    public Token<?> getToken(String kind, String service) throws IOException {
        for (Token token : this.ugi.getTokens()) {
            if (!token.getKind().toString().equals(kind) || service == null || !token.getService().toString().equals(service)) continue;
            return token;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.ugi.equals((Object)((User)o).ugi);
    }

    public int hashCode() {
        return this.ugi.hashCode();
    }

    public String toString() {
        return this.ugi.toString();
    }

    public static User getCurrent() throws IOException {
        User user = IS_SECURE_HADOOP ? new SecureHadoopUser() : new HadoopUser();
        if (user.getUGI() == null) {
            return null;
        }
        return user;
    }

    public static User create(UserGroupInformation ugi) {
        if (ugi == null) {
            return null;
        }
        if (IS_SECURE_HADOOP) {
            return new SecureHadoopUser(ugi);
        }
        return new HadoopUser(ugi);
    }

    public static User createUserForTesting(Configuration conf, String name, String[] groups) {
        if (IS_SECURE_HADOOP) {
            return SecureHadoopUser.createUserForTesting(conf, name, groups);
        }
        return HadoopUser.createUserForTesting(conf, name, groups);
    }

    public static void login(Configuration conf, String fileConfKey, String principalConfKey, String localhost) throws IOException {
        if (IS_SECURE_HADOOP) {
            SecureHadoopUser.login(conf, fileConfKey, principalConfKey, localhost);
        } else {
            HadoopUser.login(conf, fileConfKey, principalConfKey, localhost);
        }
    }

    public static boolean isSecurityEnabled() {
        if (IS_SECURE_HADOOP) {
            return SecureHadoopUser.isSecurityEnabled();
        }
        return HadoopUser.isSecurityEnabled();
    }

    public static boolean isHBaseSecurityEnabled(Configuration conf) {
        return "kerberos".equalsIgnoreCase(conf.get(HBASE_SECURITY_CONF_KEY));
    }

    private static Object callStatic(String methodName) throws Exception {
        return User.call(null, methodName, null, null);
    }

    private static Object callStatic(String methodName, Class[] types, Object[] args) throws Exception {
        return User.call(null, methodName, types, args);
    }

    private static Object call(UserGroupInformation instance, String methodName, Class[] types, Object[] args) throws Exception {
        return Methods.call(UserGroupInformation.class, instance, methodName, types, args);
    }

    static {
        try {
            UserGroupInformation.class.getMethod("isSecurityEnabled", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            IS_SECURE_HADOOP = false;
        }
        LOG = LogFactory.getLog(User.class);
    }

    public static class SecureHadoopUser
    extends User {
        private String shortName;

        private SecureHadoopUser() throws IOException {
            try {
                this.ugi = (UserGroupInformation)User.callStatic("getCurrentUser");
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception getting current secure user");
            }
        }

        public SecureHadoopUser(UserGroupInformation ugi) {
            this.ugi = ugi;
        }

        @Override
        public String getShortName() {
            if (this.shortName != null) {
                return this.shortName;
            }
            try {
                this.shortName = (String)User.call(this.ugi, "getShortUserName", null, null);
                return this.shortName;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected error getting user short name");
            }
        }

        @Override
        public <T> T runAs(PrivilegedAction<T> action) {
            try {
                return (T)User.call(this.ugi, "doAs", new Class[]{PrivilegedAction.class}, new Object[]{action});
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception in runAs()");
            }
        }

        @Override
        public <T> T runAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
            try {
                return (T)User.call(this.ugi, "doAs", new Class[]{PrivilegedExceptionAction.class}, new Object[]{action});
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception in runAs(PrivilegedExceptionAction)");
            }
        }

        @Override
        public void obtainAuthTokenForJob(Configuration conf, Job job) throws IOException, InterruptedException {
            try {
                Class<?> c = Class.forName("org.apache.hadoop.hbase.security.token.TokenUtil");
                Methods.call(c, null, "obtainTokenForJob", new Class[]{Configuration.class, UserGroupInformation.class, Job.class}, new Object[]{conf, this.ugi, job});
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Failure loading TokenUtil class, is secure RPC available?", cnfe);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected error calling TokenUtil.obtainAndCacheToken()");
            }
        }

        @Override
        public void obtainAuthTokenForJob(JobConf job) throws IOException, InterruptedException {
            try {
                Class<?> c = Class.forName("org.apache.hadoop.hbase.security.token.TokenUtil");
                Methods.call(c, null, "obtainTokenForJob", new Class[]{JobConf.class, UserGroupInformation.class}, new Object[]{job, this.ugi});
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Failure loading TokenUtil class, is secure RPC available?", cnfe);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected error calling TokenUtil.obtainAndCacheToken()");
            }
        }

        public static User createUserForTesting(Configuration conf, String name, String[] groups) {
            try {
                return new SecureHadoopUser((UserGroupInformation)User.callStatic("createUserForTesting", new Class[]{String.class, String[].class}, new Object[]{name, groups}));
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Error creating secure test user");
            }
        }

        public static void login(Configuration conf, String fileConfKey, String principalConfKey, String localhost) throws IOException {
            if (SecureHadoopUser.isSecurityEnabled()) {
                try {
                    Class<?> c = Class.forName("org.apache.hadoop.security.SecurityUtil");
                    Class[] types = new Class[]{Configuration.class, String.class, String.class, String.class};
                    Object[] args = new Object[]{conf, fileConfKey, principalConfKey, localhost};
                    Methods.call(c, null, "login", types, args);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Unable to login using org.apache.hadoop.security.SecurityUtil.login(). SecurityUtil class was not found!  Is this a version of secure Hadoop?", cnfe);
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e, "Unhandled exception in User.login()");
                }
            }
        }

        public static boolean isSecurityEnabled() {
            try {
                return (Boolean)User.callStatic("isSecurityEnabled");
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception calling UserGroupInformation.isSecurityEnabled()");
            }
        }
    }

    private static class HadoopUser
    extends User {
        private HadoopUser() {
            try {
                this.ugi = (UserGroupInformation)User.callStatic("getCurrentUGI");
                if (this.ugi == null) {
                    Configuration conf = HBaseConfiguration.create();
                    this.ugi = (UserGroupInformation)User.callStatic("login", new Class[]{Configuration.class}, new Object[]{conf});
                    if (this.ugi != null) {
                        User.callStatic("setCurrentUser", new Class[]{UserGroupInformation.class}, new Object[]{this.ugi});
                    }
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception HadoopUser<init>");
            }
        }

        private HadoopUser(UserGroupInformation ugi) {
            this.ugi = ugi;
        }

        @Override
        public String getShortName() {
            return this.ugi != null ? this.ugi.getUserName() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T runAs(PrivilegedAction<T> action) {
            T result = null;
            UserGroupInformation previous = null;
            try {
                previous = (UserGroupInformation)User.callStatic("getCurrentUGI");
                try {
                    if (this.ugi != null) {
                        User.callStatic("setCurrentUser", new Class[]{UserGroupInformation.class}, new Object[]{this.ugi});
                    }
                    result = action.run();
                }
                catch (Throwable throwable) {
                    User.callStatic("setCurrentUser", new Class[]{UserGroupInformation.class}, new Object[]{previous});
                    throw throwable;
                }
                User.callStatic("setCurrentUser", new Class[]{UserGroupInformation.class}, new Object[]{previous});
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception in runAs()");
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T runAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
            T result = null;
            try {
                UserGroupInformation previous = (UserGroupInformation)User.callStatic("getCurrentUGI");
                try {
                    if (this.ugi != null) {
                        User.callStatic("setCurrentUGI", new Class[]{UserGroupInformation.class}, new Object[]{this.ugi});
                    }
                    result = action.run();
                }
                catch (Throwable throwable) {
                    User.callStatic("setCurrentUGI", new Class[]{UserGroupInformation.class}, new Object[]{previous});
                    throw throwable;
                }
                User.callStatic("setCurrentUGI", new Class[]{UserGroupInformation.class}, new Object[]{previous});
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof InterruptedException) {
                    throw (InterruptedException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new UndeclaredThrowableException(e, "Unknown exception in runAs()");
            }
            return result;
        }

        @Override
        public void obtainAuthTokenForJob(Configuration conf, Job job) throws IOException, InterruptedException {
        }

        @Override
        public void obtainAuthTokenForJob(JobConf job) throws IOException, InterruptedException {
        }

        public static User createUserForTesting(Configuration conf, String name, String[] groups) {
            try {
                Class<?> c = Class.forName("org.apache.hadoop.security.UnixUserGroupInformation");
                Constructor<?> constructor = c.getConstructor(String.class, String[].class);
                if (constructor == null) {
                    throw new NullPointerException();
                }
                UserGroupInformation newUser = (UserGroupInformation)constructor.newInstance(name, groups);
                conf.set("hadoop.job.ugi", newUser.toString());
                return new HadoopUser(newUser);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("UnixUserGroupInformation not found, is this secure Hadoop?", cnfe);
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException("No valid constructor found for UnixUserGroupInformation!", nsme);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception instantiating new UnixUserGroupInformation");
            }
        }

        public static void login(Configuration conf, String fileConfKey, String principalConfKey, String localhost) throws IOException {
            LOG.info((Object)"Skipping login, not running on secure Hadoop");
        }

        public static boolean isSecurityEnabled() {
            return false;
        }
    }
}

