/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.Put;

public class Objects {
    public static String describeQuantity(Object obj) {
        StringBuilder str = new StringBuilder();
        QuantityMap quantities = new QuantityMap();
        Objects.quantify(obj, quantities);
        ArrayList totals = new ArrayList(quantities.values());
        Collections.sort(totals, new QuantityComparator());
        for (Quantity q : totals) {
            q.appendToString(str);
        }
        return str.toString();
    }

    public static void quantify(Object obj, QuantityMap quantities) {
        if (obj == null) {
            return;
        }
        if (obj.getClass().isArray()) {
            Class<?> type = obj.getClass().getComponentType();
            int length = Array.getLength(obj);
            if (type.isPrimitive()) {
                quantities.increment(type.getSimpleName(), length);
            } else {
                for (int i = 0; i < length; ++i) {
                    Objects.quantify(Array.get(obj, i), quantities);
                }
            }
        } else if (obj instanceof Iterable) {
            for (Object child : (Iterable)obj) {
                Objects.quantify(child, quantities);
            }
        } else if (obj instanceof MultiAction) {
            MultiAction multi = (MultiAction)obj;
            Objects.quantify(multi.allActions(), quantities);
        } else if (obj instanceof Action) {
            Objects.quantify(((Action)obj).getAction(), quantities);
        } else if (obj instanceof Put) {
            quantities.increment("Put", 1);
            quantities.increment("KeyValue", ((Put)obj).size());
            for (List<KeyValue> keyValues : ((Put)obj).getFamilyMap().values()) {
                for (KeyValue kv : keyValues) {
                    quantities.stat("values", kv.getValueLength());
                }
            }
        } else if (obj instanceof Delete) {
            quantities.increment("Delete", 1);
            for (List<KeyValue> kvs : ((Delete)obj).getFamilyMap().values()) {
                quantities.increment("KeyValue", kvs.size());
            }
        } else if (obj instanceof Increment) {
            quantities.increment("Increment", 1);
            quantities.increment("KeyValue", ((Increment)obj).numColumns());
        } else if (obj instanceof Get) {
            quantities.increment("Get", 1);
        } else {
            String type = obj.getClass().getSimpleName();
            quantities.increment(type, 1);
        }
    }

    private static class QuantityComparator
    implements Comparator<Quantity> {
        private QuantityComparator() {
        }

        @Override
        public int compare(Quantity q1, Quantity q2) {
            if (q1.count < q2.count) {
                return -1;
            }
            if (q1.count > q2.count) {
                return 1;
            }
            return 0;
        }
    }

    private static class Stat
    extends Quantity {
        int min;
        int max;
        long total;

        private Stat() {
        }

        @Override
        public void increment(int amount) {
            if (this.count == 0) {
                this.min = this.max = amount;
            } else {
                this.min = Math.min(this.min, amount);
                this.max = Math.max(this.max, amount);
            }
            this.total += (long)amount;
            ++this.count;
        }

        @Override
        public void appendToString(StringBuilder out) {
            super.appendToString(out);
            out.append(" [ ");
            if (this.count > 0) {
                out.append("min=").append(this.min).append(" max=").append(this.max).append(" avg=").append((int)(this.total / (long)this.count));
            } else {
                out.append("none");
            }
            out.append(" ]");
        }
    }

    private static class Quantity {
        int count;
        String what;

        private Quantity() {
        }

        public void increment(int amount) {
            this.count += amount;
        }

        public void appendToString(StringBuilder out) {
            if (out.length() > 0) {
                out.append(", ");
            }
            out.append(this.count).append(" ").append(this.what);
            if (this.count != 1 && !this.what.endsWith("s")) {
                out.append("s");
            }
        }
    }

    private static class QuantityMap
    extends HashMap<String, Quantity> {
        private QuantityMap() {
        }

        public void increment(String type, int count) {
            Quantity q = (Quantity)this.get(type);
            if (q == null) {
                q = new Quantity();
                q.what = type;
                this.put(type, q);
            }
            q.increment(count);
        }

        public void stat(String type, int value) {
            Quantity q = (Quantity)this.get(type);
            if (q == null) {
                q = new Stat();
                q.what = type;
                this.put(type, q);
            }
            q.increment(value);
        }
    }
}

