/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.rowdecoder;

import java.util.List;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.HBaseRowToKettleTuple;
import org.pentaho.big.data.kettle.plugins.hbase.rowdecoder.HBaseRowDecoderData;
import org.pentaho.big.data.kettle.plugins.hbase.rowdecoder.HBaseRowDecoderMeta;
import org.pentaho.bigdata.api.hbase.ByteConversionUtil;
import org.pentaho.bigdata.api.hbase.HBaseService;
import org.pentaho.bigdata.api.hbase.Result;
import org.pentaho.bigdata.api.hbase.ResultFactory;
import org.pentaho.bigdata.api.hbase.ResultFactoryException;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class HBaseRowDecoder
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = HBaseRowDecoderMeta.class;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    protected HBaseRowDecoderMeta m_meta;
    protected HBaseRowDecoderData m_data;
    private HBaseService hBaseService;
    private ResultFactory resultFactory;
    protected Mapping m_tableMapping;
    protected HBaseValueMetaInterface[] m_outputColumns;
    protected int m_keyInIndex = -1;
    protected int m_resultInIndex = -1;
    protected HBaseRowToKettleTuple m_tupleHandler;
    protected ByteConversionUtil m_bytesUtil;

    public HBaseRowDecoder(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] inputRow = this.getRow();
        if (inputRow == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.m_meta = (HBaseRowDecoderMeta)smi;
            this.m_data = (HBaseRowDecoderData)sdi;
            try {
                this.hBaseService = (HBaseService)this.namedClusterServiceLocator.getService(null, HBaseService.class);
                this.resultFactory = this.hBaseService.getResultFactory();
                this.m_bytesUtil = this.hBaseService.getByteConversionUtil();
            }
            catch (Exception ex) {
                throw new KettleException(ex.getMessage(), (Throwable)ex);
            }
            this.m_tableMapping = this.m_meta.getMapping();
            if (this.m_tableMapping == null || Const.isEmpty((String)this.m_tableMapping.getKeyName())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.NoMappingInfo", (String[])new String[0]));
            }
            if (this.m_tableMapping.isTupleMapping()) {
                this.m_tupleHandler = new HBaseRowToKettleTuple(this.m_bytesUtil);
            }
            this.m_outputColumns = new HBaseValueMetaInterface[this.m_tableMapping.getMappedColumns().keySet().size()];
            int k = 0;
            for (String alias : this.m_tableMapping.getMappedColumns().keySet()) {
                this.m_outputColumns[k++] = (HBaseValueMetaInterface)this.m_tableMapping.getMappedColumns().get(alias);
            }
            this.m_data.setOutputRowMeta(this.getInputRowMeta().clone());
            this.m_meta.getFields(this.m_data.getOutputRowMeta(), this.getStepname(), null, null, (VariableSpace)this);
            RowMetaInterface inputMeta = this.getInputRowMeta();
            String inKey = this.environmentSubstitute(this.m_meta.getIncomingKeyField());
            this.m_keyInIndex = inputMeta.indexOfValue(inKey);
            if (this.m_keyInIndex == -1) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.UnableToFindHBaseKey", (String[])new String[]{inKey}));
            }
            if (!this.m_bytesUtil.isImmutableBytesWritable(inputRow[this.m_keyInIndex])) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.NotImmutableBytesWritable", (String[])new String[]{this.m_meta.getIncomingKeyField()}));
            }
            String inResult = this.environmentSubstitute(this.m_meta.getIncomingResultField());
            this.m_resultInIndex = inputMeta.indexOfValue(inResult);
            if (this.m_resultInIndex == -1) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.UnableToFindHBaseRow", (String[])new String[]{inResult}));
            }
            if (!this.resultFactory.canHandle(inputRow[this.m_resultInIndex])) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.NotResult", (String[])new String[]{this.m_meta.getIncomingResultField()}));
            }
        }
        Result hRow = null;
        try {
            hRow = this.resultFactory.create(inputRow[this.m_resultInIndex]);
        }
        catch (ResultFactoryException e) {
            throw new KettleException(e.getMessage(), (Throwable)e);
        }
        if (inputRow[this.m_keyInIndex] != null && hRow != null) {
            if (this.m_tableMapping.isTupleMapping()) {
                List<Object[]> hrowToKettleRow = this.m_tupleHandler.hbaseRowToKettleTupleMode(this.hBaseService.getHBaseValueMetaInterfaceFactory(), hRow, this.m_tableMapping, this.m_tableMapping.getMappedColumns(), this.m_data.getOutputRowMeta());
                for (Object[] tuple : hrowToKettleRow) {
                    this.putRow(this.m_data.getOutputRowMeta(), tuple);
                }
            } else {
                Object decodedKey;
                Object[] outputRowData = RowDataUtil.allocateRowData((int)(this.m_outputColumns.length + 1));
                byte[] rowKey = null;
                try {
                    rowKey = hRow.getRow();
                }
                catch (Exception ex) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.UnableToGetRowKey", (String[])new String[0]), (Throwable)ex);
                }
                outputRowData[0] = decodedKey = this.m_tableMapping.decodeKeyValue(rowKey);
                for (int i = 0; i < this.m_outputColumns.length; ++i) {
                    Object decodedVal;
                    HBaseValueMetaInterface current = this.m_outputColumns[i];
                    String colFamilyName = current.getColumnFamily();
                    String qualifier = current.getColumnName();
                    byte[] kv = null;
                    try {
                        kv = hRow.getValue(colFamilyName, qualifier, false);
                    }
                    catch (Exception ex) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.UnableToGetColumnValue", (String[])new String[0]), (Throwable)ex);
                    }
                    outputRowData[i + 1] = decodedVal = current.decodeColumnValue(kv == null ? null : kv);
                }
                this.putRow(this.m_data.getOutputRowMeta(), outputRowData);
            }
        }
        return true;
    }
}

