/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.rowdecoder;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.api.initializer.ClusterInitializationException;
import org.pentaho.big.data.kettle.plugins.hbase.rowdecoder.HBaseRowDecoder;
import org.pentaho.big.data.kettle.plugins.hbase.rowdecoder.HBaseRowDecoderData;
import org.pentaho.big.data.kettle.plugins.hbase.rowdecoder.HBaseRowDecoderDialog;
import org.pentaho.bigdata.api.hbase.HBaseService;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.w3c.dom.Node;

@Step(id="HBaseRowDecoder", image="HBRD.svg", name="HBaseRowDecoder.Name", description="HBaseRowDecoder.Description", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.BigData", i18nPackageName="org.pentaho.di.trans.steps.hbaserowdecoder")
public class HBaseRowDecoderMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected String m_incomingKeyField = "";
    protected String m_incomingResultField = "";
    protected Mapping m_mapping;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;

    public HBaseRowDecoderMeta(NamedClusterServiceLocator namedClusterServiceLocator, NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
    }

    public void setIncomingKeyField(String inKey) {
        this.m_incomingKeyField = inKey;
    }

    public String getIncomingKeyField() {
        return this.m_incomingKeyField;
    }

    public void setIncomingResultField(String inResult) {
        this.m_incomingResultField = inResult;
    }

    public String getIncomingResultField() {
        return this.m_incomingResultField;
    }

    public void setMapping(Mapping m) {
        this.m_mapping = m;
    }

    public Mapping getMapping() {
        return this.m_mapping;
    }

    public void setDefault() {
        this.m_incomingKeyField = "";
        this.m_incomingResultField = "";
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        rowMeta.clear();
        if (this.m_mapping != null) {
            int kettleType = this.m_mapping.getKeyType() == Mapping.KeyType.DATE || this.m_mapping.getKeyType() == Mapping.KeyType.UNSIGNED_DATE ? 3 : (this.m_mapping.getKeyType() == Mapping.KeyType.STRING ? 2 : (this.m_mapping.getKeyType() == Mapping.KeyType.BINARY ? 8 : 5));
            ValueMeta keyMeta = new ValueMeta(this.m_mapping.getKeyName(), kettleType);
            keyMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)keyMeta);
            Map mappedColumnsByAlias = this.m_mapping.getMappedColumns();
            Set aliasSet = mappedColumnsByAlias.keySet();
            for (String alias : aliasSet) {
                HBaseValueMetaInterface columnMeta = (HBaseValueMetaInterface)mappedColumnsByAlias.get(alias);
                columnMeta.setOrigin(origin);
                rowMeta.addValueMeta((ValueMetaInterface)columnMeta);
            }
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new HBaseRowDecoder(stepMeta, stepDataInterface, copyNr, transMeta, trans, this.namedClusterServiceLocator);
    }

    public StepDataInterface getStepData() {
        return new HBaseRowDecoderData();
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        if (!Const.isEmpty((String)this.m_incomingKeyField)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"incoming_key_field", (String)this.m_incomingKeyField));
        }
        if (!Const.isEmpty((String)this.m_incomingResultField)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"incoming_result_field", (String)this.m_incomingResultField));
        }
        if (this.m_mapping != null) {
            retval.append(this.m_mapping.getXML());
        }
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.m_incomingKeyField = XMLHandler.getTagValue((Node)stepnode, (String)"incoming_key_field");
        this.m_incomingResultField = XMLHandler.getTagValue((Node)stepnode, (String)"incoming_result_field");
        try {
            this.m_mapping = ((HBaseService)this.namedClusterServiceLocator.getService(null, HBaseService.class)).getMappingFactory().createMapping();
        }
        catch (ClusterInitializationException e) {
            throw new KettleXMLException((Throwable)e);
        }
        this.m_mapping.loadXML(stepnode);
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        this.m_incomingKeyField = rep.getStepAttributeString(id_step, 0, "incoming_key_field");
        this.m_incomingResultField = rep.getStepAttributeString(id_step, 0, "incoming_result_field");
        try {
            this.m_mapping = ((HBaseService)this.namedClusterServiceLocator.getService(null, HBaseService.class)).getMappingFactory().createMapping();
        }
        catch (ClusterInitializationException e) {
            throw new KettleXMLException((Throwable)e);
        }
        this.m_mapping.readRep(rep, id_step);
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        if (!Const.isEmpty((String)this.m_incomingKeyField)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "incoming_key_field", this.m_incomingKeyField);
        }
        if (!Const.isEmpty((String)this.m_incomingResultField)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "incoming_result_field", this.m_incomingResultField);
        }
        if (this.m_mapping != null) {
            this.m_mapping.saveRep(rep, id_transformation, id_step);
        }
    }

    public StepDialogInterface getDialog(Shell shell, StepMetaInterface meta, TransMeta transMeta, String name) {
        return new HBaseRowDecoderDialog(shell, meta, transMeta, name, this.namedClusterService, this.runtimeTestActionService, this.runtimeTester, this.namedClusterServiceLocator);
    }
}

