/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gis.shapefiles;

public class Converter {
    public static final int getIntegerLittle(byte[] b, int pos) {
        int[] bi = new int[4];
        for (int i = 0; i < 4; ++i) {
            bi[i] = b[pos + i];
            if (bi[i] >= 0) continue;
            int n = i;
            bi[n] = bi[n] + 256;
        }
        return bi[0] + (bi[1] << 8) + (bi[2] << 16) + (bi[3] << 24);
    }

    public static final int getIntegerBig(byte[] b, int pos) {
        int[] bi = new int[4];
        for (int i = 0; i < 4; ++i) {
            bi[i] = b[pos + i];
            if (bi[i] >= 0) continue;
            int n = i;
            bi[n] = bi[n] + 256;
        }
        return bi[3] + (bi[2] << 8) + (bi[1] << 16) + (bi[0] << 24);
    }

    public static final long getLongLittle(byte[] b, int pos) {
        long[] bi = new long[8];
        for (int i = 0; i < 8; ++i) {
            bi[i] = b[pos + i];
            if (bi[i] >= 0L) continue;
            int n = i;
            bi[n] = bi[n] + 256L;
        }
        return bi[0] + (bi[1] << 8) + (bi[2] << 16) + (bi[3] << 24) + (bi[4] << 32) + (bi[5] << 40) + (bi[6] << 48) + (bi[7] << 56);
    }

    public static final long getLongBig(byte[] b, int pos) {
        long[] bi = new long[8];
        for (int i = 0; i < 8; ++i) {
            bi[i] = b[pos + i];
            if (bi[i] >= 0L) continue;
            int n = i;
            bi[n] = bi[n] + 256L;
        }
        return bi[7] + (bi[6] << 8) + (bi[5] << 16) + (bi[4] << 24) + (bi[3] << 32) + (bi[2] << 40) + (bi[1] << 48) + (bi[0] << 56);
    }

    public static final double getDoubleLittle(byte[] b, int pos) {
        return Double.longBitsToDouble(Converter.getLongLittle(b, pos));
    }

    public static final double getDoubleBig(byte[] b, int pos) {
        return Double.longBitsToDouble(Converter.getLongBig(b, pos));
    }
}

