/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.AbstractCollectorFunction;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class XYSeriesCollector
extends AbstractCollectorFunction {
    private ArrayList<String> xValueColumns = new ArrayList();
    private ArrayList<String> yValueColumns = new ArrayList();
    private HashMap<ReportStateKey, Sequence<HashMap<Comparable, XYSeries>>> seriesSequenceMap = new HashMap();

    protected HashMap<Comparable, XYSeries> getSeriesMap() {
        HashMap map;
        ReportStateKey key = this.getStateKey();
        Sequence sequence = this.seriesSequenceMap.get(key);
        if (sequence == null) {
            sequence = new Sequence();
            this.seriesSequenceMap.put(key, (Sequence<HashMap<Comparable, XYSeries>>)sequence);
        }
        if ((map = (HashMap)sequence.get(this.getLastGroupSequenceNumber())) == null) {
            map = new HashMap();
            sequence.set(this.getLastGroupSequenceNumber(), map);
        }
        return map;
    }

    @Override
    protected Dataset createNewDataset() {
        return new XYSeriesCollection();
    }

    public void setXValueColumn(int index, String field) {
        if (this.xValueColumns.size() == index) {
            this.xValueColumns.add(field);
        } else {
            this.xValueColumns.set(index, field);
        }
    }

    public String getXValueColumn(int index) {
        return this.xValueColumns.get(index);
    }

    public int getXValueColumnCount() {
        return this.xValueColumns.size();
    }

    public String[] getXValueColumn() {
        return this.xValueColumns.toArray(new String[this.xValueColumns.size()]);
    }

    public void setXValueColumn(String[] fields) {
        this.xValueColumns.clear();
        this.xValueColumns.addAll(Arrays.asList(fields));
    }

    public void setYValueColumn(int index, String field) {
        if (this.yValueColumns.size() == index) {
            this.yValueColumns.add(field);
        } else {
            this.yValueColumns.set(index, field);
        }
    }

    public String getYValueColumn(int index) {
        return this.yValueColumns.get(index);
    }

    public int getYValueColumnCount() {
        return this.yValueColumns.size();
    }

    public String[] getYValueColumn() {
        return this.yValueColumns.toArray(new String[this.yValueColumns.size()]);
    }

    public void setYValueColumn(String[] fields) {
        this.yValueColumns.clear();
        this.yValueColumns.addAll(Arrays.asList(fields));
    }

    @Override
    public Expression getInstance() {
        XYSeriesCollector expression = (XYSeriesCollector)super.getInstance();
        expression.xValueColumns = (ArrayList)this.xValueColumns.clone();
        expression.yValueColumns = (ArrayList)this.yValueColumns.clone();
        expression.seriesSequenceMap = new HashMap();
        return expression;
    }

    @Override
    protected void buildDataset() {
        XYSeriesCollection xySeriesDataset = (XYSeriesCollection)this.getDataSet();
        List seriesList = xySeriesDataset.getSeries();
        HashMap<Comparable, XYSeries> seriesMap = this.getSeriesMap();
        if (seriesMap.isEmpty()) {
            for (int i = 0; i < seriesList.size(); ++i) {
                XYSeries series = (XYSeries)seriesList.get(i);
                seriesMap.put(series.getKey(), series);
            }
        }
        int maxIndex = Math.min(this.xValueColumns.size(), this.yValueColumns.size());
        for (int i = 0; i < maxIndex; ++i) {
            Comparable seriesName = this.querySeriesValue(i);
            Object xValueObject = this.getDataRow().get(this.xValueColumns.get(i));
            Object yValueObject = this.getDataRow().get(this.yValueColumns.get(i));
            if (!(xValueObject instanceof Number)) continue;
            Number xValue = (Number)xValueObject;
            Number yValue = yValueObject instanceof Number ? (Number)((Number)yValueObject) : (Number)null;
            XYSeries series = seriesMap.get(seriesName);
            if (series == null) {
                series = new XYSeries(seriesName);
                xySeriesDataset.addSeries(series);
                seriesMap.put(seriesName, series);
            }
            series.add(xValue, yValue, false);
        }
    }

    public void reportDone(ReportEvent event) {
        this.seriesSequenceMap.clear();
    }
}

