/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.caching.spi;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import org.pentaho.caching.api.Constants;

public abstract class AbstractCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> managedCacheMap;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public AbstractCacheManager() {
        this.managedCacheMap = Maps.newConcurrentMap();
    }

    public CachingProvider getCachingProvider() {
        return null;
    }

    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"Cache manager is closed");
        Cache<K, V> cache = null;
        try {
            cache = this.newCache(cacheName, configuration);
            if (this.managedCacheMap.putIfAbsent(cacheName, cache) == null) {
                return cache;
            }
            throw new CacheException("Cache already exists: " + cacheName);
        }
        catch (Throwable t) {
            if (cache != null) {
                cache.close();
            }
            throw Throwables.propagate((Throwable)t);
        }
    }

    protected abstract <K, V, C extends Configuration<K, V>> Cache<K, V> newCache(String var1, C var2);

    public URI getURI() {
        return URI.create(this.getClass().getName());
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Properties getProperties() {
        return new Properties();
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, Object.class, Object.class);
    }

    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"Cache manager is closed");
        Preconditions.checkNotNull((Object)cacheName, (Object)"Cache Name can not be null");
        Preconditions.checkNotNull(keyType, (Object)"Key Type can not be null");
        Preconditions.checkNotNull(valueType, (Object)"Value Type can not be null");
        Cache cache = (Cache)this.managedCacheMap.get(cacheName);
        if (cache == null) {
            return null;
        }
        Configuration configuration = cache.getConfiguration(Configuration.class);
        Preconditions.checkArgument((boolean)keyType.equals(configuration.getKeyType()), (Object)"Key Type is incompatible");
        Preconditions.checkArgument((boolean)valueType.equals(configuration.getValueType()), (Object)"Value Type is incompatible");
        return cache;
    }

    public Iterable<String> getCacheNames() {
        return this.managedCacheMap.keySet();
    }

    public void destroyCache(String cacheName) {
        Cache cache = (Cache)this.managedCacheMap.remove(cacheName);
        if (cache != null) {
            cache.close();
        }
    }

    public void enableManagement(String cacheName, boolean enabled) {
    }

    public void enableStatistics(String cacheName, boolean enabled) {
    }

    public void close() {
        this.closed.set(true);
        for (String cacheName : this.managedCacheMap.keySet()) {
            this.destroyCache(cacheName);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public <T> T unwrap(Class<T> clazz) {
        return Constants.unwrap(this, clazz);
    }
}

