/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUBTRACT
extends EvalFunc<DataBag> {
    @Override
    public DataBag exec(Tuple input) throws IOException {
        if (input.size() != 2) {
            throw new ExecException("SUBTRACT expected two inputs but received " + input.size() + " inputs.");
        }
        DataBag bag1 = SUBTRACT.toDataBag(input.get(0));
        DataBag bag2 = SUBTRACT.toDataBag(input.get(1));
        return SUBTRACT.subtract(bag1, bag2);
    }

    private static String classNameOf(Object o) {
        return o == null ? "null" : o.getClass().getSimpleName();
    }

    private static DataBag toDataBag(Object o) throws ExecException {
        if (o == null) {
            return BagFactory.getInstance().newDefaultBag();
        }
        if (o instanceof DataBag) {
            return (DataBag)o;
        }
        throw new ExecException(String.format("Expecting input to be DataBag only but was '%s'", SUBTRACT.classNameOf(o)));
    }

    private static DataBag subtract(DataBag bag1, DataBag bag2) {
        DataBag subtractBag2FromBag1 = BagFactory.getInstance().newDefaultBag();
        Set<Tuple> set1 = SUBTRACT.toSet(bag1);
        Iterator<Tuple> bag2Iterator = bag2.iterator();
        while (bag2Iterator.hasNext()) {
            set1.remove(bag2Iterator.next());
        }
        for (Tuple tuple : set1) {
            subtractBag2FromBag1.add(tuple);
        }
        return subtractBag2FromBag1;
    }

    private static Set<Tuple> toSet(DataBag bag) {
        HashSet<Tuple> set = new HashSet<Tuple>();
        Iterator<Tuple> iterator = bag.iterator();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

