/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.OMD_O03_DIET;
import ca.uhn.hl7v2.model.v26.group.OMD_O03_TIMING_DIET;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OMD_O03_ORDER_DIET
extends AbstractGroup {
    public OMD_O03_ORDER_DIET(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(OMD_O03_TIMING_DIET.class, false, true);
            this.add(OMD_O03_DIET.class, false, false);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating OMD_O03_ORDER_DIET - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMD_O03_TIMING_DIET getTIMING_DIET() {
        OMD_O03_TIMING_DIET ret = null;
        try {
            ret = (OMD_O03_TIMING_DIET)this.get("TIMING_DIET");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMD_O03_TIMING_DIET getTIMING_DIET(int rep) {
        OMD_O03_TIMING_DIET ret = null;
        try {
            ret = (OMD_O03_TIMING_DIET)this.get("TIMING_DIET", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMING_DIETReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING_DIET").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTIMING_DIET(OMD_O03_TIMING_DIET structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_DIET", (Structure)structure, rep);
    }

    public OMD_O03_TIMING_DIET insertTIMING_DIET(int rep) throws HL7Exception {
        return (OMD_O03_TIMING_DIET)super.insertRepetition("TIMING_DIET", rep);
    }

    public OMD_O03_TIMING_DIET removeTIMING_DIET(int rep) throws HL7Exception {
        return (OMD_O03_TIMING_DIET)super.removeRepetition("TIMING_DIET", rep);
    }

    public OMD_O03_DIET getDIET() {
        OMD_O03_DIET ret = null;
        try {
            ret = (OMD_O03_DIET)this.get("DIET");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

