/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.sun.jersey.multipart.FormDataParam;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.channels.IllegalSelectorException;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IContentGenerator;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.mimetype.IPlatformMimeResolver;
import org.pentaho.platform.api.repository2.unified.Converter;
import org.pentaho.platform.api.repository2.unified.IRepositoryContentConverterHandler;
import org.pentaho.platform.api.repository2.unified.IRepositoryVersionManager;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryAccessDeniedException;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importexport.ExportException;
import org.pentaho.platform.plugin.services.importexport.Exporter;
import org.pentaho.platform.repository.RepositoryDownloadWhitelist;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.webservices.DefaultUnifiedRepositoryWebService;
import org.pentaho.platform.repository2.unified.webservices.FileVersioningConfiguration;
import org.pentaho.platform.repository2.unified.webservices.LocaleMapDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileTreeDto;
import org.pentaho.platform.repository2.unified.webservices.StringKeyStringValueDto;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.SchedulerResource;
import org.pentaho.platform.web.http.api.resources.Setting;
import org.pentaho.platform.web.http.api.resources.StringListWrapper;
import org.pentaho.platform.web.http.api.resources.services.FileService;
import org.pentaho.platform.web.http.api.resources.utils.FileUtils;
import org.pentaho.platform.web.http.messages.Messages;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

@Path(value="/repo/files/")
public class FileResource
extends AbstractJaxRSResource {
    public static final String PATH_SEPARATOR = "/";
    public static final String APPLICATION_ZIP = "application/zip";
    protected static final Log logger = LogFactory.getLog(FileResource.class);
    protected FileService fileService = new FileService();
    protected SchedulerResource schedulerResource = new SchedulerResource();
    protected RepositoryDownloadWhitelist whitelist;
    protected static IUnifiedRepository repository;
    protected static DefaultUnifiedRepositoryWebService repoWs;
    protected static IAuthorizationPolicy policy;
    IRepositoryContentConverterHandler converterHandler;
    Map<String, Converter> converters;
    protected IPlatformMimeResolver mimeResolver;

    public FileResource() {
    }

    public FileResource(HttpServletResponse httpServletResponse) {
        this();
        this.httpServletResponse = httpServletResponse;
    }

    public static String idToPath(String pathId) {
        return FileUtils.idToPath(pathId);
    }

    @GET
    @Path(value="/backup")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully exported the existing Pentaho System"), @ResponseCode(code=403, condition="User does not have administrative permissions"), @ResponseCode(code=500, condition="Failure to complete the export.")})
    public Response systemBackup(@HeaderParam(value="user-agent") String userAgent) {
        try {
            FileService.DownloadFileWrapper wrapper = this.fileService.systemBackup(userAgent);
            return this.buildZipOkResponse(wrapper);
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ExportException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SecurityException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    @POST
    @Path(value="/systemRestore")
    @Consumes(value={"multipart/form-data"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully imported the Pentaho System"), @ResponseCode(code=403, condition="User does not have administrative permissions"), @ResponseCode(code=500, condition="Failure to complete the import.")})
    public Response systemRestore(@FormDataParam(value="fileUpload") InputStream fileUpload, @FormDataParam(value="overwriteFile") String overwriteFile) {
        try {
            this.fileService.systemRestore(fileUpload, overwriteFile);
            return Response.ok().build();
        }
        catch (PlatformImportException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SecurityException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    @PUT
    @Path(value="/delete")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully moved file to trash."), @ResponseCode(code=500, condition="Failure move the file to the trash.")})
    public Response doDeleteFiles(String params) {
        try {
            this.fileService.doDeleteFiles(params);
            return this.buildOkResponse();
        }
        catch (Throwable t) {
            return this.buildServerErrorResponse(t);
        }
    }

    @PUT
    @Path(value="/deletepermanent")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully deleted the comma seperated list of fileIds from the system."), @ResponseCode(code=403, condition="Failure to delete the file due to path not found.")})
    public Response doDeleteFilesPermanent(String params) {
        try {
            this.fileService.doDeleteFilesPermanent(params);
            return this.buildOkResponse();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return this.buildServerErrorResponse(t);
        }
    }

    @PUT
    @Path(value="{pathId : .+}/move")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully moved the file."), @ResponseCode(code=403, condition="Failure to move the file due to path not found."), @ResponseCode(code=500, condition="Failure to move the file.")})
    public Response doMove(@PathParam(value="pathId") String destPathId, String params) {
        try {
            this.fileService.doMoveFiles(destPathId, params);
            return this.buildOkResponse();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)Messages.getInstance().getErrorString("FileResource.DESTINATION_PATH_UNKNOWN", new Object[]{destPathId}), (Throwable)e);
            return this.buildStatusResponse(Response.Status.NOT_FOUND);
        }
        catch (Throwable t) {
            logger.error((Object)Messages.getInstance().getString("SystemResource.FILE_MOVE_FAILED"), t);
            return this.buildStatusResponse(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="/restore")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully restored the file."), @ResponseCode(code=307, condition="Cannot restore in origin folder, can restore in home folder without conflicts"), @ResponseCode(code=403, condition="Failure to Restore the file."), @ResponseCode(code=409, condition="Cannot restore in origin folder, cannot restore in home folder without conflicts")})
    public Response doRestore(String params, @QueryParam(value="overwriteMode") Integer mode) {
        if (mode != null) {
            boolean success = this.fileService.doRestoreFilesInHomeDir(params, mode);
            return success ? this.buildOkResponse() : this.buildStatusResponse(Response.Status.INTERNAL_SERVER_ERROR);
        }
        try {
            this.fileService.doRestoreFiles(params);
            return this.buildOkResponse();
        }
        catch (UnifiedRepositoryAccessDeniedException e) {
            if (!this.fileService.canRestoreToFolderWithNoConflicts(this.getUserHomeFolder(), params)) {
                return this.buildStatusResponse(Response.Status.CONFLICT);
            }
            return this.buildStatusResponse(Response.Status.NOT_ACCEPTABLE);
        }
        catch (InternalError e) {
            logger.error((Object)Messages.getInstance().getString("FileResource.FILE_GET_LOCALES"), (Throwable)e);
            return this.buildStatusResponse(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="{pathId : .+}")
    @Consumes(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created the file."), @ResponseCode(code=403, condition="Failure to create the file due to permissions, file already exists, or invalid path id.")})
    public Response createFile(@PathParam(value="pathId") String pathId, InputStream fileContents) {
        try {
            this.checkCorrectExtension(pathId);
            this.fileService.createFile(this.httpServletRequest.getCharacterEncoding(), pathId, fileContents);
            return this.buildOkResponse();
        }
        catch (Throwable t) {
            return this.buildServerErrorResponse(t);
        }
    }

    @PUT
    @Path(value="{pathId : .+}/children")
    @Consumes(value={"text/plain"})
    @Facet(name="Unsupported")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully copied the file."), @ResponseCode(code=500, condition="Failure to Copy file due to exception while getting file with id fileid...")})
    public Response doCopyFiles(@PathParam(value="pathId") String pathId, @QueryParam(value="mode") Integer mode, String params) {
        try {
            this.fileService.doCopyFiles(pathId, mode, params);
        }
        catch (IllegalArgumentException e) {
            return this.buildStatusResponse(Response.Status.FORBIDDEN);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getInstance().getString("SystemResource.GENERAL_ERROR"), (Throwable)e);
            return this.buildSafeHtmlServerErrorResponse(e);
        }
        return this.buildOkResponse();
    }

    @GET
    @Path(value="{pathId : .+}")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully get the file or directory."), @ResponseCode(code=404, condition="Failed to find the file or resource."), @ResponseCode(code=500, condition="Failed to open content.")})
    public Response doGetFileOrDir(@PathParam(value="pathId") String pathId) {
        try {
            FileService.RepositoryFileToStreamWrapper wrapper = this.fileService.doGetFileOrDir(pathId);
            return this.buildOkResponse(wrapper);
        }
        catch (FileNotFoundException fileNotFound) {
            return this.buildStatusResponse(Response.Status.NOT_FOUND);
        }
        catch (IllegalArgumentException illegalArgument) {
            return this.buildStatusResponse(Response.Status.FORBIDDEN);
        }
    }

    public Response doGetDirAsZip(@PathParam(value="pathId") String pathId) {
        String path = this.fileService.idToPath(pathId);
        if (!this.isPathValid(path)) {
            return this.buildStatusResponse(Response.Status.FORBIDDEN);
        }
        if (!FileResource.getPolicy().isAllowed("org.pentaho.security.publish")) {
            return this.buildStatusResponse(Response.Status.FORBIDDEN);
        }
        RepositoryFile repoFile = FileResource.getRepository().getFile(path);
        if (repoFile == null) {
            return this.buildStatusResponse(Response.Status.NOT_FOUND);
        }
        return this.doGetDirAsZip(repoFile);
    }

    public Response doGetDirAsZip(RepositoryFile repositoryFile) {
        FileInputStream is;
        String path = repositoryFile.getPath();
        try {
            Exporter exporter = this.getExporter();
            exporter.setRepoPath(path);
            exporter.setRepoWs(repoWs);
            File zipFile = exporter.doExportAsZip(repositoryFile);
            is = this.getFileInputStream(zipFile);
        }
        catch (Exception e) {
            return this.buildServerErrorResponse(e.toString());
        }
        StreamingOutput streamingOutput = this.getStreamingOutput(is);
        return this.buildOkResponse(streamingOutput, APPLICATION_ZIP);
    }

    @GET
    @Path(value="{pathId : .+}/parameterizable")
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully get the file or directory."), @ResponseCode(code=404, condition="Failed to find the file or resource.")})
    public String doIsParameterizable(@PathParam(value="pathId") String pathId) throws FileNotFoundException {
        boolean hasParameterUi = false;
        RepositoryFile repositoryFile = FileResource.getRepository().getFile(this.fileService.idToPath(pathId));
        if (repositoryFile != null) {
            try {
                hasParameterUi = this.hasParameterUi(repositoryFile);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        boolean hasParameters = false;
        if (hasParameterUi) {
            try {
                IContentGenerator parameterContentGenerator = this.getContentGenerator(repositoryFile);
                if (parameterContentGenerator != null) {
                    ByteArrayOutputStream outputStream = this.getByteArrayOutputStream();
                    parameterContentGenerator.setOutputHandler((IOutputHandler)new SimpleOutputHandler((OutputStream)outputStream, false));
                    parameterContentGenerator.setMessagesList(new ArrayList());
                    HashMap<String, SimpleParameterProvider> parameterProviders = new HashMap<String, SimpleParameterProvider>();
                    SimpleParameterProvider parameterProvider = this.getSimpleParameterProvider();
                    parameterProvider.setParameter("path", this.encode(repositoryFile.getPath()));
                    parameterProvider.setParameter("renderMode", "PARAMETER");
                    parameterProviders.put("request", parameterProvider);
                    parameterContentGenerator.setParameterProviders(parameterProviders);
                    parameterContentGenerator.setSession(this.getSession());
                    parameterContentGenerator.createContent();
                    if (outputStream.size() > 0) {
                        Document document = this.parseText(outputStream.toString());
                        List nodes = document.selectNodes("parameters/parameter");
                        for (int i = 0; i < nodes.size() && !hasParameters; ++i) {
                            Element elem = (Element)nodes.get(i);
                            if (elem.attributeValue("name").equalsIgnoreCase("output-target") && elem.attributeValue("is-mandatory").equalsIgnoreCase("true")) {
                                hasParameters = true;
                                continue;
                            }
                            Element attrib = (Element)elem.selectSingleNode("attribute[@namespace='http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core' and @name='role']");
                            if (attrib != null && "system".equals(attrib.attributeValue("value"))) continue;
                            hasParameters = true;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)this.getMessagesInstance().getString("FileResource.PARAM_FAILURE", new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        return Boolean.toString(hasParameters);
    }

    @GET
    @Path(value="{pathId : .+}/download")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful download."), @ResponseCode(code=400, condition="Usually a bad pathId."), @ResponseCode(code=403, condition="pathId points at a file the user doesn't have access to."), @ResponseCode(code=404, condition="File not found."), @ResponseCode(code=500, condition="Failed to download file for another reason.")})
    public Response doGetFileOrDirAsDownload(@HeaderParam(value="user-agent") String userAgent, @PathParam(value="pathId") String pathId, @QueryParam(value="withManifest") String strWithManifest) {
        try {
            FileService.DownloadFileWrapper wrapper = this.fileService.doGetFileOrDirAsDownload(userAgent, pathId, strWithManifest);
            return this.buildZipOkResponse(wrapper);
        }
        catch (InvalidParameterException e) {
            logger.error((Object)this.getMessagesInstance().getString("FileResource.EXPORT_FAILED", new Object[]{e.getMessage()}), (Throwable)e);
            return this.buildStatusResponse(Response.Status.BAD_REQUEST);
        }
        catch (IllegalSelectorException e) {
            logger.error((Object)this.getMessagesInstance().getString("FileResource.EXPORT_FAILED", new Object[]{e.getMessage()}), (Throwable)e);
            return this.buildStatusResponse(Response.Status.FORBIDDEN);
        }
        catch (GeneralSecurityException e) {
            logger.error((Object)this.getMessagesInstance().getString("FileResource.EXPORT_FAILED", new Object[]{e.getMessage()}), (Throwable)e);
            return this.buildStatusResponse(Response.Status.FORBIDDEN);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)this.getMessagesInstance().getString("FileResource.EXPORT_FAILED", new Object[]{e.getMessage()}), (Throwable)e);
            return this.buildStatusResponse(Response.Status.NOT_FOUND);
        }
        catch (Throwable e) {
            logger.error((Object)this.getMessagesInstance().getString("FileResource.EXPORT_FAILED", new Object[]{pathId + " " + e.getMessage()}), e);
            return this.buildStatusResponse(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{pathId : .+}/inline")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved file."), @ResponseCode(code=403, condition="Failed to retrieve file due to permission problem."), @ResponseCode(code=404, condition="Failed to retrieve file due because file was not found."), @ResponseCode(code=500, condition="Failed to download file because of some other error.")})
    public Response doGetFileAsInline(@PathParam(value="pathId") String pathId) {
        try {
            FileService.RepositoryFileToStreamWrapper wrapper = this.fileService.doGetFileAsInline(pathId);
            return this.buildOkResponse(wrapper);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)this.getMessagesInstance().getString("SystemResource.GENERAL_ERROR"), (Throwable)e);
            return this.buildStatusResponse(Response.Status.FORBIDDEN);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)this.getMessagesInstance().getString("SystemResource.GENERAL_ERROR"), (Throwable)e);
            return this.buildStatusResponse(Response.Status.NOT_FOUND);
        }
        catch (InternalError e) {
            logger.error((Object)this.getMessagesInstance().getString("SystemResource.GENERAL_ERROR"), (Throwable)e);
            return this.buildStatusResponse(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="{pathId : .+}/acl")
    @Consumes(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully saved file."), @ResponseCode(code=403, condition="Failed to save acls due to missing or incorrect properties."), @ResponseCode(code=400, condition="Failed to save acls due to malformed xml."), @ResponseCode(code=500, condition="Failed to save acls due to another error.")})
    public Response setFileAcls(@PathParam(value="pathId") String pathId, RepositoryFileAclDto acl) {
        try {
            this.fileService.setFileAcls(pathId, acl);
            return this.buildOkResponse();
        }
        catch (Exception exception) {
            logger.error((Object)this.getMessagesInstance().getString("SystemResource.GENERAL_ERROR"), (Throwable)exception);
            return this.buildStatusResponse(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="{pathId : .+}/creator")
    @Consumes(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved file."), @ResponseCode(code=500, condition="Failed to download file because of some other error.")})
    @Facet(name="Unsupported")
    public Response doSetContentCreator(@PathParam(value="pathId") String pathId, RepositoryFileDto contentCreator) {
        try {
            this.fileService.doSetContentCreator(pathId, contentCreator);
            return this.buildOkResponse();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)this.getMessagesInstance().getErrorString("FileResource.FILE_NOT_FOUND", new Object[]{pathId}), (Throwable)e);
            return this.buildStatusResponse(Response.Status.NOT_FOUND);
        }
        catch (Throwable t) {
            logger.error((Object)this.getMessagesInstance().getString("SystemResource.GENERAL_ERROR"), t);
            return this.buildStatusResponse(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{pathId : .+}/locales")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved locale information."), @ResponseCode(code=404, condition="Failed to retrieve locales because the file was not found."), @ResponseCode(code=500, condition="Unable to retrieve locales due to some other error.")})
    public List<LocaleMapDto> doGetFileLocales(@PathParam(value="pathId") String pathId) {
        ArrayList<LocaleMapDto> locales = new ArrayList();
        try {
            locales = this.fileService.doGetFileLocales(pathId);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)this.getMessagesInstance().getErrorString("FileResource.FILE_NOT_FOUND", new Object[]{pathId}), (Throwable)e);
        }
        catch (Throwable t) {
            logger.error((Object)this.getMessagesInstance().getString("SystemResource.GENERAL_ERROR"), t);
        }
        return locales;
    }

    @GET
    @Path(value="{pathId : .+}/localeProperties")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved locale properties."), @ResponseCode(code=500, condition="Unable to retrieve locale properties due to some other error.")})
    public List<StringKeyStringValueDto> doGetLocaleProperties(@PathParam(value="pathId") String pathId, @QueryParam(value="locale") String locale) {
        return this.fileService.doGetLocaleProperties(pathId, locale);
    }

    @PUT
    @Path(value="{pathId : .+}/localeProperties")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully updated locale properties."), @ResponseCode(code=500, condition="Unable to update locale properties due to some other error.")})
    public Response doSetLocaleProperties(@PathParam(value="pathId") String pathId, @QueryParam(value="locale") String locale, List<StringKeyStringValueDto> properties) {
        try {
            this.fileService.doSetLocaleProperties(pathId, locale, properties);
            return Response.ok().build();
        }
        catch (Throwable t) {
            return Response.serverError().entity((Object)t.getMessage()).build();
        }
    }

    @PUT
    @Path(value="{pathId : .+}/deleteLocale")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully deleted the locale."), @ResponseCode(code=500, condition="Unable to delete the locale properties due to some other error.")})
    public Response doDeleteLocale(@PathParam(value="pathId") String pathId, @QueryParam(value="locale") String locale) {
        try {
            this.fileService.doDeleteLocale(pathId, locale);
            return this.buildOkResponse();
        }
        catch (Throwable t) {
            return this.buildServerErrorResponse(t);
        }
    }

    @GET
    @Path(value="/properties")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the properties of the root directory."), @ResponseCode(code=404, condition="Unable to retrieve the properties of the root directory due to file not found error."), @ResponseCode(code=500, condition="Unable to retrieve the properties of the root directory due to some other error.")})
    public RepositoryFileDto doGetRootProperties() {
        return this.fileService.doGetRootProperties();
    }

    @GET
    @Path(value="{pathId : .+}/canAccessMap")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the permissions of the file."), @ResponseCode(code=500, condition="Unable to retrieve the permissions of the file due to some other error.")})
    public List<Setting> doGetCanAccessList(@PathParam(value="pathId") String pathId, @QueryParam(value="permissions") String permissions) {
        return this.fileService.doGetCanAccessList(pathId, permissions);
    }

    @POST
    @Path(value="/pathsAccessList")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the permissions of the given paths."), @ResponseCode(code=500, condition="Unable to retrieve the permissions of the given paths due to some other error.")})
    public List<Setting> doGetPathsAccessList(StringListWrapper pathsWrapper) {
        return this.fileService.doGetPathsAccessList(pathsWrapper);
    }

    @GET
    @Path(value="{pathId : .+}/canAccess")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the permissions of the given paths."), @ResponseCode(code=500, condition="Unable to retrieve the permissions of the given paths due to some other error.")})
    public String doGetCanAccess(@PathParam(value="pathId") String pathId, @QueryParam(value="permissions") String permissions) {
        return this.fileService.doGetCanAccess(pathId, permissions);
    }

    @GET
    @Path(value="/canAdminister")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully returns a boolean value, either true or false")})
    public String doGetCanAdminister() {
        try {
            return this.fileService.doCanAdminister() ? "true" : "false";
        }
        catch (Exception e) {
            return "false";
        }
    }

    @GET
    @Path(value="/reservedCharacters")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully returns a list of repositroy reserved characters")})
    public Response doGetReservedChars() {
        StringBuffer buffer = this.fileService.doGetReservedChars();
        return this.buildPlainTextOkResponse(buffer.toString());
    }

    @GET
    @Path(value="/reservedCharactersDisplay")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully returns a list of repositroy reserved characters")})
    public Response doGetReservedCharactersDisplay() {
        StringBuffer buffer = this.fileService.doGetReservedCharactersDisplay();
        return this.buildPlainTextOkResponse(buffer.toString());
    }

    @GET
    @Path(value="/canCreate")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully returns true or false depending on the users permissions")})
    public String doGetCanCreate() {
        return this.fileService.doGetCanCreate();
    }

    @GET
    @Path(value="{pathId : .+}/acl")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Returns the requested file permissions in xml or json format"), @ResponseCode(code=500, condition="File failed to be retrieved. This could be caused by an invalid path, or the file does not exist.")})
    public RepositoryFileAclDto doGetFileAcl(@PathParam(value="pathId") String pathId) {
        return this.fileService.doGetFileAcl(pathId);
    }

    @GET
    @Path(value="{pathId : .+}/properties")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the properties for a file."), @ResponseCode(code=204, condition="Invalid file path.")})
    public RepositoryFileDto doGetProperties(@PathParam(value="pathId") String pathId) {
        try {
            return this.fileService.doGetProperties(pathId);
        }
        catch (FileNotFoundException fileNotFound) {
            logger.error((Object)this.getMessagesInstance().getString("SystemResource.GENERAL_ERROR"), (Throwable)fileNotFound);
            return null;
        }
    }

    @GET
    @Path(value="{pathId : .+}/creator")
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the content creator for a file."), @ResponseCode(code=403, condition="Failure to move the file due to path not found.")})
    public RepositoryFileDto doGetContentCreator(@PathParam(value="pathId") String pathId) {
        try {
            return this.fileService.doGetContentCreator(pathId);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @GET
    @Path(value="{pathId : .+}/generatedContent")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of RepositoryFileDto objects."), @ResponseCode(code=200, condition="Empty list of RepositoryFileDto objects.")})
    public List<RepositoryFileDto> doGetGeneratedContent(@PathParam(value="pathId") String pathId) {
        List<RepositoryFileDto> repositoryFileDtoList = new ArrayList<RepositoryFileDto>();
        try {
            repositoryFileDtoList = this.fileService.doGetGeneratedContent(pathId);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Throwable t) {
            logger.error((Object)this.getMessagesInstance().getString("FileResource.GENERATED_CONTENT_FAILED", new Object[]{pathId}), t);
        }
        return repositoryFileDtoList;
    }

    @GET
    @Path(value="{pathId : .+}/generatedContentForUser")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of RepositoryFileDto objects."), @ResponseCode(code=200, condition="Empty list of RepositoryFileDto objects."), @ResponseCode(code=500, condition="Server Error.")})
    public List<RepositoryFileDto> doGetGeneratedContentForUser(@PathParam(value="pathId") String pathId, @QueryParam(value="user") String user) {
        List<RepositoryFileDto> repositoryFileDtoList = new ArrayList<RepositoryFileDto>();
        try {
            repositoryFileDtoList = this.fileService.doGetGeneratedContent(pathId, user);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Throwable t) {
            logger.error((Object)this.getMessagesInstance().getString("FileResource.GENERATED_CONTENT_FOR_USER_FAILED", new Object[]{pathId, user}), t);
        }
        return repositoryFileDtoList;
    }

    @GET
    @Path(value="/tree")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of files from root of the repository."), @ResponseCode(code=404, condition="Invalid parameters."), @ResponseCode(code=500, condition="Server Error.")})
    public RepositoryFileTreeDto doGetRootTree(@QueryParam(value="depth") Integer depth, @QueryParam(value="filter") String filter, @QueryParam(value="showHidden") Boolean showHidden, @DefaultValue(value="false") @QueryParam(value="includeAcls") Boolean includeAcls) {
        return this.fileService.doGetTree(PATH_SEPARATOR, depth, filter, showHidden, includeAcls);
    }

    @GET
    @Path(value="/children")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of child files from root of the repository."), @ResponseCode(code=500, condition="Server Error.")})
    public List<RepositoryFileDto> doGetRootChildren(@QueryParam(value="filter") String filter, @QueryParam(value="showHidden") Boolean showHidden, @DefaultValue(value="false") @QueryParam(value="includeAcls") Boolean includeAcls) {
        return this.fileService.doGetChildren(PATH_SEPARATOR, filter, showHidden, includeAcls);
    }

    @GET
    @Path(value="{pathId : .+}/tree")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of files from root of the repository."), @ResponseCode(code=404, condition="Invalid parameters."), @ResponseCode(code=500, condition="Server Error.")})
    public RepositoryFileTreeDto doGetTree(@PathParam(value="pathId") String pathId, @QueryParam(value="depth") Integer depth, @QueryParam(value="filter") String filter, @QueryParam(value="showHidden") Boolean showHidden, @DefaultValue(value="false") @QueryParam(value="includeAcls") Boolean includeAcls) {
        return this.fileService.doGetTree(pathId, depth, filter, showHidden, includeAcls);
    }

    @GET
    @Path(value="{pathId : .+}/children")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of child files from selected repository path of the repository."), @ResponseCode(code=500, condition="Server Error.")})
    public List<RepositoryFileDto> doGetChildren(@PathParam(value="pathId") String pathId, @QueryParam(value="filter") String filter, @QueryParam(value="showHidden") Boolean showHidden, @DefaultValue(value="false") @QueryParam(value="includeAcls") Boolean includeAcls) {
        return this.fileService.doGetChildren(pathId, filter, showHidden, includeAcls);
    }

    @GET
    @Path(value="/deleted")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of files from trash folder of the repository."), @ResponseCode(code=500, condition="Server Error.")})
    public List<RepositoryFileDto> doGetDeletedFiles() {
        return this.fileService.doGetDeletedFiles();
    }

    @GET
    @Path(value="{pathId : .+}/metadata")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved metadata."), @ResponseCode(code=403, condition="Invalid path."), @ResponseCode(code=500, condition="Server Error.")})
    public List<StringKeyStringValueDto> doGetMetadata(@PathParam(value="pathId") String pathId) {
        try {
            return this.fileService.doGetMetadata(pathId);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)this.getMessagesInstance().getErrorString("FileResource.FILE_UNKNOWN", new Object[]{pathId}), (Throwable)e);
            return null;
        }
    }

    @PUT
    @Path(value="{pathId : .+}/rename")
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully renamed file."), @ResponseCode(code=200, condition="File to be renamed does not exist.")})
    public Response doRename(@PathParam(value="pathId") String pathId, @QueryParam(value="newName") String newName) {
        try {
            JcrRepositoryFileUtils.checkName((String)newName);
            boolean success = this.fileService.doRename(pathId, newName);
            if (success) {
                return this.buildOkResponse();
            }
            return this.buildOkResponse("File to be renamed does not exist");
        }
        catch (Throwable t) {
            return this.buildServerErrorResponse(t.getMessage());
        }
    }

    @PUT
    @Path(value="{pathId : .+}/metadata")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved metadata."), @ResponseCode(code=403, condition="Invalid path."), @ResponseCode(code=400, condition="Invalid payload."), @ResponseCode(code=500, condition="Server Error.")})
    public Response doSetMetadata(@PathParam(value="pathId") String pathId, List<StringKeyStringValueDto> metadata) {
        try {
            this.fileService.doSetMetadata(pathId, metadata);
            return this.buildOkResponse();
        }
        catch (GeneralSecurityException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED);
        }
        catch (Throwable t) {
            return this.buildServerErrorResponse(t.getMessage());
        }
    }

    @PUT
    @Path(value="{pathId : .+}/createDir")
    @Consumes(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created folder."), @ResponseCode(code=409, condition="Path already exists."), @ResponseCode(code=500, condition="Server Error.")})
    public Response doCreateDirs(@PathParam(value="pathId") String pathId) {
        try {
            if (this.fileService.doCreateDirSafe(pathId)) {
                return this.buildOkResponse();
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"couldNotCreateFolderDuplicate").build();
        }
        catch (Throwable t) {
            return this.buildServerErrorResponse(t.getMessage());
        }
    }

    @GET
    @Path(value="/generatedContentForSchedule")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully got the generated content for schedule")})
    public List<RepositoryFileDto> doGetGeneratedContentForSchedule(@QueryParam(value="lineageId") String lineageId) {
        return this.schedulerResource.doGetGeneratedContentForSchedule(lineageId);
    }

    @GET
    @Path(value="{pathId : .+}/versioningConfiguration")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully returns the versioning configuration")})
    public FileVersioningConfiguration doVersioningConfiguration(@PathParam(value="pathId") String pathId) {
        IRepositoryVersionManager repositoryVersionManager = (IRepositoryVersionManager)PentahoSystem.get(IRepositoryVersionManager.class);
        String path = FileUtils.idToPath(pathId);
        return new FileVersioningConfiguration(repositoryVersionManager.isVersioningEnabled(path), repositoryVersionManager.isVersionCommentEnabled(path));
    }

    protected boolean isPathValid(String path) {
        return this.fileService.isPathValid(path);
    }

    public RepositoryDownloadWhitelist getWhitelist() {
        if (this.whitelist == null) {
            this.whitelist = new RepositoryDownloadWhitelist();
        }
        return this.whitelist;
    }

    public void setWhitelist(RepositoryDownloadWhitelist whitelist) {
        this.whitelist = whitelist;
    }

    public static IAuthorizationPolicy getPolicy() {
        if (policy == null) {
            policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        }
        return policy;
    }

    public static IUnifiedRepository getRepository() {
        if (repository == null) {
            repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        }
        return repository;
    }

    public static DefaultUnifiedRepositoryWebService getRepoWs() {
        if (repoWs == null) {
            repoWs = new DefaultUnifiedRepositoryWebService();
        }
        return repoWs;
    }

    public void setConverterHandler(IRepositoryContentConverterHandler converterHandler) {
        this.converterHandler = converterHandler;
    }

    public void setMimeResolver(IPlatformMimeResolver mimeResolver) {
        this.mimeResolver = mimeResolver;
    }

    protected Response buildOkResponse() {
        return Response.ok().build();
    }

    protected Response buildOkResponse(String msg) {
        return Response.ok((Object)msg).build();
    }

    protected Response buildPlainTextOkResponse(String msg) {
        return Response.ok((Object)msg, (String)"text/plain").build();
    }

    protected Response buildStatusResponse(Response.Status status) {
        return Response.status((Response.Status)status).build();
    }

    protected Response buildServerErrorResponse(Throwable t) {
        return this.buildServerErrorResponse(t.getMessage());
    }

    protected Response buildServerErrorResponse(String msg) {
        return Response.serverError().entity((Object)msg).build();
    }

    protected Response buildSafeHtmlServerErrorResponse(Exception e) {
        return Response.serverError().entity((Object)new SafeHtmlBuilder().appendEscapedLines(e.getLocalizedMessage()).toSafeHtml().asString()).build();
    }

    protected Response buildOkResponse(FileService.RepositoryFileToStreamWrapper wrapper) {
        Response.ResponseBuilder builder = Response.ok((Object)wrapper.getOutputStream());
        if (wrapper.getMimetype() != null) {
            builder = Response.ok((Object)wrapper.getOutputStream(), (String)wrapper.getMimetype());
        }
        return builder.header("Content-Disposition", (Object)("inline; filename=\"" + wrapper.getRepositoryFile().getName() + "\"")).build();
    }

    protected Response buildZipOkResponse(FileService.DownloadFileWrapper wrapper) {
        return Response.ok((Object)wrapper.getOutputStream(), (String)"application/zip; charset=UTF-8").header("Content-Disposition", (Object)wrapper.getAttachment()).build();
    }

    protected Response buildOkResponse(Object o, String s) {
        return Response.ok((Object)o, (String)s).build();
    }

    protected Exporter getExporter() {
        return new Exporter(repository);
    }

    protected FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    protected StreamingOutput getStreamingOutput(final InputStream is) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                IOUtils.copy((InputStream)is, (OutputStream)output);
            }
        };
    }

    protected boolean hasParameterUi(RepositoryFile repositoryFile) {
        return ((IPluginManager)PentahoSystem.get(IPluginManager.class)).getContentGenerator(repositoryFile.getName().substring(repositoryFile.getName().lastIndexOf(46) + 1), "parameterUi") != null;
    }

    protected IContentGenerator getContentGenerator(RepositoryFile repositoryFile) {
        return ((IPluginManager)PentahoSystem.get(IPluginManager.class)).getContentGenerator(repositoryFile.getName().substring(repositoryFile.getName().lastIndexOf(46) + 1), "parameter");
    }

    protected SimpleParameterProvider getSimpleParameterProvider() {
        return new SimpleParameterProvider();
    }

    protected String encode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8");
    }

    protected IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }

    protected ByteArrayOutputStream getByteArrayOutputStream() {
        return new ByteArrayOutputStream();
    }

    protected Document parseText(String text) throws DocumentException {
        return DocumentHelper.parseText((String)text);
    }

    protected Messages getMessagesInstance() {
        return Messages.getInstance();
    }

    private void checkCorrectExtension(String fileName) {
        IRepositoryContentConverterHandler handler = (IRepositoryContentConverterHandler)PentahoSystem.get(IRepositoryContentConverterHandler.class);
        String ext = RepositoryFilenameUtils.getExtension((String)fileName);
        if (handler != null && handler.getConverter(ext) == null) {
            throw new IllegalArgumentException(Messages.getInstance().getString("FileResource.INCORRECT_EXTENSION", new Object[]{fileName}));
        }
    }

    protected String getUserHomeFolder() {
        return ClientRepositoryPaths.getUserHomeFolderPath((String)PentahoSessionHolder.getSession().getName());
    }
}

