/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.ICreateFeedbackParameterCallback;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.ActionSequenceJCRHelper;
import org.pentaho.platform.engine.services.actionsequence.ActionParameterSource;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.pentaho.platform.web.http.HttpOutputHandler;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.servlet.HttpMimeTypeListener;
import org.pentaho.platform.web.servlet.HttpServletRequestHandler;
import org.pentaho.platform.web.servlet.ServletBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SolutionEngineInteractivityService
extends ServletBase {
    private static final Log logger = LogFactory.getLog(SolutionEngineInteractivityService.class);
    protected Map xformFields = new HashMap();

    @Override
    public Log getLogger() {
        return logger;
    }

    protected boolean doMessages(HttpServletRequest request) {
        return "true".equalsIgnoreCase(request.getParameter("debug"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleActionRequest(HttpServletRequest request, HttpServletResponse response, HttpOutputHandler outputHandler, HttpServletRequestHandler requestHandler, IParameterProvider requestParameters, ByteArrayOutputStream outputStream, IContentItem contentItem) throws ServletException, IOException {
        IRuntimeContext runtime = null;
        try {
            final Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            final Element root = document.createElement("action_sequence_info");
            document.appendChild(root);
            requestHandler.setCreateFeedbackParameterCallback(new ICreateFeedbackParameterCallback(){

                public void createFeedbackParameter(IRuntimeContext runtimeContext, String fieldName, String displayName, String hint, Object defaultValues, List values, Map dispNames, String displayStyle, boolean optional, boolean visible) {
                    Element valueElement;
                    Element valuesElement;
                    Element parameterElement = document.createElement("parameter");
                    parameterElement.setAttribute("name", fieldName);
                    parameterElement.setAttribute("display-name", displayName);
                    parameterElement.setAttribute("display-style", displayStyle);
                    parameterElement.setAttribute("hint", "" + hint);
                    parameterElement.setAttribute("optional", "" + optional);
                    parameterElement.setAttribute("visible", "" + visible);
                    try {
                        IActionParameter actionParameter = runtimeContext.getInputParameter(fieldName);
                        if (actionParameter != null) {
                            List variables = actionParameter.getVariables();
                            for (int i = 0; variables != null && i < variables.size(); ++i) {
                                Object var = variables.get(i);
                                if (var instanceof ActionParameterSource) {
                                    String sourceName = ((ActionParameterSource)var).getSourceName();
                                    String sourceValue = ((ActionParameterSource)var).getValue();
                                    parameterElement.setAttribute("source-name", "" + sourceName);
                                    parameterElement.setAttribute("source-value", "" + sourceValue);
                                    continue;
                                }
                                System.out.println(var);
                            }
                        }
                    }
                    catch (Exception actionParameter) {
                        // empty catch block
                    }
                    root.appendChild(parameterElement);
                    if (values != null) {
                        valuesElement = document.createElement("values");
                        for (Object value : values) {
                            valueElement = document.createElement("value");
                            valueElement.setAttribute("value", "" + value);
                            if (dispNames != null && dispNames.containsKey(value)) {
                                valueElement.setAttribute("display-name", "" + dispNames.get(value));
                            }
                            valuesElement.appendChild(valueElement);
                        }
                        parameterElement.appendChild(valuesElement);
                    }
                    if (defaultValues != null) {
                        valuesElement = document.createElement("selected-values");
                        if (defaultValues instanceof List) {
                            for (Object value : (List)defaultValues) {
                                valueElement = document.createElement("value");
                                valueElement.setAttribute("value", "" + value);
                                valuesElement.appendChild(valueElement);
                            }
                        } else {
                            Element valueElement2 = document.createElement("value");
                            valueElement2.setAttribute("value", "" + defaultValues);
                            valuesElement.appendChild(valueElement2);
                        }
                        parameterElement.appendChild(valuesElement);
                    }
                }
            });
            runtime = requestHandler.handleActionRequest(0, 0);
            root.setAttribute("is-prompt-pending", "" + runtime.isPromptPending());
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new StringWriter());
            TransformerFactory.newInstance().newTransformer().transform(source, result);
            String theXML = result.getWriter().toString();
            response.setContentType("text/xml");
            response.getOutputStream().write(theXML.getBytes());
            response.getOutputStream().close();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        finally {
            if (runtime != null) {
                runtime.dispose();
            }
        }
        if (contentItem != null) {
            contentItem.closeOutputStream();
        }
    }

    protected void setupRequestHandler(HttpServletRequest request, HttpServletRequestHandler requestHandler) {
        String prompt = request.getParameter("prompt");
        String actionPath = request.getParameter("path");
        String processId = ((Object)((Object)this)).getClass().getName();
        String instanceId = request.getParameter("instance-id");
        requestHandler.setInstanceId(instanceId);
        requestHandler.setProcessId(processId);
        requestHandler.setActionPath(actionPath);
        requestHandler.setForcePrompt(prompt != null && prompt.equalsIgnoreCase("yes"));
    }

    protected void setupOutputHandler(HttpOutputHandler outputHandler, IParameterProvider requestParameters) {
        int outputPreference = 3;
        outputHandler.setOutputPreference(outputPreference);
    }

    protected HttpServletRequestHandler getRequestHandler(HttpServletRequest request, HttpServletResponse response, IPentahoSession userSession, IParameterProvider requestParameters, OutputStream outputStream, HttpOutputHandler outputHandler, SimpleUrlFactory urlFactory) throws ServletException, IOException {
        HttpServletRequestHandler requestHandler = new HttpServletRequestHandler(userSession, null, request, outputHandler, (IPentahoUrlFactory)urlFactory);
        this.setupRequestHandler(request, requestHandler, requestParameters, userSession);
        return requestHandler;
    }

    protected HttpOutputHandler createOutputHandler(HttpServletResponse response, OutputStream outputStream) {
        return new HttpOutputHandler(response, outputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PentahoSystem.systemEntryPoint();
        try {
            IPentahoSession userSession = this.getPentahoSession(request);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            String solutionName = request.getParameter("solution");
            String actionPath = request.getParameter("path");
            String actionName = request.getParameter("action");
            IActionSequence actionSequence = new ActionSequenceJCRHelper().getActionSequence(ActionInfo.buildSolutionPath((String)solutionName, (String)actionPath, (String)actionName), PentahoSystem.loggingLevel, RepositoryFilePermission.READ);
            String fileName = null;
            if (actionSequence != null) {
                String title = actionSequence.getTitle();
                if (title != null && title.length() > 0) {
                    fileName = title;
                } else {
                    String sequenceName = actionSequence.getSequenceName();
                    if (sequenceName != null && sequenceName.length() > 0) {
                        fileName = sequenceName;
                    } else {
                        List actionDefinitionsList = actionSequence.getActionDefinitionsAndSequences();
                        int i = 0;
                        boolean done = false;
                        while (actionDefinitionsList.size() > i && !done) {
                            IActionDefinition actionDefinition = (IActionDefinition)actionDefinitionsList.get(i);
                            String componentName = actionDefinition.getComponentName();
                            if (componentName != null && componentName.length() > 0) {
                                fileName = componentName;
                                done = true;
                                continue;
                            }
                            ++i;
                        }
                    }
                }
            }
            IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
            HttpOutputHandler outputHandler = this.createOutputHandler(response, outputStream);
            outputHandler.setSession(userSession);
            HttpMimeTypeListener listener = new HttpMimeTypeListener(request, response);
            listener.setName(fileName);
            outputHandler.setMimeTypeListener(listener);
            SimpleUrlFactory urlFactory = new SimpleUrlFactory(requestContext.getContextPath() + "SolutionEngineInteractivityService?");
            HttpRequestParameterProvider requestParameters = new HttpRequestParameterProvider(request);
            this.setupOutputHandler(outputHandler, (IParameterProvider)requestParameters);
            HttpServletRequestHandler requestHandler = this.getRequestHandler(request, response, userSession, (IParameterProvider)requestParameters, outputStream, outputHandler, urlFactory);
            this.handleActionRequest(request, response, outputHandler, requestHandler, (IParameterProvider)requestParameters, outputStream, null);
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void setupRequestHandler(HttpServletRequest request, HttpServletRequestHandler requestHandler, IParameterProvider requestParameters, IPentahoSession userSession) {
        this.setupRequestHandler(request, requestHandler);
        String actionName = requestParameters.getStringParameter("action2", null);
        if (actionName == null) {
            actionName = requestParameters.getStringParameter("action", null);
        }
        ISystemSettings systemSettings = PentahoSystem.getSystemSettings();
        String defaultParameterXsl = systemSettings.getSystemSetting("default-parameter-xsl", "DefaultParameterForm.xsl");
        requestHandler.setParameterXsl(defaultParameterXsl);
    }
}

