/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime;

import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeDataSchemaModelChangeTracker;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DefaultDesignTimeDataSchemaModelChangeTracker
implements DesignTimeDataSchemaModelChangeTracker {
    private final HashMap<InstanceID, Long> nonVisualChangeTrackers;
    private final HashMap<InstanceID, Long> dataFactoryChangeTrackers;
    private final AbstractReportDefinition parent;
    private String query;
    private int queryTimeout;

    public DefaultDesignTimeDataSchemaModelChangeTracker(AbstractReportDefinition parent) {
        this.parent = parent;
        this.nonVisualChangeTrackers = new HashMap();
        this.dataFactoryChangeTrackers = new HashMap();
        this.queryTimeout = parent.getQueryTimeout();
    }

    private boolean isNonVisualsChanged() {
        AbstractReportDefinition parent = this.parent;
        while (parent != null) {
            InstanceID id = parent.getObjectID();
            Long dataSourceChangeTracker = parent.getDatasourceChangeTracker();
            if (!dataSourceChangeTracker.equals(this.dataFactoryChangeTrackers.get(id))) {
                return true;
            }
            Long nonVisualsChangeTracker = parent.getNonVisualsChangeTracker();
            if (!nonVisualsChangeTracker.equals(this.nonVisualChangeTrackers.get(id))) {
                return true;
            }
            Section parentSection = parent.getParentSection();
            if (parentSection == null) {
                parent = null;
                continue;
            }
            parent = (AbstractReportDefinition)parentSection.getReportDefinition();
        }
        return false;
    }

    private boolean isDataFactoryChanged() {
        AbstractReportDefinition parent = this.parent;
        while (parent != null) {
            InstanceID id = parent.getObjectID();
            Long dataSourceChangeTracker = parent.getDatasourceChangeTracker();
            if (!dataSourceChangeTracker.equals(this.dataFactoryChangeTrackers.get(id))) {
                return true;
            }
            Section parentSection = parent.getParentSection();
            if (parentSection == null) {
                parent = null;
                continue;
            }
            parent = (AbstractReportDefinition)parentSection.getReportDefinition();
        }
        return false;
    }

    @Override
    public void updateChangeTrackers() {
        this.query = this.parent.getQuery();
        this.queryTimeout = this.parent.getQueryTimeout();
        AbstractReportDefinition parent = this.parent;
        while (parent != null) {
            InstanceID id = parent.getObjectID();
            this.dataFactoryChangeTrackers.put(id, parent.getDatasourceChangeTracker());
            this.nonVisualChangeTrackers.put(id, parent.getNonVisualsChangeTracker());
            Section parentSection = parent.getParentSection();
            if (parentSection == null) {
                parent = null;
                continue;
            }
            parent = (AbstractReportDefinition)parentSection.getReportDefinition();
        }
    }

    @Override
    public boolean isReportQueryChanged() {
        return !ObjectUtilities.equal((Object)this.query, (Object)this.parent.getQuery()) || this.queryTimeout != this.parent.getQueryTimeout() || this.isDataFactoryChanged();
    }

    @Override
    public boolean isReportChanged() {
        return this.isNonVisualsChanged() || !ObjectUtilities.equal((Object)this.query, (Object)this.parent.getQuery());
    }
}

